/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.executor.task;

import com.raplix.rolloutexpress.Application;
import com.raplix.rolloutexpress.ConfigurationException;
import com.raplix.rolloutexpress.UnsupportedSubsystemException;
import com.raplix.rolloutexpress.executor.ExecutionState;
import com.raplix.rolloutexpress.executor.PlanExecutionException;
import com.raplix.rolloutexpress.executor.RunLevel;
import com.raplix.rolloutexpress.executor.StepInfo;
import com.raplix.rolloutexpress.executor.task.ExecNativeOutput;
import com.raplix.rolloutexpress.executor.task.ExecNativeStepDescriptor;
import com.raplix.rolloutexpress.executor.task.TaskExecutor;
import com.raplix.rolloutexpress.executor.virtual.VirtualAgent;
import com.raplix.rolloutexpress.message.ROXMessage;
import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.systemmodel.plandb.ExecNativeStep;
import com.raplix.rolloutexpress.systemmodel.plandb.ExecStep;
import com.raplix.util.logger.Logger;

public class ExecNativeTaskExecutor
extends TaskExecutor {
    public ExecNativeTaskExecutor(Application inApp, ExecNativeStep inStep) {
        super(inApp, inStep);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void doTask(StepInfo inCurrentStep, ExecStep inGeneratedStep, ExecutionState inState, VirtualAgent inVirtualAgent) throws PlanExecutionException, RPCException {
        ExecNativeOutput output = null;
        ExecNativeStep theStepToUse = (ExecNativeStep)inGeneratedStep;
        String userToRunAs = inState.getTaskInfo().getUserToRunAs(theStepToUse);
        boolean passUserToRunAs = inVirtualAgent.shouldSpecifyUserToRunAs(userToRunAs);
        String assignOutput = theStepToUse.getAssignOutput();
        String assignError = theStepToUse.getAssignError();
        String assignStatus = theStepToUse.getAssignStatus();
        this.verifyVarCanBeAssigned(inState, assignOutput);
        this.verifyVarCanBeAssigned(inState, assignError);
        this.verifyVarCanBeAssigned(inState, assignStatus);
        ExecNativeStepDescriptor descriptor = null;
        try {
            try {
                int maxSnapshotBytes = this.mApp.getPlanSubsystem().getConfigMaxOutputSnapshotBytes();
                descriptor = new ExecNativeStepDescriptor(theStepToUse, inState.getTaskInfo().getNativeCallTimeoutSecs(), passUserToRunAs ? userToRunAs : null, maxSnapshotBytes);
                if (inState.getCurrPasswdSafeConfigGenerator() != null) {
                    descriptor.setCommandStringForErrMsg(((ExecNativeStep)this.generateStepPasswdSafe(inState)).getCommandStringForErrMsg());
                }
                descriptor.setTaskID(inState.getTaskID());
                descriptor.setStepID(inCurrentStep.getStepID());
                descriptor.setTargetID(inVirtualAgent.getTargetID());
                if (descriptor.getWorkingDir() == null && inState.getWorkingDirOverride() != null) {
                    descriptor.setWorkingDir(inState.getWorkingDirOverride());
                }
                if ((output = inVirtualAgent.execNative(descriptor)) != null && output.getStepFailed() != null) {
                    output.getStepFailed().fillInStackTrace();
                    throw new PlanExecutionException(output.getStepFailed());
                }
                Object var15_16 = null;
            }
            catch (UnsupportedSubsystemException e) {
                throw new PlanExecutionException(new ROXMessage("pe.ENATIVE_ERR_SNAPSHOT_MAX_BYTES", new Object[]{descriptor.getCommandStringForErrMsg()}), (Throwable)e);
            }
            catch (ConfigurationException e) {
                throw new PlanExecutionException(new ROXMessage("pe.ENATIVE_ERR_SNAPSHOT_MAX_BYTES", new Object[]{descriptor.getCommandStringForErrMsg()}), (Throwable)e);
            }
        }
        catch (Throwable throwable) {
            Object var15_17 = null;
            if (!inVirtualAgent.getRunLevel().equals(RunLevel.ACTUAL)) throw throwable;
            if (output == null) {
                String msg = new ROXMessage("pe.ENATIVE_OUTPUT_NOT_GRABBED").getMessageString();
                output = new ExecNativeOutput(inState.getTaskID(), inVirtualAgent.getTargetID(), inCurrentStep.getStepID(), msg, 0L, msg, 0L, null, true, true);
            }
            this.assignNewValue(assignOutput, output.isNoOutput() ? "" : output.getOutput(), inState);
            this.assignNewValue(assignError, output.isNoError() ? "" : output.getError(), inState);
            this.assignNewValue(assignStatus, output.getExitCode(), inState);
            try {
                if (Logger.isDebugEnabled(this)) {
                    Logger.debug("Saving output:" + output, this);
                }
                inState.getPlanRecorder().saveExecNativeOutput(output);
                throw throwable;
            }
            catch (PersistenceManagerException pme) {
                if (!Logger.isErrorEnabled(this)) throw new PlanExecutionException(new ROXMessage("pe.ENATIVE_ERR_SAVE_OUTPUT"), (Throwable)pme);
                Logger.error("Error saving output:" + output, this);
                throw new PlanExecutionException(new ROXMessage("pe.ENATIVE_ERR_SAVE_OUTPUT"), (Throwable)pme);
            }
        }
        if (!inVirtualAgent.getRunLevel().equals(RunLevel.ACTUAL)) return;
        if (output == null) {
            String msg = new ROXMessage("pe.ENATIVE_OUTPUT_NOT_GRABBED").getMessageString();
            output = new ExecNativeOutput(inState.getTaskID(), inVirtualAgent.getTargetID(), inCurrentStep.getStepID(), msg, 0L, msg, 0L, null, true, true);
        }
        this.assignNewValue(assignOutput, output.isNoOutput() ? "" : output.getOutput(), inState);
        this.assignNewValue(assignError, output.isNoError() ? "" : output.getError(), inState);
        this.assignNewValue(assignStatus, output.getExitCode(), inState);
        try {}
        catch (PersistenceManagerException pme) {
            if (!Logger.isErrorEnabled(this)) throw new PlanExecutionException(new ROXMessage("pe.ENATIVE_ERR_SAVE_OUTPUT"), (Throwable)pme);
            Logger.error("Error saving output:" + output, this);
            throw new PlanExecutionException(new ROXMessage("pe.ENATIVE_ERR_SAVE_OUTPUT"), (Throwable)pme);
        }
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("Saving output:" + output, this);
        }
        inState.getPlanRecorder().saveExecNativeOutput(output);
    }

    public String toString() {
        ROXMessage msg = new ROXMessage("pe.step.EXEC_NATIVE", new String[]{((ExecNativeStep)this.getOriginalStep()).getCommandStringForErrMsg()});
        return msg.toString();
    }
}

