/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.executor.task;

import com.raplix.rolloutexpress.ConfigurationException;
import com.raplix.rolloutexpress.command.NativePlatformIntegration;
import com.raplix.rolloutexpress.command.exceptions.CommandExecutionErrorException;
import com.raplix.rolloutexpress.command.impl.ExecNativeDescriptor;
import com.raplix.rolloutexpress.executor.PlanExecutorMessages;
import com.raplix.rolloutexpress.executor.StepID;
import com.raplix.rolloutexpress.executor.TaskID;
import com.raplix.rolloutexpress.executor.target.TargetID;
import com.raplix.rolloutexpress.executor.task.ExecNativeOutput;
import com.raplix.rolloutexpress.executor.task.OutputGeneratorStep;
import com.raplix.rolloutexpress.message.ROXMessage;
import com.raplix.rolloutexpress.net.rpc.RPCSerializable;
import com.raplix.rolloutexpress.systemmodel.plandb.ExecNativeStep;
import com.raplix.util.Util;
import com.raplix.util.file.CopyUtil;
import com.raplix.util.iowrappers.TempFile;
import com.raplix.util.logger.Logger;
import com.raplix.util.platform.common.PlatformUtil;
import com.raplix.util.platform.posix.Environ;
import com.raplix.util.platform.windows.WindowsServices;
import com.raplix.util.platform.windows.WindowsServicesException;
import com.raplix.util.regex.RegEx;
import com.raplix.util.regex.RegExSyntaxException;
import com.raplix.util.unicode.CachedMultibyteOutputStreamFilter;
import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Vector;

public class ExecNativeStepDescriptor
extends ExecNativeDescriptor
implements PlanExecutorMessages,
OutputGeneratorStep {
    private String mCmdStringForErrMsg;
    private transient OutputStream mOutputStream = null;
    private transient OutputStream mErrorStream = null;
    private OutputStreamHandler mOutputFile;
    private OutputStreamHandler mErrorFile;
    private InputStreamCreator mInput;
    private String[] mCmdArray;
    private String mDir;
    private String mUserToRunAs;
    private TaskID mTaskID;
    private TargetID mTargetID;
    private StepID mStepID;
    private ExecNativeStep mStep;
    private int mMaxOutputSnapshotBytes = 0;
    private transient CommandExecutionErrorException mFailedStep = null;
    private transient ExecNativeOutput mResult = null;
    private transient NativePlatformIntegration mSubsystem;
    private Vector mTempFileCreators = new Vector();
    private String mSubstituteLibraryPath = null;

    private ExecNativeStepDescriptor() {
    }

    public ExecNativeStepDescriptor(ExecNativeStep step, long timeout, String runAsUser) {
        this(step, timeout, runAsUser, 0);
    }

    public ExecNativeStepDescriptor(ExecNativeStep step, long timeout, String runAsUser, int inMaxOutputSnapshotBytes) {
        super(timeout);
        this.mStep = step;
        this.mDir = step.getDir();
        this.mUserToRunAs = runAsUser;
        this.mMaxOutputSnapshotBytes = inMaxOutputSnapshotBytes;
        if (step.getTimeout() != Long.MIN_VALUE) {
            this.setTimeoutSecs(step.getTimeout());
        }
        this.mOutputFile = this.initOutputFile();
        this.mErrorFile = this.initErrorFile();
        this.mInput = this.initInputFile();
        if (step.getExec() != null) {
            if (step.getArgs() == null || step.getArgs().length == 0) {
                this.mCmdArray = new String[]{step.getExec()};
            } else {
                this.mCmdArray = new String[step.getArgs().length + 1];
                this.mCmdArray[0] = step.getExec();
                System.arraycopy(step.getArgs(), 0, this.mCmdArray, 1, step.getArgs().length);
            }
        } else {
            String[] shellCmd = Util.parseCommandLine(step.getShell());
            this.mCmdArray = new String[shellCmd.length + 1];
            System.arraycopy(shellCmd, 0, this.mCmdArray, 0, shellCmd.length);
            this.mCmdArray[this.mCmdArray.length - 1] = step.getCommand();
        }
    }

    private InputStreamCreator initInputFile() {
        if (!this.getBackground()) {
            if (this.mStep.getInputFile() != null) {
                return new FileInputStreamCreator(this.mStep.getInputFile());
            }
            if (this.mStep.getInputText() != null) {
                return new ByteStreamCreator(this.mStep.getInputText().getBytes());
            }
        }
        return new ByteStreamCreator(new byte[0]);
    }

    private OutputStreamHandler initErrorFile() {
        if (!this.getBackground()) {
            if (this.mStep.getErrorFile() != null) {
                return new FileOutputStreamHandler(this.mStep.getErrorFile());
            }
            if (this.mStep.getErrorMatches() == null && this.mMaxOutputSnapshotBytes < 1) {
                return new NullOutputStreamHandler();
            }
        }
        return this.createTempFile();
    }

    private OutputStreamHandler initOutputFile() {
        if (!this.getBackground()) {
            if (this.mStep.getOutputFile() != null) {
                return new FileOutputStreamHandler(this.mStep.getOutputFile());
            }
            if (this.mStep.getOutputMatches() == null && this.mMaxOutputSnapshotBytes < 1) {
                return new NullOutputStreamHandler();
            }
        }
        return this.createTempFile();
    }

    public void preflightInit(NativePlatformIntegration inSubsystem) {
        this.mSubsystem = inSubsystem;
    }

    public File getFileForReadPermCheck() throws ConfigurationException {
        if (this.getBackground() && this.mStep.getInputFile() != null) {
            return ExecNativeStepDescriptor.resolveFileIntoWorkingDir(this.mStep.getInputFile(), this.getExecutionDir());
        }
        if (this.mInput instanceof FileInputStreamCreator) {
            return ((FileInputStreamCreator)this.mInput).getFile(this.getExecutionDir());
        }
        return null;
    }

    public File[] getFilesForWritePermCheck() throws ConfigurationException {
        Vector<File> files = new Vector<File>();
        File dir = this.getExecutionDir();
        if (this.getBackground()) {
            files.add(ExecNativeStepDescriptor.resolveFileIntoWorkingDir(this.mStep.getOutputFile(), this.getExecutionDir()));
            files.add(ExecNativeStepDescriptor.resolveFileIntoWorkingDir(this.mStep.getErrorFile(), this.getExecutionDir()));
        } else {
            if (this.mOutputFile instanceof FileOutputStreamHandler) {
                files.add(((FileOutputStreamHandler)this.mOutputFile).getFile(dir));
            }
            if (this.mErrorFile instanceof FileOutputStreamHandler) {
                files.add(((FileOutputStreamHandler)this.mErrorFile).getFile(dir));
            }
        }
        return files.toArray(new File[files.size()]);
    }

    public String getCommandNameForPermCheck() {
        return this.mCmdArray[0];
    }

    public String getCommandStringForErrMsg() {
        if (this.mCmdStringForErrMsg != null) {
            return this.mCmdStringForErrMsg;
        }
        return this.mCmdArray != null ? Util.getStringFromArray(this.mCmdArray, " ") : "";
    }

    void setCommandStringForErrMsg(String inCmdString) {
        this.mCmdStringForErrMsg = inCmdString;
    }

    public File getExecutionDir() throws ConfigurationException {
        return new File(this.mDir == null ? this.getSubsystem().getConfigWorkingDirOnAgent() : this.mDir);
    }

    public String getUserToRunAs() {
        return this.mUserToRunAs;
    }

    private static File resolveFileIntoWorkingDir(String fileName, File workingDir) {
        File file = new File(fileName);
        if (file.isAbsolute()) {
            return file;
        }
        return new File(workingDir, fileName);
    }

    protected void timedOut(CommandExecutionErrorException timeoutError) {
        this.mFailedStep = timeoutError;
    }

    protected void postProcess() throws CommandExecutionErrorException {
        try {
            this.checkSuccessCriteria();
        }
        catch (CommandExecutionErrorException ceee) {
            this.mFailedStep = ceee;
        }
    }

    protected final void checkSuccessCriteria() throws CommandExecutionErrorException {
        try {
            if (Logger.isDebugEnabled(this)) {
                Logger.debug("i:" + this.getInverseCriteria() + ":o:" + this.getOutputMatches() + ":e:" + this.getErrorMatches() + ":s:" + this.getExpectedStatus(), this);
            }
            if (this.getIgnoreCriteria()) {
                return;
            }
            if (this.getOutputMatches() != null && !(this.getInverseCriteria() ^ ExecNativeStepDescriptor.matchStream(this.mOutputFile.getInputStream(this.getExecutionDir()), this.getOutputMatches()))) {
                throw new CommandExecutionErrorException(new ROXMessage("pe.ENATIVE_OUTPUT_COND_FAILED", new Object[]{this.getOutputMatches(), new Double(this.getInverseCriteria() ? 0.0 : 1.0), this.getCommandStringForErrMsg()}));
            }
            if (this.getErrorMatches() != null && !(this.getInverseCriteria() ^ ExecNativeStepDescriptor.matchStream(this.mErrorFile.getInputStream(this.getExecutionDir()), this.getErrorMatches()))) {
                throw new CommandExecutionErrorException(new ROXMessage("pe.ENATIVE_ERROR_COND_FAILED", new Object[]{this.getErrorMatches(), new Double(this.getInverseCriteria() ? 0.0 : 1.0), this.getCommandStringForErrMsg()}));
            }
            if (this.getExpectedStatus() != Long.MAX_VALUE) {
                if (Logger.isDebugEnabled(this)) {
                    Logger.debug("Exit status:" + this.getExitStatus(), this);
                }
                if (!(this.getInverseCriteria() ^ this.getExitStatus() == this.getExpectedStatus())) {
                    throw new CommandExecutionErrorException(new ROXMessage("pe.ENATIVE_EXIT_COND_FAILED", new Object[]{String.valueOf(this.getExitStatus()), String.valueOf(this.getExpectedStatus()), new Double(this.getInverseCriteria() ? 0.0 : 1.0), this.getCommandStringForErrMsg()}));
                }
            }
        }
        catch (IOException ioe) {
            throw new CommandExecutionErrorException(new ROXMessage("pe.ENATIVE_COND_EVAL_ERROR", this.getCommandStringForErrMsg()), (Throwable)ioe);
        }
        catch (RegExSyntaxException rse) {
            throw new CommandExecutionErrorException(new ROXMessage("pe.ENATIVE_RE_MATCH_FAILURE", this.getCommandStringForErrMsg()), (Throwable)rse);
        }
        catch (ConfigurationException ce) {
            throw new CommandExecutionErrorException(new ROXMessage("pe.ENATIVE_COND_EVAL_ERROR", this.getCommandStringForErrMsg()), (Throwable)ce);
        }
    }

    protected Process createProcess() throws CommandExecutionErrorException {
        try {
            File dir;
            File tmp;
            if (Logger.isDebugEnabled(this)) {
                Logger.debug("Starting:" + this.getCommandStringForErrMsg(), this);
            }
            if (!(tmp = new File(dir = this.getExecutionDir(), ".")).exists()) {
                throw new CommandExecutionErrorException(new ROXMessage("pe.ENATIVE_WDIR_NOT_FOUND", dir.toString(), this.getCommandStringForErrMsg()));
            }
            String[] envVars = this.getEnvVars();
            Object[] cmdArray = this.getCmdArray(dir);
            if (Logger.isDebugEnabled(this)) {
                Logger.debug("Executing:" + Util.getStringFromArray(cmdArray, " "), this);
            }
            return Runtime.getRuntime().exec((String[])cmdArray, envVars, dir);
        }
        catch (IOException ioe) {
            throw new CommandExecutionErrorException(new ROXMessage("pe.ENATIVE_EXEC_PROCESS", this.getCommandStringForErrMsg()), (Throwable)ioe);
        }
        catch (ConfigurationException ce) {
            throw new CommandExecutionErrorException(new ROXMessage("pe.ENATIVE_EXEC_PROCESS", this.getCommandStringForErrMsg()), (Throwable)ce);
        }
        catch (WindowsServicesException wse) {
            throw new CommandExecutionErrorException(new ROXMessage("pe.ENATIVE_EXEC_PROCESS", this.getCommandStringForErrMsg()), (Throwable)wse);
        }
    }

    protected OutputStream getOutput() throws CommandExecutionErrorException {
        try {
            this.mOutputStream = new CachedMultibyteOutputStreamFilter(this.mOutputFile.getOutputStream(this.getExecutionDir()), this.getMaxOutputSnapshotBytes());
            return this.mOutputStream;
        }
        catch (IOException ioe) {
            throw new CommandExecutionErrorException(new ROXMessage("pe.ENATIVE_ERR_OUTPUT", this.getCommandStringForErrMsg()), (Throwable)ioe);
        }
        catch (ConfigurationException ce) {
            throw new CommandExecutionErrorException(new ROXMessage("pe.ENATIVE_ERR_OUTPUT", this.getCommandStringForErrMsg()), (Throwable)ce);
        }
    }

    protected InputStream getInput() throws CommandExecutionErrorException {
        try {
            return this.mInput.getStream(this.getExecutionDir());
        }
        catch (IOException ioe) {
            throw new CommandExecutionErrorException(new ROXMessage("pe.ENATIVE_ERR_INPUT", this.getCommandStringForErrMsg()), (Throwable)ioe);
        }
        catch (ConfigurationException ce) {
            throw new CommandExecutionErrorException(new ROXMessage("pe.ENATIVE_ERR_INPUT", this.getCommandStringForErrMsg()), (Throwable)ce);
        }
    }

    protected OutputStream getError() throws CommandExecutionErrorException {
        try {
            this.mErrorStream = new CachedMultibyteOutputStreamFilter(this.mErrorFile.getOutputStream(this.getExecutionDir()), this.getMaxOutputSnapshotBytes());
            return this.mErrorStream;
        }
        catch (IOException ioe) {
            throw new CommandExecutionErrorException(new ROXMessage("pe.ENATIVE_ERR_ERROR", this.getCommandStringForErrMsg()), (Throwable)ioe);
        }
        catch (ConfigurationException ce) {
            throw new CommandExecutionErrorException(new ROXMessage("pe.ENATIVE_ERR_ERROR", this.getCommandStringForErrMsg()), (Throwable)ce);
        }
    }

    void setTaskID(TaskID inTaskID) {
        this.mTaskID = inTaskID;
    }

    public TaskID getTaskID() {
        return this.mTaskID;
    }

    void setStepID(StepID inStepID) {
        this.mStepID = inStepID;
    }

    void setTargetID(TargetID inTargetID) {
        this.mTargetID = inTargetID;
    }

    public StepID getStepID() {
        return this.mStepID;
    }

    public int getMaxOutputSnapshotBytes() {
        return this.mMaxOutputSnapshotBytes;
    }

    protected String getWorkingDir() {
        return this.mDir;
    }

    protected void setWorkingDir(String inDir) {
        this.mDir = inDir;
    }

    private Hashtable getEnv() {
        return this.mStep.getEnv();
    }

    private String getOutputMatches() {
        return this.mStep.getOutputMatches();
    }

    private String getErrorMatches() {
        return this.mStep.getErrorMatches();
    }

    private long getExpectedStatus() {
        return this.mStep.getStatus();
    }

    private boolean getInverseCriteria() {
        return this.mStep.getInverse();
    }

    private boolean getIgnoreCriteria() {
        return this.mStep.getIgnore();
    }

    public boolean getBackground() {
        return this.mStep.getBackground();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean matchStream(InputStream is, String pattern) throws RegExSyntaxException, IOException {
        try {
            RegEx regex = new RegEx(pattern);
            boolean bl = regex.match(is);
            return bl;
        }
        finally {
            try {
                is.close();
            }
            catch (IOException ignored) {}
        }
    }

    private String[] getCmdArray(File executionDir) throws CommandExecutionErrorException {
        if (this.getUserToRunAs() == null && !this.getBackground()) {
            return this.mCmdArray;
        }
        LinkedList<String> cmdLine = new LinkedList<String>();
        cmdLine.add("-c");
        for (int i = 0; i < this.mCmdArray.length; ++i) {
            cmdLine.add(this.mCmdArray[i]);
        }
        if (this.getSubstituteLibraryPath() != null) {
            cmdLine.addFirst(this.getSubstituteLibraryPath());
            cmdLine.addFirst("-l");
        }
        if (this.getUserToRunAs() != null) {
            try {
                cmdLine.addFirst(this.getUserToRunAs());
                cmdLine.addFirst(this.getSubsystem().getConfigExecUserPathOnAgent());
            }
            catch (ConfigurationException ce) {
                throw new CommandExecutionErrorException(new ROXMessage("pe.ENATIVE_EXEC_USER_NOT_FOUND", this.getCommandStringForErrMsg()), (Throwable)ce);
            }
        }
        if (this.getBackground()) {
            try {
                File errorFile;
                if (this.getUserToRunAs() != null) {
                    cmdLine.addFirst("-c");
                }
                if (!this.canWriteOrCreate(errorFile = ExecNativeStepDescriptor.resolveFileIntoWorkingDir(this.mStep.getErrorFile(), executionDir))) {
                    throw new CommandExecutionErrorException(new ROXMessage("pe.ENATIVE_ERR_ERROR", this.getCommandStringForErrMsg()));
                }
                cmdLine.addFirst(errorFile.getAbsolutePath());
                cmdLine.addFirst("-e");
                File outputFile = ExecNativeStepDescriptor.resolveFileIntoWorkingDir(this.mStep.getOutputFile(), executionDir);
                if (!this.canWriteOrCreate(outputFile)) {
                    throw new CommandExecutionErrorException(new ROXMessage("pe.ENATIVE_ERR_OUTPUT", this.getCommandStringForErrMsg()));
                }
                cmdLine.addFirst(outputFile.getAbsolutePath());
                cmdLine.addFirst("-o");
                if (this.mStep.getInputFile() != null) {
                    File inputFile = ExecNativeStepDescriptor.resolveFileIntoWorkingDir(this.mStep.getInputFile(), executionDir);
                    if (!inputFile.canRead()) {
                        throw new CommandExecutionErrorException(new ROXMessage("pe.ENATIVE_ERR_INPUT", this.getCommandStringForErrMsg()));
                    }
                    cmdLine.addFirst(inputFile.getAbsolutePath());
                    cmdLine.addFirst("-i");
                } else if (this.mStep.getInputText() != null) {
                    File tempFile = File.createTempFile("CR_", "enative");
                    CopyUtil.writeText(this.mStep.getInputText().toCharArray(), tempFile.getAbsolutePath());
                    cmdLine.addFirst(tempFile.getAbsolutePath());
                    cmdLine.addFirst("-t");
                }
                cmdLine.addFirst(this.getSubsystem().getConfigExecBkgPathOnAgent());
            }
            catch (IOException e) {
                throw new CommandExecutionErrorException(new ROXMessage("pe.ENATIVE_EXEC_BKG_WRITE_INPUT", this.getCommandStringForErrMsg()), (Throwable)e);
            }
            catch (ConfigurationException e) {
                throw new CommandExecutionErrorException(new ROXMessage("pe.ENATIVE_EXEC_BKG_NOT_FOUND", this.getCommandStringForErrMsg()), (Throwable)e);
            }
        }
        return cmdLine.toArray(new String[cmdLine.size()]);
    }

    private boolean canWriteOrCreate(File file) {
        return file.exists() ? file.canWrite() : file.getParentFile() != null && file.getParentFile().canWrite();
    }

    private String[] getEnvVars() throws CommandExecutionErrorException, WindowsServicesException {
        Hashtable envTable;
        try {
            envTable = ExecNativeStepDescriptor.getCurrentEnvVars();
        }
        catch (InterruptedException ie) {
            throw new CommandExecutionErrorException(new ROXMessage("pe.ENATIVE_ERR_GET_ENV", this.getCommandStringForErrMsg()), (Throwable)ie);
        }
        Hashtable newEnvTable = (Hashtable)envTable.clone();
        Hashtable stepEnv = this.getEnv();
        if (stepEnv != null && !stepEnv.isEmpty()) {
            Iterator entries = this.getEnv().entrySet().iterator();
            while (entries.hasNext()) {
                Map.Entry entry = entries.next();
                if (PlatformUtil.isLinux() && entry.getKey().equals(PlatformUtil.getPlatformLibraryPathIndentifier()) && (this.getUserToRunAs() != null || this.getBackground())) {
                    this.setSubstituteLibraryPath(ExecNativeStepDescriptor.expandEnvVar((String)entry.getValue(), envTable));
                    continue;
                }
                newEnvTable.put(entry.getKey(), ExecNativeStepDescriptor.expandEnvVar((String)entry.getValue(), envTable));
            }
        }
        String[] returnValue = new String[newEnvTable.size()];
        Iterator iter = newEnvTable.entrySet().iterator();
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            buffer.setLength(0);
            buffer.append(entry.getKey().toString()).append("=").append(entry.getValue().toString());
            returnValue[i++] = buffer.toString();
        }
        return returnValue;
    }

    public static String expandEnvVar(String value, Hashtable envTable) {
        StringBuffer buffer = new StringBuffer();
        int start = 0;
        int lastEndIndex = 0;
        int end = 0;
        while (start < value.length() && (start = value.indexOf("${", start)) >= 0) {
            if (value.charAt(start + 2) == '{') {
                buffer.append(value.substring(lastEndIndex, start += 2));
                lastEndIndex = start + 1;
                continue;
            }
            end = value.indexOf("}", start);
            if (end < 0) break;
            String varName = value.substring(start + 2, end);
            String varValue = varName.trim().length() > 0 ? (String)envTable.get(varName.trim()) : null;
            buffer.append(value.substring(lastEndIndex, start));
            lastEndIndex = end + 1;
            if (varValue != null) {
                buffer.append(varValue);
            }
            ++start;
        }
        buffer.append(value.substring(lastEndIndex, value.length()));
        return buffer.toString();
    }

    private static Hashtable getCurrentEnvVars() throws InterruptedException, WindowsServicesException {
        String[] vars = PlatformUtil.isPOSIX() ? Environ.getEnviron() : WindowsServices.getInstance().getEnvironInfo();
        Hashtable<String, String> varTable = new Hashtable<String, String>();
        for (int i = 0; i < vars.length; ++i) {
            int sepIndex = vars[i].indexOf(61);
            if (sepIndex <= 0) continue;
            varTable.put(vars[i].substring(0, sepIndex), vars[i].substring(sepIndex + 1));
        }
        return varTable;
    }

    private TempOutputStreamHandler createTempFile() {
        TempOutputStreamHandler creator = new TempOutputStreamHandler();
        this.mTempFileCreators.add(creator);
        return creator;
    }

    protected void init(NativePlatformIntegration inSubsystem) throws CommandExecutionErrorException {
        this.mSubsystem = inSubsystem;
        this.mSubsystem.getOGStepManager().stepStarted(this);
        try {
            File dir = this.getExecutionDir();
            if (!dir.isAbsolute()) {
                throw new CommandExecutionErrorException(new ROXMessage("cmd.ENATIVE_WDIR_NOT_ABSOLUTE", dir.toString(), this.getCommandStringForErrMsg()));
            }
        }
        catch (ConfigurationException e) {
            new CommandExecutionErrorException(new ROXMessage("pe.ENATIVE_EXEC_PROCESS", this.getCommandStringForErrMsg()), (Throwable)e);
        }
    }

    private NativePlatformIntegration getSubsystem() {
        if (this.mSubsystem == null) {
            throw new IllegalStateException();
        }
        return this.mSubsystem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cleanUp() throws CommandExecutionErrorException {
        Enumeration e2;
        try {
            this.mResult = this.snapshotStreams();
            this.mResult.setStepFailed(this.mFailedStep);
            Object var2_1 = null;
            this.mSubsystem.getOGStepManager().stepCompleted(this);
            e2 = this.mTempFileCreators.elements();
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.mSubsystem.getOGStepManager().stepCompleted(this);
            Enumeration e2 = this.mTempFileCreators.elements();
            while (e2.hasMoreElements()) {
                ((TempOutputStreamHandler)e2.nextElement()).closeTempFile();
            }
            throw throwable;
        }
        while (e2.hasMoreElements()) {
            ((TempOutputStreamHandler)e2.nextElement()).closeTempFile();
        }
    }

    public ExecNativeOutput snapshotStreams() throws CommandExecutionErrorException {
        return this.snapshotStreams(this.getMaxOutputSnapshotBytes());
    }

    ExecNativeOutput snapshotStreams(int maxLength) throws CommandExecutionErrorException {
        if (this.mOutputStream != null) {
            try {
                this.mOutputStream.flush();
            }
            catch (IOException ignored) {
                // empty catch block
            }
        }
        if (this.mErrorStream != null) {
            try {
                this.mErrorStream.flush();
            }
            catch (IOException ignored) {
                // empty catch block
            }
        }
        try {
            String output = null;
            String error = null;
            int outIdx = 0;
            int errIdx = 0;
            boolean noOutput = false;
            boolean noError = false;
            if (maxLength > 0) {
                if (null != this.mOutputStream) {
                    output = ((CachedMultibyteOutputStreamFilter)this.mOutputStream).toString();
                    outIdx = ((CachedMultibyteOutputStreamFilter)this.mOutputStream).getCharsTruncated();
                }
                if (null != this.mErrorStream) {
                    error = ((CachedMultibyteOutputStreamFilter)this.mErrorStream).toString();
                    errIdx = ((CachedMultibyteOutputStreamFilter)this.mErrorStream).getCharsTruncated();
                }
                if (output == null || output.length() == 0) {
                    noOutput = true;
                    output = new ROXMessage("pe.ENATIVE_NO_STDOUT").getMessageString();
                }
                if (error == null || error.length() == 0) {
                    noError = true;
                    error = new ROXMessage("pe.ENATIVE_NO_STDERR").getMessageString();
                }
            } else {
                error = output = new ROXMessage("pe.ENATIVE_OUTPUT_SUPPRESSED").getMessageString();
                if (this.mOutputFile instanceof OutputStreamHandler && this.mOutputFile.length(this.getExecutionDir()) == 0L) {
                    noOutput = true;
                    output = new ROXMessage("pe.ENATIVE_NO_STDOUT").getMessageString();
                }
                if (this.mErrorFile instanceof OutputStreamHandler && this.mErrorFile.length(this.getExecutionDir()) == 0L) {
                    noError = true;
                    error = new ROXMessage("pe.ENATIVE_NO_STDERR").getMessageString();
                }
            }
            String exitStatus = this.getExitStatus() == Long.MAX_VALUE ? null : String.valueOf(this.getExitStatus());
            ExecNativeOutput returnValue = new ExecNativeOutput(this.mTaskID, this.mTargetID, this.mStepID, output, outIdx, error, errIdx, exitStatus, noOutput, noError);
            if (Logger.isDebugEnabled(this)) {
                Logger.debug("OutputSnapshot:" + returnValue, this);
            }
            return returnValue;
        }
        catch (IOException ioe) {
            throw new CommandExecutionErrorException(new ROXMessage("pe.ENATIVE_ERR_GRAB_SNAPSHOT", new Object[]{this.getCommandStringForErrMsg()}), (Throwable)ioe);
        }
        catch (ConfigurationException ce) {
            throw new CommandExecutionErrorException(new ROXMessage("pe.ENATIVE_ERR_GRAB_SNAPSHOT", new Object[]{this.getCommandStringForErrMsg()}), (Throwable)ce);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static String grabBytesFromFile(File file, long start, int nBytes) throws IOException {
        byte[] buffer;
        RandomAccessFile stream;
        block14: {
            stream = null;
            buffer = null;
            stream = new RandomAccessFile(file, "r");
            if (start != 0L) {
                stream.seek(start);
            }
            buffer = new byte[nBytes];
            stream.readFully(buffer);
            Object var8_5 = null;
            if (stream == null) break block14;
            try {
                stream.close();
            }
            catch (IOException ioe) {
                // empty catch block
            }
        }
        if (buffer != null) {
            return new String(buffer);
        }
        return "";
        {
            catch (EOFException ignore) {
                Object var8_6 = null;
                if (stream != null) {
                    try {
                        stream.close();
                    }
                    catch (IOException ioe) {
                        // empty catch block
                    }
                }
                if (buffer != null) {
                    return new String(buffer);
                }
                return "";
            }
        }
        catch (Throwable throwable) {
            Object var8_7 = null;
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException ioe) {
                    // empty catch block
                }
            }
            if (buffer != null) {
                return new String(buffer);
            }
            return "";
        }
    }

    public String toString() {
        return "ExecNative:Cmd:" + this.getCommandStringForErrMsg() + ":TaskID:" + this.mTaskID + ":TargetID:" + this.mTargetID;
    }

    protected RPCSerializable getResult() {
        return this.mResult;
    }

    private String getSubstituteLibraryPath() {
        return this.mSubstituteLibraryPath;
    }

    private void setSubstituteLibraryPath(String inPath) {
        this.mSubstituteLibraryPath = inPath;
    }

    private static class TempOutputStreamHandler
    extends AbstractFileOutputStreamHandler {
        private transient TempFile mTempFile;

        TempOutputStreamHandler() {
        }

        public synchronized File getFile(File executionDir) throws IOException {
            if (this.mTempFile == null) {
                this.mTempFile = new TempFile();
            }
            return this.mTempFile.getFile();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void closeTempFile() {
            try {
                this.mTempFile.close();
            }
            catch (Exception exception) {
            }
            finally {
                this.mTempFile = null;
            }
        }
    }

    private static class NullOutputStreamHandler
    implements OutputStreamHandler,
    RPCSerializable {
        private long mNumBytes;

        private NullOutputStreamHandler() {
        }

        public OutputStream getOutputStream(File executionDir) throws IOException {
            return new OutputStream(){

                public void write(byte[] b) {
                    mNumBytes += b.length;
                }

                public void write(byte[] b, int off, int len) {
                    mNumBytes += len;
                }

                public void write(int b) {
                    mNumBytes++;
                }
            };
        }

        public InputStream getInputStream(File executionDir) throws IOException {
            return new ByteArrayInputStream(new byte[0]);
        }

        public long length(File executionDir) {
            return this.mNumBytes;
        }
    }

    private static class FileOutputStreamHandler
    extends AbstractFileOutputStreamHandler {
        private String mFileName;

        FileOutputStreamHandler(String name) {
            this.mFileName = name;
        }

        public File getFile(File executionDir) {
            return ExecNativeStepDescriptor.resolveFileIntoWorkingDir(this.mFileName, executionDir);
        }

        private FileOutputStreamHandler() {
        }
    }

    private static abstract class AbstractFileOutputStreamHandler
    implements OutputStreamHandler {
        public OutputStream getOutputStream(File executionDir) throws IOException {
            return new FileOutputStream(this.getFile(executionDir));
        }

        public InputStream getInputStream(File executionDir) throws IOException {
            return new FileInputStream(this.getFile(executionDir));
        }

        public long length(File executionDir) throws IOException {
            return this.getFile(executionDir).length();
        }

        public abstract File getFile(File var1) throws IOException;

        protected AbstractFileOutputStreamHandler() {
        }
    }

    private static interface OutputStreamHandler
    extends RPCSerializable {
        public OutputStream getOutputStream(File var1) throws IOException;

        public InputStream getInputStream(File var1) throws IOException;

        public long length(File var1) throws IOException;
    }

    private static class FileInputStreamCreator
    implements InputStreamCreator,
    RPCSerializable {
        private String mFileName;

        FileInputStreamCreator(String fileName) {
            this.mFileName = fileName;
        }

        public InputStream getStream(File executionDir) throws IOException {
            return new FileInputStream(this.getFile(executionDir));
        }

        public File getFile(File executionDir) {
            return ExecNativeStepDescriptor.resolveFileIntoWorkingDir(this.mFileName, executionDir);
        }

        private FileInputStreamCreator() {
        }
    }

    private static class ByteStreamCreator
    implements InputStreamCreator {
        private byte[] mBytes;

        ByteStreamCreator(byte[] inBytes) {
            this.mBytes = inBytes;
        }

        public InputStream getStream(File executionDir) throws IOException {
            return new ByteArrayInputStream(this.mBytes);
        }

        private ByteStreamCreator() {
        }
    }

    private static interface InputStreamCreator
    extends RPCSerializable {
        public InputStream getStream(File var1) throws IOException;
    }
}

