/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.executor.task;

import com.raplix.rolloutexpress.command.exceptions.CommandExecutionErrorException;
import com.raplix.rolloutexpress.executor.StepID;
import com.raplix.rolloutexpress.executor.StepInfo;
import com.raplix.rolloutexpress.executor.TaskID;
import com.raplix.rolloutexpress.executor.target.TargetID;
import com.raplix.rolloutexpress.executor.task.ExecNativeOutputID;
import com.raplix.rolloutexpress.net.rpc.RPCSerializable;
import com.raplix.rolloutexpress.persist.PersistentBean;
import com.raplix.rolloutexpress.persist.ReEntrantTransaction;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.util.string.DBEscape;

public class ExecNativeOutput
extends PersistentBean
implements RPCSerializable {
    private String mStdOut;
    private long mOutStartIdx;
    private String mStdErr;
    private long mErrStartIdx;
    private String mExitCode;
    private TaskID mTaskID;
    private TargetID mTargetID;
    private StepID mStepID;
    private CommandExecutionErrorException mStepFailed = null;
    private boolean mNoOutput = false;
    private boolean mNoError = false;

    public static boolean isOutputStep(StepInfo inStep) {
        return inStep.getStepType() == 103 || inStep.getStepType() == 123;
    }

    public ExecNativeOutputID getID() {
        return (ExecNativeOutputID)this.getObjectID();
    }

    public String getOutput() {
        return this.mStdOut;
    }

    public long getOutStartIdx() {
        return this.mOutStartIdx;
    }

    public String getError() {
        return this.mStdErr;
    }

    public long getErrorStartIdx() {
        return this.mErrStartIdx;
    }

    public String getExitCode() {
        return this.mExitCode;
    }

    public TaskID getTaskID() {
        return this.mTaskID;
    }

    public TargetID getTargetID() {
        return this.mTargetID;
    }

    public StepID getStepID() {
        return this.mStepID;
    }

    public CommandExecutionErrorException getStepFailed() {
        return this.mStepFailed;
    }

    public boolean equals(Object object) {
        try {
            ExecNativeOutput rhs = (ExecNativeOutput)object;
            return (this.getOutput() == null ? null == rhs.getOutput() : this.getOutput().equals(rhs.getOutput())) && this.getOutStartIdx() == rhs.getOutStartIdx() && (this.getError() == null ? null == rhs.getError() : this.getError().equals(rhs.getError())) && this.getErrorStartIdx() == rhs.getErrorStartIdx() && (this.getExitCode() == null ? null == rhs.getExitCode() : this.getExitCode().equals(rhs.getExitCode())) && (this.getTaskID() == null ? null == rhs.getTaskID() : this.getTaskID().equals(rhs.getTaskID())) && (this.getTargetID() == null ? null == rhs.getTargetID() : this.getTargetID().equals(rhs.getTargetID())) && (this.getStepID() == null ? null == rhs.getStepID() : this.getStepID().equals(rhs.getStepID()));
        }
        catch (ClassCastException cce) {
            return false;
        }
        catch (NullPointerException npe) {
            return false;
        }
    }

    void setStepFailed(CommandExecutionErrorException inStepFailed) {
        this.mStepFailed = inStepFailed;
    }

    private ExecNativeOutput() {
    }

    public ExecNativeOutput(TaskID inTaskID, TargetID inTargetID, StepID inStepID, String inStdOut, long inOutStartIdx, String inStdErr, long inErrStartIdx, String inExitCode) {
        this(inTaskID, inTargetID, inStepID, inStdOut, inOutStartIdx, inStdErr, inErrStartIdx, inExitCode, false, false);
    }

    public ExecNativeOutput(TaskID inTaskID, TargetID inTargetID, StepID inStepID, String inStdOut, long inOutStartIdx, String inStdErr, long inErrStartIdx, String inExitCode, boolean inNoOutput, boolean inNoError) {
        this.mTaskID = inTaskID;
        this.mTargetID = inTargetID;
        this.mStepID = inStepID;
        this.mStdOut = inStdOut;
        this.mOutStartIdx = inOutStartIdx;
        this.mErrStartIdx = inErrStartIdx;
        this.mStdErr = inStdErr;
        this.mExitCode = inExitCode;
        this.mNoOutput = inNoOutput;
        this.mNoError = inNoError;
    }

    public ExecNativeOutput(TaskID inTaskID, TargetID inTargetID, StepID inStepID) {
        this(inTaskID, inTargetID, inStepID, null, 0L, null, 0L, null);
    }

    public void save() throws PersistenceManagerException {
        ExecNativeOutput.retryOnDeadlock(new ReEntrantSave(this));
    }

    public String toString() {
        return "ExecNativeOutput:stdout:" + this.mStdOut + ":stderr:" + this.mStdErr + ":exitCode:" + this.mExitCode;
    }

    private String getDBStdOutput() {
        return DBEscape.getGlobalInstance().escape(this.mStdOut);
    }

    private void setDBStdOutput(String str) {
        this.mStdOut = DBEscape.getGlobalInstance().unescape(str);
    }

    private String getDBStdError() {
        return DBEscape.getGlobalInstance().escape(this.mStdErr);
    }

    private void setDBStdError(String str) {
        this.mStdErr = DBEscape.getGlobalInstance().unescape(str);
    }

    boolean isNoOutput() {
        return this.mNoOutput;
    }

    boolean isNoError() {
        return this.mNoError;
    }

    private static class ReEntrantSave
    implements ReEntrantTransaction {
        private ExecNativeOutput mOutput;

        ReEntrantSave(ExecNativeOutput inOutput) {
            this.mOutput = inOutput;
        }

        public Object execute() throws PersistenceManagerException {
            this.mOutput.safeSaveMS(null);
            return null;
        }
    }
}

