/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.executor.task;

import com.raplix.rolloutexpress.Application;
import com.raplix.rolloutexpress.ConfigurationException;
import com.raplix.rolloutexpress.UnsupportedSubsystemException;
import com.raplix.rolloutexpress.command.exceptions.CommandExecutionErrorException;
import com.raplix.rolloutexpress.command.rpcinterfaces.ExecJavaStepDescriptor;
import com.raplix.rolloutexpress.executor.ExecutionState;
import com.raplix.rolloutexpress.executor.PlanExecutionException;
import com.raplix.rolloutexpress.executor.StepInfo;
import com.raplix.rolloutexpress.executor.task.ExecNativeOutput;
import com.raplix.rolloutexpress.executor.task.OutputGeneratorStep;
import com.raplix.rolloutexpress.executor.task.OutputGeneratorStepExecManager;
import com.raplix.rolloutexpress.executor.task.TaskExecutor;
import com.raplix.rolloutexpress.executor.virtual.VirtualAgent;
import com.raplix.rolloutexpress.message.ROXMessage;
import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.systemmodel.plandb.ExecJavaStep;
import com.raplix.rolloutexpress.systemmodel.plandb.ExecStep;

public class ExecJavaTaskExecutor
extends TaskExecutor {
    public ExecJavaTaskExecutor(Application inApp, ExecJavaStep inOrigStep) {
        super(inApp, inOrigStep);
    }

    protected void doTask(StepInfo inStepInfo, ExecStep inGeneratedStep, ExecutionState inState, VirtualAgent inVirtualAgent) throws RPCException, PlanExecutionException {
        ExecJavaStep javaStep = (ExecJavaStep)inGeneratedStep;
        ExecNativeOutput output = null;
        String assignOutput = javaStep.getAssignOutput();
        String assignError = javaStep.getAssignError();
        try {
            try {
                this.verifyVarCanBeAssigned(inState, assignOutput);
                this.verifyVarCanBeAssigned(inState, assignError);
                int maxSnapshotBytes = this.mApp.getPlanSubsystem().getConfigMaxOutputSnapshotBytes();
                long timeout = javaStep.getTimeout();
                timeout = timeout == Long.MIN_VALUE ? (long)inState.getTaskInfo().getNativeCallTimeoutSecs() : timeout;
                ExecJavaStepDescriptor descriptor = new ExecJavaStepDescriptor(javaStep.getClassPath(), javaStep.getClassName(), javaStep.getArgs(), timeout, maxSnapshotBytes, inState.getTaskID(), inStepInfo.getStepID(), inVirtualAgent.getTargetID());
                output = inVirtualAgent.execJava(inState, descriptor);
            }
            catch (UnsupportedSubsystemException use) {
                throw new PlanExecutionException(new ROXMessage("pe.EJAVA_SYSTEM_ERROR"), (Throwable)use);
            }
            catch (ConfigurationException ce) {
                throw new PlanExecutionException(new ROXMessage("pe.EJAVA_SYSTEM_ERROR"), (Throwable)ce);
            }
            Object var14_14 = null;
            if (output == null) {
                output = new ExecNativeOutput(inState.getTaskID(), inVirtualAgent.getTargetID(), inStepInfo.getStepID(), "", 0L, "", 0L, null, true, true);
            }
            this.assignNewValue(assignOutput, output.isNoOutput() ? "" : output.getOutput(), inState);
        }
        catch (Throwable throwable) {
            Object var14_15 = null;
            if (output == null) {
                output = new ExecNativeOutput(inState.getTaskID(), inVirtualAgent.getTargetID(), inStepInfo.getStepID(), "", 0L, "", 0L, null, true, true);
            }
            this.assignNewValue(assignOutput, output.isNoOutput() ? "" : output.getOutput(), inState);
            this.assignNewValue(assignError, output.isNoError() ? "" : output.getError(), inState);
            throw throwable;
        }
        this.assignNewValue(assignError, output.isNoError() ? "" : output.getError(), inState);
    }

    public String toString() {
        ROXMessage msg = new ROXMessage("pe.step.EXEC_JAVA", new String[]{((ExecJavaStep)this.getOriginalStep()).getClassName()});
        return msg.toString();
    }

    public static void stepStarted(OutputGeneratorStepExecManager inMgr, OutputGeneratorStep inOG) {
        inMgr.stepStarted(inOG);
    }

    public static void stepCompleted(OutputGeneratorStepExecManager inMgr, OutputGeneratorStep inOG) {
        inMgr.stepCompleted(inOG);
    }

    public static void stepFailed(ExecNativeOutput inOutput, CommandExecutionErrorException cee) {
        inOutput.setStepFailed(cee);
    }
}

