/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.executor.task;

import com.raplix.rolloutexpress.executor.task.FileType;
import com.raplix.util.file.FileInfo;
import com.raplix.util.minidb.ReadOnlyTable;
import com.raplix.util.minidb.WritableTable;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;

public class DirectoryListing {
    private Hashtable mFiles = new Hashtable();
    public static int MINIDB_COLUMN_COUNT = 2;

    public static DirectoryListing generate(File directory) throws IllegalArgumentException {
        File[] contents = directory.listFiles();
        FileType fileType = null;
        if (contents != null) {
            DirectoryListing listing = new DirectoryListing();
            for (int i = 0; i < contents.length; ++i) {
                File file = contents[i];
                FileInfo info = new FileInfo(file);
                if (info.isLink()) {
                    fileType = FileType.SYM_LINK;
                } else if (info.isDirectory()) {
                    fileType = FileType.DIRECTORY;
                } else {
                    if (!info.isPlain()) continue;
                    fileType = FileType.FILE;
                }
                listing.addEntry(file.getName(), fileType);
            }
            return listing;
        }
        return null;
    }

    public static DirectoryListing readFrom(File miniDbFile) throws IOException {
        ReadOnlyTable table = new ReadOnlyTable(miniDbFile.getAbsolutePath(), MINIDB_COLUMN_COUNT);
        String[] keys = table.getKeys();
        DirectoryListing listing = new DirectoryListing();
        for (int i = 0; i < keys.length; ++i) {
            listing.addEntry(keys[i], FileType.FACTORY.get(table.query(keys[i])[1]));
        }
        return listing;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeTo(File miniDbFile) throws IOException {
        WritableTable table = new WritableTable(miniDbFile.getAbsolutePath(), MINIDB_COLUMN_COUNT);
        try {
            Iterator entries = this.mFiles.entrySet().iterator();
            Map.Entry entry = null;
            while (entries.hasNext()) {
                entry = entries.next();
                table.insert(new String[]{(String)entry.getKey(), ((FileType)entry.getValue()).toString()});
            }
        }
        finally {
            table.commit();
        }
    }

    public Enumeration fileList() {
        return this.mFiles.keys();
    }

    public boolean contains(String name) {
        return this.mFiles.containsKey(name);
    }

    public FileType getFileType(String name) {
        return (FileType)this.mFiles.get(name);
    }

    public Iterator entryIterator() {
        return this.mFiles.entrySet().iterator();
    }

    public int size() {
        return this.mFiles.size();
    }

    public int hashCode() {
        return this.mFiles.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof DirectoryListing) {
            return this.mFiles.equals(((DirectoryListing)obj).mFiles);
        }
        return false;
    }

    public String toString() {
        return this.mFiles.toString();
    }

    private DirectoryListing() {
    }

    protected void addEntry(String path, FileType inType) {
        this.mFiles.put(path, inType);
    }
}

