/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.executor.task;

import com.raplix.rolloutexpress.Application;
import com.raplix.rolloutexpress.executor.ComponentInstallData;
import com.raplix.rolloutexpress.executor.ExecutionState;
import com.raplix.rolloutexpress.executor.MultiStepExecutor;
import com.raplix.rolloutexpress.executor.PlanExecutionException;
import com.raplix.rolloutexpress.executor.StepInfo;
import com.raplix.rolloutexpress.executor.task.DeploySystemServicesStep;
import com.raplix.rolloutexpress.executor.task.InstallSystemServiceStep;
import com.raplix.rolloutexpress.executor.task.TaskExecutor;
import com.raplix.rolloutexpress.executor.virtual.VirtualAgent;
import com.raplix.rolloutexpress.message.ROXMessage;
import com.raplix.rolloutexpress.net.rpc.CommandException;
import com.raplix.rolloutexpress.systemmodel.componentdb.Component;
import com.raplix.rolloutexpress.systemmodel.componentdb.MultiSystemServiceRefQuery;
import com.raplix.rolloutexpress.systemmodel.componentdb.SystemServiceRef;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostID;
import com.raplix.rolloutexpress.systemmodel.plandb.Caller;
import com.raplix.rolloutexpress.systemmodel.plandb.DefaultRepoTargeter;
import com.raplix.rolloutexpress.systemmodel.plandb.ExecStep;
import com.raplix.rolloutexpress.systemmodel.plandb.InstallStep;
import com.raplix.rolloutexpress.systemmodel.plandb.RepoComponentTargeter;
import com.raplix.util.logger.Logger;

public class DeploySystemServicesTaskExecutor
extends TaskExecutor {
    public DeploySystemServicesTaskExecutor(Application inApp, DeploySystemServicesStep inStep) {
        super(inApp, inStep);
    }

    protected void doTask(StepInfo inCurrentStep, ExecStep inGeneratedStep, ExecutionState inState, VirtualAgent inVirtualAgent) throws PlanExecutionException, InterruptedException {
        HostID pHostID = inVirtualAgent.getTarget().getPhysicalHostID();
        SystemServiceRef[] refsToInstall = null;
        try {
            refsToInstall = MultiSystemServiceRefQuery.byUninstalled(pHostID).select();
        }
        catch (CommandException ex) {
            throw new PlanExecutionException(ex);
        }
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("Found " + refsToInstall.length + " sysRefs to install", this);
        }
        ExecStep[] theSteps = new InstallStep[refsToInstall.length];
        for (int i = 0; i < refsToInstall.length; ++i) {
            Component comp = this.getComponentFromRef(refsToInstall[i].getInstalledComponentRef());
            theSteps[i] = new InstallSystemServiceStep((RepoComponentTargeter)new DefaultRepoTargeter(refsToInstall[i].getInstalledComponentRef(), null), "default", new Caller(null, comp, comp));
            ((InstallStep)theSteps[i]).setClientData(new ComponentInstallData(comp, null));
            if (!Logger.isDebugEnabled(this)) continue;
            Logger.debug("need to install sysRef: " + refsToInstall[i].getInstalledComponentRef(), this);
        }
        this.setReturnStep(MultiStepExecutor.execMultiSteps(inCurrentStep, theSteps, inState, 0, inVirtualAgent, this.getTaskExecutorFactory(null)));
    }

    public String toString() {
        ROXMessage msg = new ROXMessage("pe.step.DEPLOY_SYSTEM_SERVICES");
        return msg.toString();
    }
}

