/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.executor.task;

import com.raplix.rolloutexpress.Application;
import com.raplix.rolloutexpress.RaplixException;
import com.raplix.rolloutexpress.config.ComponentConfigManager;
import com.raplix.rolloutexpress.config.ConfigGenException;
import com.raplix.rolloutexpress.config.ConfigGenerator;
import com.raplix.rolloutexpress.executor.ComponentInstallData;
import com.raplix.rolloutexpress.executor.ExecutionState;
import com.raplix.rolloutexpress.executor.PlanExecutionException;
import com.raplix.rolloutexpress.executor.PlanExecutionPreflightWarning;
import com.raplix.rolloutexpress.executor.ResourceEventData;
import com.raplix.rolloutexpress.executor.StepInfo;
import com.raplix.rolloutexpress.executor.task.ResourceTaskExecutorBase;
import com.raplix.rolloutexpress.executor.virtual.VirtualAgent;
import com.raplix.rolloutexpress.message.ROXMessage;
import com.raplix.rolloutexpress.net.rpc.CommandException;
import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.resource.AddrGroup;
import com.raplix.rolloutexpress.resource.PushID;
import com.raplix.rolloutexpress.resource.ResourceID;
import com.raplix.rolloutexpress.resource.RsrcGroup;
import com.raplix.rolloutexpress.resource.RsrcInfo;
import com.raplix.rolloutexpress.resource.RsrcPush;
import com.raplix.rolloutexpress.systemmodel.componentdb.Component;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentID;
import com.raplix.rolloutexpress.systemmodel.componentdb.ResourceDefinition;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostID;
import com.raplix.rolloutexpress.systemmodel.installdb.InstalledComponent;
import com.raplix.rolloutexpress.systemmodel.installdb.InstalledResource;
import com.raplix.rolloutexpress.systemmodel.plandb.Caller;
import com.raplix.rolloutexpress.systemmodel.plandb.DeployResourceStep;
import com.raplix.rolloutexpress.systemmodel.plandb.ExecStep;
import com.raplix.util.logger.Logger;

public class DeployResourcesTaskExecutor
extends ResourceTaskExecutorBase {
    public DeployResourcesTaskExecutor(Application inApp, DeployResourceStep inStep) {
        super(inApp, inStep);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doTask(StepInfo inCurrentStep, ExecStep inGeneratedStep, ExecutionState inState, VirtualAgent inVirtualAgent) throws PlanExecutionException, RPCException, InterruptedException {
        block14: {
            try {
                InstalledComponent theInstalledComp = inState.getCurrInstalledComponent();
                if (theInstalledComp == null) {
                    throw new PlanExecutionException("pe.NO_COMP_TO_DEPLOY");
                }
                ComponentInstallData theData = inState.getCurrCID();
                Component component = theData.getComponent();
                ComponentConfigManager theConfigManager = theData.getConfigManager();
                RsrcInfo[] allRsrcInfos = this.getComponentRsrcInfos(component);
                int nRsrc = allRsrcInfos.length;
                if (nRsrc > 0) {
                    ResourceDefinition[] theResourceDefs = new ResourceDefinition[]{component.getResourceInstallSpec()};
                    this.configGenResourceDefs(theResourceDefs, theConfigManager, component, inVirtualAgent, inState);
                    RsrcGroup group = new RsrcGroup();
                    AddrGroup addr = new AddrGroup();
                    addr.add(inVirtualAgent.getHostRAAddress());
                    HostID theHostID = inVirtualAgent.getTarget().getPhysicalHostID();
                    ConfigGenerator theConfigGenerator = this.getRsrcConfigGenerator(theConfigManager, theInstalledComp, component);
                    for (int i = 0; i < nRsrc; ++i) {
                        boolean isDifferential;
                        String theDeployPath = null;
                        Boolean theDiffBool = theResourceDefs[i].getDifferentialDeploy();
                        boolean bl = isDifferential = theDiffBool == null ? false : theDiffBool;
                        if (isDifferential) {
                            theDeployPath = theResourceDefs[i].getFullTargetPath();
                        }
                        this.prepareRsrcForDeploy(inVirtualAgent, group, allRsrcInfos[i], theConfigGenerator, theDeployPath, component.getID());
                    }
                    ResourceID[] theResourceIDs = group.getResourceIDArray();
                    InstalledResource[] theInstalledResources = new InstalledResource[theResourceIDs.length];
                    for (int i = 0; i < theInstalledResources.length; ++i) {
                        theInstalledResources[i] = inVirtualAgent.createInstalledResource(inState, theInstalledComp.getID(), theResourceIDs[i], theResourceDefs[i].getFullTargetPath());
                    }
                    RsrcPush push = inVirtualAgent.createPush(group, theHostID, inState.getResourceSubsystem());
                    try {
                        inVirtualAgent.pushFilesToAgent(push);
                        PushID pushID = push == null ? null : push.getPushID();
                        inVirtualAgent.installDeployedResources(new ResourceEventData(inState.getDefaultParentDirUser(), inState.getDefaultParentDirGroup()), theResourceDefs, theInstalledResources, pushID);
                        break block14;
                    }
                    finally {
                        inVirtualAgent.disposeOfPush(push);
                    }
                }
                if (Logger.isDebugEnabled(this)) {
                    Logger.debug("No resources to install for comp " + component.getName(), this);
                }
            }
            catch (PlanExecutionPreflightWarning pew) {
                throw pew;
            }
            catch (PlanExecutionException pex) {
                throw pex;
            }
            catch (RaplixException ex) {
                if (Logger.isErrorEnabled(this)) {
                    Logger.error(ex.getMessage(), ex, this);
                }
                throw new PlanExecutionException(ex);
            }
        }
    }

    public String toString() {
        return new ROXMessage("pe.step.DEPLOY_RSRC", this.mCompName).toString();
    }

    private void prepareRsrcForDeploy(VirtualAgent inVirtualAgent, RsrcGroup inGroup, RsrcInfo inRsrcInfo, ConfigGenerator inGenerator, String inDeployPath, ComponentID inCompID) throws PlanExecutionException, CommandException {
        String rsrcName = inRsrcInfo.getResourceSpec().getName();
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("Preparing resource: " + rsrcName + " type " + inRsrcInfo.getTypeName() + " for deploy", this);
        }
        ResourceID id = null;
        if (inRsrcInfo.getConfigurable()) {
            if (Logger.isDebugEnabled(this)) {
                Logger.debug("customizing config file: " + rsrcName, this);
            }
            id = this.generateCustomFile(inVirtualAgent, inRsrcInfo, inGenerator, inCompID);
        } else {
            id = inRsrcInfo.getResourceID();
        }
        inGroup.add(id, inDeployPath);
    }

    private ConfigGenerator getRsrcConfigGenerator(ComponentConfigManager inCGMgr, InstalledComponent inIComp, Component inComp) throws PlanExecutionException {
        Component declaringComp = inComp;
        while (declaringComp.getLocalResource() == null) {
            declaringComp = declaringComp.getExtendsType().getComponent();
        }
        try {
            return inCGMgr.newCallerScope(new Caller(inIComp, inComp, declaringComp));
        }
        catch (ConfigGenException e) {
            throw new PlanExecutionException(e);
        }
    }

    private ResourceID generateCustomFile(VirtualAgent inVirtualAgent, RsrcInfo inRsrcInfo, ConfigGenerator inGenerator, ComponentID inCompID) throws PlanExecutionException {
        try {
            byte[] customized = inVirtualAgent.generateCustomizedFile(inRsrcInfo, inGenerator, inCompID);
            ResourceID customID = inVirtualAgent.checkCustomFileIntoRepo(inRsrcInfo, customized);
            return customID;
        }
        catch (PlanExecutionPreflightWarning ex) {
            throw ex;
        }
        catch (Exception ex) {
            String rsrcName = inRsrcInfo.getResourceSpec().getName();
            if (Logger.isErrorEnabled(this)) {
                Logger.error("Unable to generate customized file for " + rsrcName + " on host " + inVirtualAgent.getHostData().getHostName(), ex, this);
            }
            throw new PlanExecutionException("pe.ERR_CG_HOST", (Throwable)ex, new Object[]{rsrcName, inVirtualAgent.getHostData().getHostName()});
        }
    }
}

