/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.executor.task;

import com.raplix.rolloutexpress.Application;
import com.raplix.rolloutexpress.config.ConfigGenerator;
import com.raplix.rolloutexpress.executor.ExecutionState;
import com.raplix.rolloutexpress.executor.MultiStepExecutor;
import com.raplix.rolloutexpress.executor.PlanAbortException;
import com.raplix.rolloutexpress.executor.PlanExecutionException;
import com.raplix.rolloutexpress.executor.PlanTimeoutException;
import com.raplix.rolloutexpress.executor.StepInfo;
import com.raplix.rolloutexpress.executor.snapshot.AllGatherer;
import com.raplix.rolloutexpress.executor.snapshot.SnapshotCaptureContext;
import com.raplix.rolloutexpress.executor.snapshot.SnapshotItemGatherer;
import com.raplix.rolloutexpress.executor.snapshot.SnapshotStepsContext;
import com.raplix.rolloutexpress.executor.target.TargetType;
import com.raplix.rolloutexpress.executor.task.RetargetingTaskExecutorBase;
import com.raplix.rolloutexpress.executor.task.SnapshotUtil;
import com.raplix.rolloutexpress.executor.task.TaskExecutor;
import com.raplix.rolloutexpress.executor.virtual.VirtualAgent;
import com.raplix.rolloutexpress.message.ROXMessage;
import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.systemmodel.installdb.SnapshotID;
import com.raplix.rolloutexpress.systemmodel.plandb.CreateSnapshotStep;
import com.raplix.rolloutexpress.systemmodel.plandb.ExecStep;
import com.raplix.util.logger.Logger;

public class CreateSnapshotTaskExecutor
extends TaskExecutor {
    private int mLastPrepareAttempted = 0;

    public CreateSnapshotTaskExecutor(Application inApp, CreateSnapshotStep inStep) {
        super(inApp, inStep);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void doTask(StepInfo inStepInfo, ExecStep inGeneratedStep, ExecutionState inState, VirtualAgent inVirtualAgent) throws RPCException, InterruptedException, PlanExecutionException {
        CreateSnapshotStep step = (CreateSnapshotStep)inGeneratedStep;
        try {
            PlanExecutionException cleanUpError22;
            boolean wasInterrupted = false;
            AllGatherer gatherer = new AllGatherer();
            SnapshotUtil.doSnapshotTraversal(inState, inState.getCurrCID().getComponent(), inVirtualAgent, (TaskExecutor)this, step.getBlockName(), (SnapshotItemGatherer)gatherer);
            try {
                try {
                    if (Logger.isDebugEnabled(this)) {
                        Logger.debug("executing prepare steps for " + inState.getCurrCID().getComponent().getName(), this);
                    }
                    SnapshotID snapshotID = inVirtualAgent.createSnapshotObject(inState, inState.getCurrInstalledComponent().getID(), step.getBlockName());
                    inState.incrementSnapshotInstallOrder();
                    this.doPrepare(gatherer.getPrepareContext(), inStepInfo, inState, inVirtualAgent);
                    this.doCapture(gatherer.getCaptureContext(), inStepInfo, inState, inVirtualAgent, snapshotID);
                    inVirtualAgent.setSnapshotInstalled(snapshotID);
                }
                catch (PlanAbortException pae) {
                    wasInterrupted = true;
                    throw pae;
                }
                catch (PlanTimeoutException pte) {
                    wasInterrupted = true;
                    throw pte;
                }
                catch (PlanExecutionException pee) {
                    wasInterrupted = pee.getIsInterrupted();
                    throw pee;
                }
                Object var10_13 = null;
                if (wasInterrupted) return;
            }
            catch (Throwable throwable) {
                PlanExecutionException cleanUpError22;
                Object var10_14 = null;
                if (wasInterrupted) throw throwable;
                if (Logger.isDebugEnabled(this)) {
                    Logger.debug("executing cleanup steps for " + inState.getCurrCID().getComponent().getName(), this);
                }
                if ((cleanUpError22 = this.doCleanUp(gatherer.getCleanupContext(), inStepInfo, inState, inVirtualAgent)) == null) throw throwable;
                throw cleanUpError22;
            }
            if (Logger.isDebugEnabled(this)) {
                Logger.debug("executing cleanup steps for " + inState.getCurrCID().getComponent().getName(), this);
            }
            if ((cleanUpError22 = this.doCleanUp(gatherer.getCleanupContext(), inStepInfo, inState, inVirtualAgent)) == null) return;
            throw cleanUpError22;
        }
        catch (PersistenceManagerException pme) {
            throw new PlanExecutionException(new ROXMessage("pe.ERR_CREATE_SNAPSHOT", step.getBlockName()), (Throwable)pme);
        }
    }

    private PlanExecutionException doCleanUp(final SnapshotStepsContext cleanupContext, final StepInfo inParentInfo, final ExecutionState inState, VirtualAgent inVirtualAgent) throws PlanExecutionException, InterruptedException, RPCException {
        PlanExecutionException error = null;
        if (this.mLastPrepareAttempted <= 0) {
            return error;
        }
        --this.mLastPrepareAttempted;
        error = (PlanExecutionException)RetargetingTaskExecutorBase.performRetargetableAction(new RetargetingTaskExecutorBase.RetargetableAction(){

            public Object execute(VirtualAgent inAgent) throws InterruptedException, RPCException {
                return CreateSnapshotTaskExecutor.this.executeTargetCleanup(inAgent, inState, cleanupContext, inParentInfo);
            }
        }, cleanupContext.getITarget(), null, inVirtualAgent, inState, inParentInfo);
        return error;
    }

    private PlanExecutionException executeTargetCleanup(VirtualAgent inAgent, ExecutionState inState, SnapshotStepsContext cleanupContext, StepInfo inParentInfo) throws InterruptedException, RPCException {
        PlanExecutionException error = null;
        try {
            ConfigGenerator configGen = CreateSnapshotTaskExecutor.createCGForGivenInstalledComp(inAgent, inState, cleanupContext.getStepArgs(), cleanupContext.getBlock(), cleanupContext.getIComp(), TargetType.CURRENT, false, cleanupContext.getCaller());
            ConfigGenerator passSafeConfigGen = CreateSnapshotTaskExecutor.createCGForGivenInstalledComp(inAgent, inState, cleanupContext.getStepArgs(), cleanupContext.getBlock(), cleanupContext.getIComp(), TargetType.CURRENT, true, cleanupContext.getCaller());
            SnapshotStepsContext[] children = cleanupContext.getChildren();
            for (int i = 0; i < children.length; ++i) {
                PlanExecutionException cleanUpError = this.doCleanUp(children[i], inParentInfo, inState, inAgent);
                if (cleanUpError == null) continue;
                error = cleanUpError;
            }
            MultiStepExecutor.execMultiStepsInCurrentComponent(inParentInfo, cleanupContext.getSteps(), inState, 0, inAgent, this.getTaskExecutorFactory(null), cleanupContext.getIComp(), configGen, passSafeConfigGen, cleanupContext.getCaller());
        }
        catch (PlanExecutionException pee) {
            error = pee;
        }
        return error;
    }

    private void doCapture(SnapshotCaptureContext[] captureContext, StepInfo inParentInfo, ExecutionState inState, VirtualAgent inVirtualAgent, final SnapshotID snapshotID) throws PlanExecutionException, RPCException, InterruptedException {
        if (captureContext != null && captureContext.length > 0) {
            SnapshotCaptureContext context = null;
            for (int i = 0; i < captureContext.length; ++i) {
                final SnapshotCaptureContext finalContext = context = captureContext[i];
                RetargetingTaskExecutorBase.performRetargetableAction(new RetargetingTaskExecutorBase.RetargetableAction(){

                    public Object execute(VirtualAgent inNewAgent) throws PlanExecutionException {
                        CreateSnapshotTaskExecutor.this.invokeSnapshot(finalContext, snapshotID, inNewAgent);
                        return null;
                    }
                }, context.getInstalledTarget(), null, inVirtualAgent, inState, inParentInfo);
            }
        }
    }

    private void invokeSnapshot(SnapshotCaptureContext context, SnapshotID snapshotID, VirtualAgent inVirtualAgent) throws PlanExecutionException {
        context.getSnapshotSet().setSnapshotID(snapshotID);
        inVirtualAgent.doSnapshot(context.getSnapshotSet());
    }

    private void doPrepare(final SnapshotStepsContext prepareContext, final StepInfo inParentInfo, final ExecutionState inState, VirtualAgent inVirtualAgent) throws PlanExecutionException, InterruptedException, RPCException {
        RetargetingTaskExecutorBase.performRetargetableAction(new RetargetingTaskExecutorBase.RetargetableAction(){

            public Object execute(VirtualAgent inAgent) throws PlanExecutionException, InterruptedException, RPCException {
                CreateSnapshotTaskExecutor.this.executeTargetPrepare(inState, prepareContext, inAgent, inParentInfo);
                return null;
            }
        }, prepareContext.getITarget(), null, inVirtualAgent, inState, inParentInfo);
    }

    private void executeTargetPrepare(ExecutionState inState, SnapshotStepsContext prepareContext, VirtualAgent inVirtualAgent, StepInfo inParentInfo) throws PlanExecutionException, InterruptedException, RPCException {
        ConfigGenerator configGen = CreateSnapshotTaskExecutor.createCGForGivenInstalledComp(inVirtualAgent, inState, prepareContext.getStepArgs(), prepareContext.getBlock(), prepareContext.getIComp(), TargetType.CURRENT, false, prepareContext.getCaller());
        ConfigGenerator passSafeConfigGen = CreateSnapshotTaskExecutor.createCGForGivenInstalledComp(inVirtualAgent, inState, prepareContext.getStepArgs(), prepareContext.getBlock(), prepareContext.getIComp(), TargetType.CURRENT, true, prepareContext.getCaller());
        ++this.mLastPrepareAttempted;
        MultiStepExecutor.execMultiStepsInCurrentComponent(inParentInfo, prepareContext.getSteps(), inState, 0, inVirtualAgent, this.getTaskExecutorFactory(null), prepareContext.getIComp(), configGen, passSafeConfigGen, prepareContext.getCaller());
        SnapshotStepsContext[] children = prepareContext.getChildren();
        for (int i = 0; i < children.length; ++i) {
            this.doPrepare(children[i], inParentInfo, inState, inVirtualAgent);
        }
    }

    public String toString() {
        ROXMessage msg = new ROXMessage("pe.step.CREATE_SNAPSHOT", new String[]{((CreateSnapshotStep)this.getOriginalStep()).getBlockName()});
        return msg.toString();
    }
}

