/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.executor.task;

import com.raplix.rolloutexpress.Application;
import com.raplix.rolloutexpress.executor.ExecutionState;
import com.raplix.rolloutexpress.executor.PlanExecutionException;
import com.raplix.rolloutexpress.executor.PlanTargetedConfigContext;
import com.raplix.rolloutexpress.executor.StepInfo;
import com.raplix.rolloutexpress.executor.task.RetargetingTaskExecutorBase;
import com.raplix.rolloutexpress.executor.virtual.VirtualAgent;
import com.raplix.rolloutexpress.message.ROXMessage;
import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.systemmodel.hostdbx.Host;
import com.raplix.rolloutexpress.systemmodel.installdb.InstallDBException;
import com.raplix.rolloutexpress.systemmodel.plandb.CreateDependencyStep;
import com.raplix.rolloutexpress.systemmodel.plandb.ExecStep;
import com.raplix.rolloutexpress.systemmodel.plandb.InstalledComponentTargeter;
import com.raplix.rolloutexpress.systemmodel.plandb.RepoTarget;
import com.raplix.util.logger.Logger;

public class CreateDependencyTaskExecutor
extends RetargetingTaskExecutorBase {
    private String mName;
    private Host mOrigTargetHost;

    public CreateDependencyTaskExecutor(Application inApp, CreateDependencyStep inStep) {
        super(inApp, inStep);
        this.mName = inStep.getName();
    }

    protected InstalledComponentTargeter getInstalledCompTargeter(ExecStep inStep) {
        return ((CreateDependencyStep)inStep).getTargeter();
    }

    protected void doTask(StepInfo inStepInfo, ExecStep inGeneratedStep, ExecutionState inState, VirtualAgent inVirtualAgent) throws PlanExecutionException, InterruptedException, RPCException {
        this.mOrigTargetHost = inState.getCurrPlanTargetedCtx().getTargetHost();
        super.doTask(inStepInfo, inGeneratedStep, inState, inVirtualAgent);
    }

    protected void doRetargetedAction(RepoTarget inTarget, VirtualAgent inVirtualAgent, ExecutionState inState, ExecStep inGeneratedStep, StepInfo inCurrentStep) throws PlanExecutionException, InterruptedException, RPCException {
        CreateDependencyStep theStep = (CreateDependencyStep)inGeneratedStep;
        PlanTargetedConfigContext ctx = inState.getCurrPlanTargetedCtx();
        Host curTargetHost = ctx.getTargetHost();
        ctx.setTargetHost(this.mOrigTargetHost);
        try {
            inState.getTaskInfo().getInstallDBContext().createDependency(this.mName, inState.getCaller(), theStep.getTargeter(), ctx);
            if (Logger.isDebugEnabled(this)) {
                Logger.debug("Created dependency " + this.mName, this);
            }
        }
        catch (PersistenceManagerException ex) {
            throw new PlanExecutionException(ex);
        }
        catch (InstallDBException ex) {
            throw new PlanExecutionException(ex);
        }
        finally {
            ctx.setTargetHost(curTargetHost);
        }
    }

    public String toString() {
        ROXMessage msg = new ROXMessage("pe.step.CREATE_DEPENDENCY", this.mName);
        return msg.toString();
    }
}

