/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.executor.task;

import com.raplix.rolloutexpress.Application;
import com.raplix.rolloutexpress.config.ConfigGenerator;
import com.raplix.rolloutexpress.executor.ExecutionState;
import com.raplix.rolloutexpress.executor.MultiStepExecutor;
import com.raplix.rolloutexpress.executor.PlanExecutionException;
import com.raplix.rolloutexpress.executor.StepInfo;
import com.raplix.rolloutexpress.executor.target.TargetType;
import com.raplix.rolloutexpress.executor.task.RetargetingTaskExecutorBase;
import com.raplix.rolloutexpress.executor.virtual.VirtualAgent;
import com.raplix.rolloutexpress.message.ROXMessage;
import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.systemmodel.componentdb.Component;
import com.raplix.rolloutexpress.systemmodel.componentdb.ControlBlock;
import com.raplix.rolloutexpress.systemmodel.installdb.InstalledComponent;
import com.raplix.rolloutexpress.systemmodel.plandb.CallStep;
import com.raplix.rolloutexpress.systemmodel.plandb.Caller;
import com.raplix.rolloutexpress.systemmodel.plandb.ExecStep;
import com.raplix.rolloutexpress.systemmodel.plandb.InstalledComponentTargeter;
import com.raplix.rolloutexpress.systemmodel.plandb.InstalledTarget;
import com.raplix.rolloutexpress.systemmodel.plandb.RepoTarget;
import com.raplix.rolloutexpress.systemmodel.plandb.ReturnStep;
import com.raplix.util.logger.Logger;

public class ControlServiceTaskExecutor
extends RetargetingTaskExecutorBase {
    private String mBlockName;
    private String mCompName;

    public ControlServiceTaskExecutor(Application inApp, CallStep inStep) {
        super(inApp, inStep);
        this.mCompName = ((Object)this.getInstalledCompTargeter(inStep)).toString();
        this.mBlockName = inStep.getBlockName();
    }

    protected InstalledComponentTargeter getInstalledCompTargeter(ExecStep inStep) {
        CallStep theStep = (CallStep)inStep;
        return theStep.getTargeter();
    }

    protected void doRetargetedAction(RepoTarget inTarget, VirtualAgent inVirtualAgent, ExecutionState inState, ExecStep inGeneratedStep, StepInfo inCurrentStep) throws PlanExecutionException, InterruptedException, RPCException {
        String actionName;
        Component theComp;
        ControlBlock controlBlock;
        InstalledComponent theInstalledComp;
        CallStep theStepToUse = (CallStep)inGeneratedStep;
        InstalledTarget theTarget = (InstalledTarget)inTarget;
        InstalledComponent installedComponent = theInstalledComp = theTarget == null ? inState.getCurrInstalledComponent() : theTarget.getInstalledComponent();
        if (!theStepToUse.getTargeter().isInternalTarget()) {
            this.verifyCompTarget(theInstalledComp, inVirtualAgent, "pe.ERR_COMP_CONTROL_DIFF_TARGET");
        }
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("installData:component " + theInstalledComp.getID(), this);
        }
        if ((controlBlock = (theComp = this.getComponentByComponentID(theInstalledComp.getComponentID())).resolveControlBlock(actionName = theStepToUse.getBlockName(), theTarget.getCallSpec())) == null) {
            throw new PlanExecutionException(new ROXMessage("pe.NAMED_BLOCK_DNE", actionName, ExecStep.getStepTypeStringRepresentation(this.getStepType()), theComp.getName()));
        }
        if (theStepToUse.getAssignTo() != null && !controlBlock.getReturns()) {
            throw new PlanExecutionException(new ROXMessage("pe.ERR_CONTROL_DOES_NOT_RETURN_VALUE", actionName, theComp.getName()));
        }
        ExecStep[] steps = controlBlock.getExecSteps();
        Caller nextCaller = theTarget.getCallerForMember(controlBlock);
        ConfigGenerator passwdSafeCG = null;
        if (inState.getCurrPasswdSafeConfigGenerator() != null) {
            passwdSafeCG = ControlServiceTaskExecutor.createCGForGivenInstalledComp(inVirtualAgent, inState, ((CallStep)this.generateStepPasswdSafe(inState)).getArgs(), controlBlock, theInstalledComp, TargetType.CURRENT, true, nextCaller);
        }
        ConfigGenerator cgx = ControlServiceTaskExecutor.createCGForGivenInstalledComp(inVirtualAgent, inState, theStepToUse.getArgs(), controlBlock, theInstalledComp, TargetType.CURRENT, false, nextCaller);
        ReturnStep returnStep = MultiStepExecutor.execMultiStepsInCurrentComponent(inCurrentStep, steps, inState, 0, inVirtualAgent, this.getTaskExecutorFactory(null), theInstalledComp, cgx, passwdSafeCG, nextCaller);
        this.processReturnStep(theStepToUse, returnStep, inState);
        inVirtualAgent.sendControlServiceEvent(inState.getPlanRecorder(), theInstalledComp.getID(), actionName);
    }

    public String toString() {
        ROXMessage msg = new ROXMessage("pe.step.CONTROL_SERVICE", this.mBlockName, this.mCompName);
        return msg.toString();
    }
}

