/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.executor.task;

import com.raplix.rolloutexpress.Application;
import com.raplix.rolloutexpress.executor.ExecutionState;
import com.raplix.rolloutexpress.executor.PEXComponentLookupException;
import com.raplix.rolloutexpress.executor.PlanExecutionException;
import com.raplix.rolloutexpress.executor.StepInfo;
import com.raplix.rolloutexpress.executor.task.RetargetingTaskExecutorBase;
import com.raplix.rolloutexpress.executor.virtual.VirtualAgent;
import com.raplix.rolloutexpress.message.ROXMessage;
import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.systemmodel.plandb.CheckDependencyStep;
import com.raplix.rolloutexpress.systemmodel.plandb.ExecStep;
import com.raplix.rolloutexpress.systemmodel.plandb.InstalledComponentTargeter;
import com.raplix.rolloutexpress.systemmodel.plandb.RepoTarget;
import com.raplix.util.logger.Logger;

public class CheckDependencyTaskExecutor
extends RetargetingTaskExecutorBase {
    private String mCompName = null;

    public CheckDependencyTaskExecutor(Application inApp, CheckDependencyStep inStep) {
        super(inApp, inStep);
        this.mCompName = ((Object)inStep.getTargeter()).toString();
    }

    protected InstalledComponentTargeter getInstalledCompTargeter(ExecStep inStep) {
        return ((CheckDependencyStep)inStep).getTargeter();
    }

    protected RepoTarget[] getRepoComponentTargets(ExecStep inGeneratedStep, ExecutionState inState) throws RPCException, PlanExecutionException {
        try {
            return super.getRepoComponentTargets(inGeneratedStep, inState);
        }
        catch (PEXComponentLookupException ex) {
            throw new PlanExecutionException(new ROXMessage("pe.ERR_DEPENDENT_COMP_NOT_INSTLD", new String[]{ex.getCompName(), ex.getHostName()}), (Throwable)ex);
        }
    }

    protected void doRetargetedAction(RepoTarget inTarget, VirtualAgent inVirtualAgent, ExecutionState inState, ExecStep inGeneratedStep, StepInfo inCurrentStep) throws PlanExecutionException, RPCException {
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("CheckDependency passed for comp " + this.mCompName, this);
        }
    }

    public String toString() {
        return new ROXMessage("pe.step.CHECK_DEPENDENCY", this.mCompName).toString();
    }
}

