/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.executor.task;

import com.raplix.rolloutexpress.Application;
import com.raplix.rolloutexpress.config.ConfigGenException;
import com.raplix.rolloutexpress.config.ConfigGenerator;
import com.raplix.rolloutexpress.executor.ExecutionState;
import com.raplix.rolloutexpress.executor.PlanExecutionException;
import com.raplix.rolloutexpress.executor.StepInfo;
import com.raplix.rolloutexpress.executor.task.TaskExecutor;
import com.raplix.rolloutexpress.executor.virtual.VirtualAgent;
import com.raplix.rolloutexpress.message.ROXMessage;
import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.systemmodel.plandb.AssignStep;
import com.raplix.rolloutexpress.systemmodel.plandb.ExecStep;
import java.io.IOException;

public class AssignTaskExecutor
extends TaskExecutor {
    private AssignStep mStepToUse;

    protected AssignTaskExecutor(Application inApp, ExecStep inOrigStep) {
        super(inApp, inOrigStep);
        this.mStepToUse = (AssignStep)inOrigStep;
    }

    protected void doTask(StepInfo inStepInfo, ExecStep inGeneratedStep, ExecutionState inState, VirtualAgent inVirtualAgent) throws PlanExecutionException, InterruptedException, RPCException {
        this.mStepToUse = (AssignStep)inGeneratedStep;
        try {
            ConfigGenerator cg = inState.getCurrConfigGenerator();
            ConfigGenerator pwcg = inState.getCurrPasswdSafeConfigGenerator();
            String varname = this.mStepToUse.getVarName();
            String value = this.mStepToUse.getValue();
            cg.setVarValue(varname, value);
            pwcg.setVarValue(varname, value);
            inState.setCurrConfigGenerator(cg);
            inState.setCurrPasswdSafeConfigGenerator(pwcg);
        }
        catch (ConfigGenException e) {
            throw new PlanExecutionException(e);
        }
        catch (IOException e) {
            throw new PlanExecutionException(e);
        }
    }

    public String toString() {
        ROXMessage msg = new ROXMessage("pe.step.ASSIGN", this.mStepToUse.getVarName());
        return msg.toString();
    }
}

