/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.executor.target;

import com.raplix.rolloutexpress.executor.target.TargetImplTable;
import com.raplix.rolloutexpress.executor.target.TargetType;
import com.raplix.rolloutexpress.persist.query.QueryContext;
import com.raplix.rolloutexpress.persist.query.builder.ColumnNode;
import com.raplix.rolloutexpress.persist.query.builder.ConditionalExpression;
import com.raplix.rolloutexpress.persist.query.builder.OrderByList;
import com.raplix.rolloutexpress.persist.query.builder.Select;
import com.raplix.rolloutexpress.persist.query.builder.Table;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostID;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostImplTable;

public class TargetSQLOps
extends TargetImplTable {
    public static final TargetSQLOps DEFAULT = new TargetSQLOps();

    public TargetSQLOps(String alias) {
        super(alias);
    }

    private TargetSQLOps() {
        this(null);
    }

    public Table instance() {
        return DEFAULT;
    }

    public Table instance(String alias) {
        return new TargetSQLOps(alias);
    }

    public ConditionalExpression equalsHost(HostID hostID, TargetType type) {
        if (type == null) {
            return TargetSQLOps.or(TargetSQLOps.or(TargetSQLOps.equals(this.InitialHostID, hostID), TargetSQLOps.equals(this.CurrentHostID, hostID)), TargetSQLOps.equals(this.PhysicalHostID, hostID));
        }
        if (TargetType.INITIAL.equals(type)) {
            return TargetSQLOps.equals(this.InitialHostID, hostID);
        }
        if (TargetType.CURRENT.equals(type)) {
            return TargetSQLOps.equals(this.CurrentHostID, hostID);
        }
        if (TargetType.PHYSICAL.equals(type)) {
            return TargetSQLOps.equals(this.PhysicalHostID, hostID);
        }
        return null;
    }

    public Select selectIDsByHost(HostID hostID, TargetType type) {
        return this.select(TargetSQLOps.sList(this.ID), TargetSQLOps.where(this.equalsHost(hostID, type)));
    }

    public ConditionalExpression equalsHosts(HostID initial, HostID current, HostID physical) {
        return TargetSQLOps.and(TargetSQLOps.and(TargetSQLOps.equals(this.InitialHostID, initial), TargetSQLOps.equals(this.CurrentHostID, current)), TargetSQLOps.equals(this.PhysicalHostID, physical));
    }

    public OrderByList orderByInitialHostNameAsc(QueryContext ctx) {
        HostImplTable hT = new HostImplTable("hT");
        ctx.addTable(hT);
        ctx.addAndWhereCondition(TargetSQLOps.equals((ColumnNode)hT.ID, this.InitialHostID));
        return TargetSQLOps.dictOrderAsc(hT.Name);
    }
}

