/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.executor.target;

import com.raplix.rolloutexpress.executor.target.SingleTargetQuery;
import com.raplix.rolloutexpress.executor.target.SummaryTarget;
import com.raplix.rolloutexpress.executor.target.TargetID;
import com.raplix.rolloutexpress.executor.target.TargetType;
import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.persist.ConstraintViolationException;
import com.raplix.rolloutexpress.persist.ObjectID;
import com.raplix.rolloutexpress.persist.PersistContext;
import com.raplix.rolloutexpress.persist.PersistentBean;
import com.raplix.rolloutexpress.persist.ReEntrantTransaction;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.persist.query.NoResultsFoundException;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostID;

class TargetImpl
extends PersistentBean
implements SummaryTarget {
    private HostID mInitialHostID;
    private HostID mCurrentHostID;
    private HostID mPhysicalHostID;

    private TargetImpl() {
    }

    private TargetImpl(HostID initial, HostID current, HostID physical) {
        this.setInitialHostID(initial);
        this.setCurrentHostID(current);
        this.setPhysicalHostID(physical);
    }

    static TargetImpl create(HostID initial, HostID current, HostID physical) throws PersistenceManagerException, RPCException {
        try {
            return TargetImpl.selectByHosts(initial, current, physical);
        }
        catch (NoResultsFoundException e) {
            TargetImpl result;
            block5: {
                result = new TargetImpl(initial, current, physical);
                try {
                    result.save();
                }
                catch (ConstraintViolationException e2) {
                    String code = e2.getROXMessage().getKey();
                    if ("pm.constraint.c_target_unique_hosts".equals(code)) {
                        result = TargetImpl.selectByHosts(initial, current, physical);
                        break block5;
                    }
                    throw e2;
                }
            }
            return result;
        }
    }

    private static TargetImpl selectByHosts(HostID initial, HostID current, HostID physical) throws PersistenceManagerException, RPCException {
        return (TargetImpl)SingleTargetQuery.byHosts(initial, current, physical).selectSummaryView();
    }

    public ObjectID getObjectID() {
        return this.getID();
    }

    public TargetID getID() {
        return (TargetID)super.getObjectID();
    }

    public HostID getInitialHostID() {
        return this.mInitialHostID;
    }

    private void setInitialHostID(HostID hostID) {
        this.mInitialHostID = hostID;
    }

    public HostID getCurrentHostID() {
        return this.mCurrentHostID;
    }

    private void setCurrentHostID(HostID hostID) {
        this.mCurrentHostID = hostID;
    }

    public HostID getPhysicalHostID() {
        return this.mPhysicalHostID;
    }

    private void setPhysicalHostID(HostID hostID) {
        this.mPhysicalHostID = hostID;
    }

    public HostID getHostID(TargetType type) {
        if (type.equals(TargetType.INITIAL)) {
            return this.getInitialHostID();
        }
        if (type.equals(TargetType.CURRENT)) {
            return this.getCurrentHostID();
        }
        if (type.equals(TargetType.PHYSICAL)) {
            return this.getPhysicalHostID();
        }
        return null;
    }

    private void save() throws PersistenceManagerException, RPCException {
        this.saveRPC(null);
    }

    protected void saveMS(PersistContext context) throws PersistenceManagerException {
        TargetImpl.retryOnDeadlock(new ReEntrantSave(context));
    }

    private class ReEntrantSave
    implements ReEntrantTransaction {
        private PersistContext mCtx;

        ReEntrantSave(PersistContext inCtx) {
            this.mCtx = inCtx;
        }

        public Object execute() throws PersistenceManagerException {
            TargetImpl.super.saveMS(this.mCtx);
            return null;
        }
    }
}

