/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.executor.target;

import com.raplix.rolloutexpress.event.ROXEventFactoryTable;
import com.raplix.rolloutexpress.event.TargetStatus;
import com.raplix.rolloutexpress.event.TargetStatusTable;
import com.raplix.rolloutexpress.event.query.MultiTargetStatusQuery;
import com.raplix.rolloutexpress.executor.StepInfoTable;
import com.raplix.rolloutexpress.executor.SubplanToTargetLinkTable;
import com.raplix.rolloutexpress.executor.TaskIDSet;
import com.raplix.rolloutexpress.executor.query.MultiTaskInfoQuery;
import com.raplix.rolloutexpress.executor.target.SingleTargetByHostsCache;
import com.raplix.rolloutexpress.executor.target.SingleTargetQuery;
import com.raplix.rolloutexpress.executor.target.TargetIDSet;
import com.raplix.rolloutexpress.executor.task.ExecNativeOutputTable;
import com.raplix.rolloutexpress.message.ROXMessage;
import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.persist.DeleteSessionContext;
import com.raplix.rolloutexpress.persist.DeleteSessionDependentContainer;
import com.raplix.rolloutexpress.persist.IDResolvingTypedSet;
import com.raplix.rolloutexpress.persist.ObjectID;
import com.raplix.rolloutexpress.persist.ObjectIDFactory;
import com.raplix.rolloutexpress.persist.PersistContext;
import com.raplix.rolloutexpress.persist.UsingObject;
import com.raplix.rolloutexpress.persist.cache.ObjectCache;
import com.raplix.rolloutexpress.persist.exception.ObjectInUseException;
import com.raplix.rolloutexpress.persist.exception.ObjectNotDeletableException;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.persist.map.ClassMap;
import com.raplix.rolloutexpress.persist.query.ObjectFilter;
import com.raplix.rolloutexpress.persist.query.QueryContext;
import com.raplix.rolloutexpress.persist.query.builder.ColumnNode;
import com.raplix.rolloutexpress.systemmodel.installdb.MultiInstalledComponentQuery;
import com.raplix.rolloutexpress.systemmodel.installdb.PersistentInstalledComponentTable;

public class TargetID
extends ObjectID {
    static final long serialVersionUID = 2253572253071671051L;
    public static final TargetID TARGET_SENTINEL_ID = new TargetID("010010001019-0000000000000-00012-0000000001");
    private static final IDFactory ID_FACTORY = new IDFactory();
    static /* synthetic */ Class class$com$raplix$rolloutexpress$systemmodel$installdb$PersistentInstalledComponentTable;

    private TargetID() {
    }

    public TargetID(String key) {
        super(key);
    }

    public SingleTargetQuery getByIDQuery() {
        return new SingleTargetQuery(this);
    }

    public static TargetID generateID() {
        return (TargetID)ID_FACTORY.generateObjectID();
    }

    public void findDependentObjects(DeleteSessionContext inContext, DeleteSessionDependentContainer inDependentContainer, DeleteSessionDependentContainer inPostDependentContainer) throws PersistenceManagerException {
        try {
            if (TARGET_SENTINEL_ID.equals(this)) {
                throw new ObjectNotDeletableException(new ROXMessage("pm.CANNOT_DELETE_OBJECT"));
            }
            MultiTargetStatusQuery targetStatusQuery = MultiTargetStatusQuery.all();
            targetStatusQuery.addFilter(new ObjectFilter(){

                public void addFilterCondition(QueryContext ctx) {
                    TargetStatusTable t = (TargetStatusTable)ctx.getFirstTable();
                    ctx.addAndWhereCondition(TargetStatusTable.and(TargetStatusTable.equals(t.TargetID, TargetID.this), TargetStatusTable.or(TargetStatusTable.equals(t.Status, 0), TargetStatusTable.equals(t.Status, 3))));
                }
            });
            TargetStatus[] objs = targetStatusQuery.select();
            if (null != objs && objs.length > 0) {
                TaskIDSet usingIDs = new TaskIDSet();
                for (int i = 0; i < objs.length; ++i) {
                    usingIDs.add(objs[i].getTaskID());
                }
                UsingObject[] usingTasks = MultiTaskInfoQuery.byIDs(usingIDs.toIDArray()).select();
                throw new ObjectInUseException(new ROXMessage("pm.OBJECT_IN_USE"), usingTasks);
            }
            MultiInstalledComponentQuery micq = MultiInstalledComponentQuery.all();
            micq.setInstalledFilter(null);
            micq.addFilter(new ObjectFilter(){

                public void addFilterCondition(QueryContext ctx) {
                    PersistentInstalledComponentTable t = (PersistentInstalledComponentTable)ctx.getTableOfType(class$com$raplix$rolloutexpress$systemmodel$installdb$PersistentInstalledComponentTable == null ? (class$com$raplix$rolloutexpress$systemmodel$installdb$PersistentInstalledComponentTable = TargetID.class$("com.raplix.rolloutexpress.systemmodel.installdb.PersistentInstalledComponentTable")) : class$com$raplix$rolloutexpress$systemmodel$installdb$PersistentInstalledComponentTable);
                    ctx.addAndWhereCondition(PersistentInstalledComponentTable.equals(t.TargetID, TargetID.this));
                }
            });
            inDependentContainer.addAllDependentObjects(micq.selectObjects());
        }
        catch (RPCException rpce) {
            throw new PersistenceManagerException(rpce);
        }
    }

    protected IDResolvingTypedSet getIDResolvingTypedSet() throws PersistenceManagerException {
        TargetIDSet idset = new TargetIDSet();
        idset.add(this);
        return idset;
    }

    protected void deleteMS(PersistContext context) throws PersistenceManagerException {
        TargetStatusTable tst = TargetStatusTable.DEFAULT;
        TargetStatusTable.execute(TargetStatusTable.update(tst, TargetStatusTable.uList(TargetStatusTable.set(tst.TargetID, TARGET_SENTINEL_ID)), TargetStatusTable.where(TargetStatusTable.equals(tst.TargetID, this))));
        ExecNativeOutputTable enot = ExecNativeOutputTable.DEFAULT;
        ExecNativeOutputTable.execute(ExecNativeOutputTable.update(enot, ExecNativeOutputTable.uList(ExecNativeOutputTable.set(enot.TargetID, TARGET_SENTINEL_ID)), ExecNativeOutputTable.where(ExecNativeOutputTable.equals(enot.TargetID, this))));
        StepInfoTable sit = StepInfoTable.DEFAULT;
        StepInfoTable.execute(StepInfoTable.update(sit, StepInfoTable.uList(StepInfoTable.set(sit.TargetID, TARGET_SENTINEL_ID)), StepInfoTable.where(StepInfoTable.equals(sit.TargetID, this))));
        ROXEventFactoryTable et = ROXEventFactoryTable.DEFAULT;
        ROXEventFactoryTable.execute(ROXEventFactoryTable.update(et, ROXEventFactoryTable.uList(ROXEventFactoryTable.set(et.TargetID, TARGET_SENTINEL_ID.toString())), ROXEventFactoryTable.where(ROXEventFactoryTable.equals(et.TargetID, this.toString()))));
        SubplanToTargetLinkTable stt = SubplanToTargetLinkTable.DEFAULT;
        SubplanToTargetLinkTable istt = new SubplanToTargetLinkTable("istt");
        SubplanToTargetLinkTable.execute(SubplanToTargetLinkTable.update(stt, SubplanToTargetLinkTable.uList(SubplanToTargetLinkTable.set(stt.ChildID, TARGET_SENTINEL_ID)), SubplanToTargetLinkTable.where(SubplanToTargetLinkTable.and(SubplanToTargetLinkTable.equals(stt.ChildID, this), SubplanToTargetLinkTable.not(SubplanToTargetLinkTable.in((ColumnNode)stt.ParentID, istt.select(SubplanToTargetLinkTable.sList(istt.ParentID), SubplanToTargetLinkTable.where(SubplanToTargetLinkTable.equals(istt.ChildID, TARGET_SENTINEL_ID)))))))));
        SubplanToTargetLinkTable.execute(SubplanToTargetLinkTable.delete(stt, SubplanToTargetLinkTable.where(SubplanToTargetLinkTable.equals(stt.ChildID, this))));
        super.deleteMS(context);
    }

    public static class IDFactory
    extends ObjectIDFactory {
        protected ObjectID newInstance(String inID) {
            return new TargetID(inID);
        }

        public void registerCaches(ClassMap classMap, ObjectCache objectCache) {
            SingleTargetByHostsCache cache = new SingleTargetByHostsCache(objectCache);
            classMap.addSingleObjectCache(cache);
        }
    }
}

