/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.executor.target;

import com.raplix.rolloutexpress.executor.PlanExecutionException;
import com.raplix.rolloutexpress.executor.target.HostResolver;
import com.raplix.rolloutexpress.executor.target.NoRAOnHostException;
import com.raplix.rolloutexpress.executor.target.SummaryTarget;
import com.raplix.rolloutexpress.executor.target.TargetID;
import com.raplix.rolloutexpress.executor.target.TargetImpl;
import com.raplix.rolloutexpress.executor.target.TargetType;
import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.persist.ObjectID;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.systemmodel.hostdbx.Host;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostID;

public class Target
implements SummaryTarget {
    private TargetImpl mTargetImpl;
    private Host mInitialHost;
    private Host mCurrentHost;
    private Host mPhysicalHost;

    private Target() {
    }

    private Target(TargetImpl targetImpl, Host initial, Host current, Host physical) {
        this.setImpl(targetImpl);
        this.setInitialHost(initial);
        this.setCurrentHost(current);
        this.setPhysicalHost(physical);
    }

    Target(TargetImpl targetImpl, HostResolver resolver) throws PersistenceManagerException, RPCException {
        this(targetImpl, resolver.getHost(targetImpl.getInitialHostID()), resolver.getHost(targetImpl.getCurrentHostID()), resolver.getHost(targetImpl.getPhysicalHostID()));
    }

    public static Target create(HostID initialID, HostID currentID, HostResolver resolver) throws PersistenceManagerException, RPCException, PlanExecutionException {
        Host initial = resolver.getHost(initialID);
        Host current = resolver.getHost(currentID);
        Host physical = Target.getPhysical(current, resolver);
        if (physical.getAppRA() == null) {
            throw new NoRAOnHostException(physical, current.getName());
        }
        TargetImpl impl = TargetImpl.create(initial.getID(), current.getID(), physical.getID());
        return new Target(impl, initial, current, physical);
    }

    private static Host getPhysical(Host current, HostResolver resolver) throws PersistenceManagerException, RPCException {
        HostID parentID = current.getParentHostID();
        while (parentID != null) {
            current = resolver.getHost(parentID);
            parentID = current.getParentHostID();
        }
        return current;
    }

    private TargetImpl getImpl() {
        return this.mTargetImpl;
    }

    private void setImpl(TargetImpl target) {
        this.mTargetImpl = target;
    }

    public ObjectID getObjectID() {
        return this.getImpl().getObjectID();
    }

    public TargetID getID() {
        return this.getImpl().getID();
    }

    public HostID getInitialHostID() {
        return this.getImpl().getInitialHostID();
    }

    public HostID getCurrentHostID() {
        return this.getImpl().getCurrentHostID();
    }

    public HostID getPhysicalHostID() {
        return this.getImpl().getPhysicalHostID();
    }

    public HostID getHostID(TargetType type) {
        return this.getImpl().getHostID(type);
    }

    public Host getInitialHost() {
        return (Host)this.mInitialHost.clone();
    }

    private void setInitialHost(Host inInitial) {
        this.mInitialHost = inInitial;
    }

    public Host getCurrentHost() {
        return (Host)this.mCurrentHost.clone();
    }

    private void setCurrentHost(Host inCurrent) {
        this.mCurrentHost = inCurrent;
    }

    public Host getPhysicalHost() {
        return (Host)this.mPhysicalHost.clone();
    }

    private void setPhysicalHost(Host physical) {
        this.mPhysicalHost = physical;
    }

    public Host getHost(TargetType type) {
        if (type.equals(TargetType.INITIAL)) {
            return this.getInitialHost();
        }
        if (type.equals(TargetType.CURRENT)) {
            return this.getCurrentHost();
        }
        if (type.equals(TargetType.PHYSICAL)) {
            return this.getPhysicalHost();
        }
        return null;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("[initial: ").append(this.getInitialHost().getName()).append(", ");
        buf.append("current: ").append(this.getCurrentHost().getName()).append(", ");
        buf.append("physical: ").append(this.getPhysicalHost().getName()).append(", ");
        buf.append("targetID: ").append(this.getID()).append("]");
        return buf.toString();
    }
}

