/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.executor.target;

import com.raplix.rolloutexpress.executor.target.TargetImpl;
import com.raplix.rolloutexpress.persist.PersistentBean;
import com.raplix.rolloutexpress.persist.cache.CacheKey;
import com.raplix.rolloutexpress.persist.cache.CustomSingleObjectCache;
import com.raplix.rolloutexpress.persist.cache.ObjectCache;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostID;

public class SingleTargetByHostsCache
extends CustomSingleObjectCache {
    public static final String NAME = "byHosts";

    public SingleTargetByHostsCache(ObjectCache objectCache) {
        super(objectCache);
    }

    public String getName() {
        return NAME;
    }

    protected CacheKey createKey(PersistentBean inObject) {
        TargetImpl target = (TargetImpl)inObject;
        return SingleTargetByHostsCache.createKey(target.getInitialHostID(), target.getCurrentHostID(), target.getPhysicalHostID());
    }

    static CacheKey createKey(HostID initial, HostID current, HostID physical) {
        return new TargetCacheKey(initial, current, physical);
    }

    private static final class TargetCacheKey
    implements CacheKey {
        HostID mInitial;
        HostID mCurrent;
        HostID mPhysical;
        int mHashCode;

        TargetCacheKey() {
        }

        TargetCacheKey(HostID initial, HostID current, HostID physical) {
            this.mInitial = initial;
            this.mCurrent = current;
            this.mPhysical = physical;
            this.mHashCode = this.mInitial.hashCode() + this.mCurrent.hashCode() + this.mPhysical.hashCode();
        }

        public boolean equals(Object other) {
            if (other == this) {
                return true;
            }
            if (other == null || !(other instanceof TargetCacheKey)) {
                return false;
            }
            TargetCacheKey otherTarget = (TargetCacheKey)other;
            return this.mInitial.equals(otherTarget.mInitial) && this.mCurrent.equals(otherTarget.mCurrent) && this.mPhysical.equals(otherTarget.mPhysical);
        }

        public int hashCode() {
            return this.mHashCode;
        }

        public String toString() {
            return "TargetCacheKey:initial:" + this.mInitial + ":current:" + this.mCurrent + ":physical:" + this.mPhysical;
        }
    }
}

