/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.executor.target;

import com.raplix.rolloutexpress.executor.target.SummaryTarget;
import com.raplix.rolloutexpress.executor.target.Target;
import com.raplix.rolloutexpress.executor.target.TargetID;
import com.raplix.rolloutexpress.executor.target.TargetIDSet;
import com.raplix.rolloutexpress.executor.target.TargetOrder;
import com.raplix.rolloutexpress.executor.target.TargetProcessor;
import com.raplix.rolloutexpress.executor.target.TargetSQLOps;
import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.persist.HasObjectID;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.persist.query.BeanProcessor;
import com.raplix.rolloutexpress.persist.query.MultiObjectQueryImpl;
import com.raplix.rolloutexpress.persist.query.MultiSelectableObjectQuery;
import com.raplix.rolloutexpress.persist.query.ObjectOrder;
import com.raplix.rolloutexpress.persist.query.QueryContext;
import com.raplix.rolloutexpress.persist.query.builder.ConditionalExpression;
import com.raplix.rolloutexpress.persist.query.builder.Table;

public class MultiTargetQuery
extends MultiObjectQueryImpl
implements MultiSelectableObjectQuery {
    private static final TargetSQLOps TABLE = new TargetSQLOps("targetT");
    private boolean mExcludeSentinelTarget = true;

    public static MultiTargetQuery all() {
        MultiTargetQuery result = new MultiTargetQuery((ConditionalExpression)null);
        result.setObjectOrder(TargetOrder.BY_INITIAL_HOST_NAME_ASC);
        return result;
    }

    static MultiTargetQuery byIDs(TargetIDSet idSet) {
        return new MultiTargetQuery(idSet);
    }

    private MultiTargetQuery(TargetIDSet idSet) {
        super((Table)TABLE, idSet.toIDArray(), TargetOrder.FACTORY);
        this.setExcludeSentinelTarget(idSet.contains(TargetID.TARGET_SENTINEL_ID));
    }

    private MultiTargetQuery(ConditionalExpression condition) {
        super((Table)TABLE, condition, TargetOrder.FACTORY);
    }

    private boolean getExcludeSentinelTarget() {
        return this.mExcludeSentinelTarget;
    }

    private void setExcludeSentinelTarget(boolean exclude) {
        this.mExcludeSentinelTarget = exclude;
    }

    public void setObjectOrder(ObjectOrder order) {
        super.setObjectOrder((TargetOrder)order);
    }

    public Target[] select() throws RPCException, PersistenceManagerException {
        TargetProcessor processor = new TargetProcessor(TABLE, false);
        return (Target[])this.select(processor, Target.class);
    }

    public SummaryTarget[] selectSummaryView() throws PersistenceManagerException, RPCException {
        return (SummaryTarget[])this.select(new BeanProcessor(TABLE, false), SummaryTarget.class);
    }

    public HasObjectID[] selectObjects() throws RPCException, PersistenceManagerException {
        return this.selectSummaryView();
    }

    protected void addFilterCondition(QueryContext ctx) throws RPCException, PersistenceManagerException {
        super.addFilterCondition(ctx);
        if (this.getExcludeSentinelTarget()) {
            ctx.addAndWhereCondition(TargetSQLOps.not(TargetSQLOps.equals(MultiTargetQuery.TABLE.ID, TargetID.TARGET_SENTINEL_ID)));
        }
    }
}

