/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.executor.target;

import com.raplix.rolloutexpress.executor.PlanExecutionException;
import com.raplix.rolloutexpress.executor.target.SummaryTarget;
import com.raplix.rolloutexpress.net.rpc.CommandException;
import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.systemmodel.hostdbx.Host;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostID;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostIDSet;
import com.raplix.rolloutexpress.systemmodel.hostdbx.MultiHostQuery;
import com.raplix.rolloutexpress.systemmodel.hostdbx.SingleHostQuery;
import java.util.Enumeration;
import java.util.Hashtable;

public class HostResolver {
    private Hashtable mIDMap = new Hashtable();
    private Hashtable mNameMap = new Hashtable();

    public Host getHost(HostID hostID) throws PersistenceManagerException, RPCException {
        Host result = (Host)this.mIDMap.get(hostID);
        if (result == null) {
            result = hostID.getByIDQuery().select();
            this.addHost(result);
        }
        return (Host)result.clone();
    }

    public Host getHost(String hostName) throws PersistenceManagerException, RPCException {
        Host result = (Host)this.mNameMap.get(hostName);
        if (result == null) {
            result = SingleHostQuery.byName(hostName).select();
            this.addHost(result);
        }
        return (Host)result.clone();
    }

    public void reloadHost(HostID inHostID) throws PlanExecutionException {
        try {
            Host oldHost = (Host)this.mIDMap.remove(inHostID);
            if (oldHost != null) {
                this.mNameMap.remove(oldHost.getName());
            }
            this.getHost(inHostID);
        }
        catch (CommandException ex) {
            throw new PlanExecutionException(ex);
        }
    }

    private void addHost(Host host) {
        this.mIDMap.put(host.getID(), host);
        this.mNameMap.put(host.getName(), host);
    }

    void resolveHostsForTargets(Enumeration summaryTargets) throws PersistenceManagerException, RPCException {
        HostIDSet unresHostIDs = new HostIDSet();
        while (summaryTargets.hasMoreElements()) {
            SummaryTarget t = (SummaryTarget)summaryTargets.nextElement();
            this.addIfUnres(t.getInitialHostID(), unresHostIDs);
            this.addIfUnres(t.getCurrentHostID(), unresHostIDs);
            this.addIfUnres(t.getPhysicalHostID(), unresHostIDs);
        }
        if (unresHostIDs.size() > 0) {
            MultiHostQuery q = unresHostIDs.getByIDsQuery();
            q.setAddResultsToCache(true);
            Host[] hosts = q.select();
            for (int i = 0; i < hosts.length; ++i) {
                this.addHost(hosts[i]);
            }
        }
    }

    private void addIfUnres(HostID hostID, HostIDSet unresHostIDs) {
        if (!this.mIDMap.containsKey(hostID)) {
            unresHostIDs.add(hostID);
        }
    }
}

