/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.executor.snapshot;

import com.raplix.rolloutexpress.config.VariableSettingsSource;
import com.raplix.rolloutexpress.executor.snapshot.SnapshotItemGatherer;
import com.raplix.rolloutexpress.executor.snapshot.SnapshotStepsContext;
import com.raplix.rolloutexpress.systemmodel.componentdb.ResourceDefinition;
import com.raplix.rolloutexpress.systemmodel.componentdb.SnapshotBlock;
import com.raplix.rolloutexpress.systemmodel.hostdbx.MachineInfo;
import com.raplix.rolloutexpress.systemmodel.installdb.InstalledComponent;
import com.raplix.rolloutexpress.systemmodel.plandb.CaptureFileStep;
import com.raplix.rolloutexpress.systemmodel.plandb.CaptureResourceStep;
import com.raplix.rolloutexpress.systemmodel.plandb.ExecStep;
import com.raplix.rolloutexpress.systemmodel.plandb.InstalledTarget;
import com.raplix.util.logger.Logger;
import java.util.Stack;

public abstract class StepGatherer
implements SnapshotItemGatherer {
    private SnapshotStepsContext mRootContext;
    private transient Stack mContexts = new Stack();

    protected abstract ExecStep[] getInterestingSteps(SnapshotBlock var1);

    public void handleFile(CaptureFileStep inStep, MachineInfo inMI) {
    }

    public void handlePlainResource(CaptureResourceStep inStep, ResourceDefinition inGeneratedRDef) {
    }

    public boolean handleCaptures() {
        return false;
    }

    protected SnapshotStepsContext getContext(SnapshotBlock inSnap, VariableSettingsSource inStepArgs, InstalledComponent inIComp, InstalledTarget inInstalledRetarget) {
        return new SnapshotStepsContext(this.getInterestingSteps(inSnap), inSnap, inStepArgs, inInstalledRetarget, inIComp);
    }

    public SnapshotStepsContext getRootContext() {
        return this.mRootContext;
    }

    public void startSnapshot(SnapshotBlock inSnap, VariableSettingsSource inStepArgs, InstalledComponent inIComp, InstalledTarget inInstalledRetarget) {
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("handling overall snapshot: " + inSnap.getName(), this);
        }
        SnapshotStepsContext ctx = this.getContext(inSnap, inStepArgs, inIComp, inInstalledRetarget);
        Logger.debug("Created context:" + ctx, this);
        if (this.mRootContext == null) {
            this.mRootContext = ctx;
        }
        this.mContexts.push(ctx);
    }

    public void endSnapshot() {
        SnapshotStepsContext ctx = (SnapshotStepsContext)this.mContexts.pop();
        if (!this.mContexts.isEmpty()) {
            SnapshotStepsContext parent = (SnapshotStepsContext)this.mContexts.peek();
            parent.addChild(ctx);
        }
    }
}

