/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.executor.snapshot;

import com.raplix.rolloutexpress.config.VariableSettingsSource;
import com.raplix.rolloutexpress.systemmodel.componentdb.SnapshotBlock;
import com.raplix.rolloutexpress.systemmodel.installdb.InstalledComponent;
import com.raplix.rolloutexpress.systemmodel.plandb.Caller;
import com.raplix.rolloutexpress.systemmodel.plandb.ExecStep;
import com.raplix.rolloutexpress.systemmodel.plandb.InstalledTarget;
import com.raplix.util.Util;
import java.util.Vector;

public class SnapshotStepsContext {
    private ExecStep[] mSteps;
    private SnapshotBlock mBlock;
    private VariableSettingsSource mStepArgs;
    private InstalledComponent mIComp;
    private InstalledTarget mInstalledTarget;
    private Vector mChildren = new Vector();
    private Caller mCaller;

    public SnapshotStepsContext(ExecStep[] inSteps, SnapshotBlock inSnap, VariableSettingsSource inStepArgs, InstalledTarget inInstalledTarget, InstalledComponent inIComp) {
        this.mSteps = inSteps;
        this.mBlock = inSnap;
        this.mStepArgs = inStepArgs;
        this.mIComp = inIComp;
        this.mInstalledTarget = inInstalledTarget;
        this.mCaller = this.mInstalledTarget.getCallerForMember(this.getBlock(), this.getIComp());
    }

    public ExecStep[] getSteps() {
        return this.mSteps;
    }

    public InstalledComponent getIComp() {
        return this.mIComp;
    }

    public InstalledTarget getITarget() {
        return this.mInstalledTarget;
    }

    public SnapshotBlock getBlock() {
        return this.mBlock;
    }

    public VariableSettingsSource getStepArgs() {
        return this.mStepArgs;
    }

    public void addChild(SnapshotStepsContext child) {
        this.mChildren.add(child);
    }

    public SnapshotStepsContext[] getChildren() {
        return this.mChildren.toArray(new SnapshotStepsContext[this.mChildren.size()]);
    }

    public Caller getCaller() {
        return this.mCaller;
    }

    public String toString() {
        return "StepContext:" + this.mBlock.getName() + ":Comp:" + this.mIComp.getInstallPath() + ":" + Util.getStringFromArray(this.mStepArgs.getVarNames(), ",") + ":steps:" + Util.getStringFromArray(this.mSteps, ",");
    }
}

