/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.executor.snapshot;

import com.raplix.rolloutexpress.config.VariableSettingsSource;
import com.raplix.rolloutexpress.executor.PlanExecutionException;
import com.raplix.rolloutexpress.executor.snapshot.SnapshotCaptureContext;
import com.raplix.rolloutexpress.executor.snapshot.SnapshotItemGatherer;
import com.raplix.rolloutexpress.executor.snapshot.SnapshotSet;
import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.systemmodel.componentdb.ResourceDefinition;
import com.raplix.rolloutexpress.systemmodel.componentdb.SnapshotBlock;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostID;
import com.raplix.rolloutexpress.systemmodel.hostdbx.MachineInfo;
import com.raplix.rolloutexpress.systemmodel.installdb.InstalledComponent;
import com.raplix.rolloutexpress.systemmodel.installdb.InstalledComponentID;
import com.raplix.rolloutexpress.systemmodel.plandb.CaptureFileStep;
import com.raplix.rolloutexpress.systemmodel.plandb.CaptureResourceStep;
import com.raplix.rolloutexpress.systemmodel.plandb.InstalledTarget;
import com.raplix.util.logger.Logger;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Stack;

public class SnapshotSetGatherer
implements SnapshotItemGatherer {
    private transient SnapshotSet mCurrentSet = null;
    private transient HashMap mHostContextMap = new HashMap();
    private transient Stack mSnapshotSetStack = new Stack();
    private transient InstalledComponentID mTopLevelInstalledCompID = null;
    private LinkedList mContextList = new LinkedList();

    public void startSnapshot(SnapshotBlock inSnap, VariableSettingsSource inStepArgs, InstalledComponent inIComp, InstalledTarget inInstalledRetarget) throws PlanExecutionException {
        SnapshotCaptureContext ctx;
        if (this.mCurrentSet != null) {
            this.mSnapshotSetStack.push(this.mCurrentSet);
        }
        if (this.mTopLevelInstalledCompID == null) {
            this.mTopLevelInstalledCompID = inIComp.getID();
        }
        if ((ctx = this.findContextForPhysicalHost(inIComp)) == null) {
            this.mCurrentSet = new SnapshotSet(this.mTopLevelInstalledCompID);
            ctx = new SnapshotCaptureContext(this.mCurrentSet, inInstalledRetarget, inSnap.getName());
            this.addContext(inIComp, ctx);
        } else {
            this.mCurrentSet = ctx.getSnapshotSet();
        }
    }

    public void endSnapshot() {
        if (!this.mSnapshotSetStack.isEmpty()) {
            this.mCurrentSet = (SnapshotSet)this.mSnapshotSetStack.pop();
        }
    }

    public boolean handleCaptures() {
        return true;
    }

    public void handleFile(CaptureFileStep inStep, MachineInfo inMI) throws PlanExecutionException {
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("handling file " + inStep.toString(), this);
        }
        this.mCurrentSet.addFileStep(inStep, inMI);
    }

    public void handlePlainResource(CaptureResourceStep inStep, ResourceDefinition inGeneratedRDef) throws PlanExecutionException {
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("handling plainRsrc: " + inStep.toString(), this);
        }
        this.mCurrentSet.addResourceStep(inStep, inGeneratedRDef);
    }

    public String getName() {
        return "Resource";
    }

    public SnapshotCaptureContext[] getContexts() {
        return this.mContextList.toArray(new SnapshotCaptureContext[this.mContextList.size()]);
    }

    private void addContext(InstalledComponent inInstComp, SnapshotCaptureContext context) throws PlanExecutionException {
        this.mContextList.addLast(context);
        this.mHostContextMap.put(this.translateInstCompToHost(inInstComp), context);
    }

    private HostID translateInstCompToHost(InstalledComponent inInstComp) throws PlanExecutionException {
        try {
            return inInstComp.getTargetID().getByIDQuery().selectSummaryView().getPhysicalHostID();
        }
        catch (RPCException e) {
            throw new PlanExecutionException(e);
        }
        catch (PersistenceManagerException e) {
            throw new PlanExecutionException(e);
        }
    }

    private SnapshotCaptureContext findContextForPhysicalHost(InstalledComponent inComp) throws PlanExecutionException {
        return (SnapshotCaptureContext)this.mHostContextMap.get(this.translateInstCompToHost(inComp));
    }
}

