/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.executor.snapshot;

import com.raplix.rolloutexpress.command.commandresult.FileSpec;
import com.raplix.rolloutexpress.executor.PlanExecutionException;
import com.raplix.rolloutexpress.executor.PlanExecutorMessages;
import com.raplix.rolloutexpress.message.ROXMessage;
import com.raplix.rolloutexpress.net.rpc.RPCSerializable;
import com.raplix.rolloutexpress.systemmodel.componentdb.DeployMode;
import com.raplix.rolloutexpress.systemmodel.componentdb.ResourceDefinition;
import com.raplix.rolloutexpress.systemmodel.hostdbx.MachineInfo;
import com.raplix.rolloutexpress.systemmodel.installdb.InstalledComponentID;
import com.raplix.rolloutexpress.systemmodel.installdb.SnapshotID;
import com.raplix.rolloutexpress.systemmodel.plandb.CaptureFileStep;
import com.raplix.rolloutexpress.systemmodel.plandb.CaptureResourceStep;
import com.raplix.rolloutexpress.systemmodel.plandb.SnapshotFilter;
import com.raplix.rolloutexpress.systemmodel.plandb.SnapshotOwnership;
import com.raplix.util.logger.Logger;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Vector;

public class SnapshotSet
implements RPCSerializable,
PlanExecutorMessages {
    private Vector mFiles = new Vector();
    private SnapshotID mSnapshotID;
    private InstalledComponentID mInstalledComponentID;

    public SnapshotSet(InstalledComponentID inICompID) {
        this.mSnapshotID = null;
        this.mInstalledComponentID = inICompID;
    }

    public void addFileStep(CaptureFileStep inStep, MachineInfo inMI) throws PlanExecutionException {
        this.addDirective(new FileSnapshot(inStep, inMI));
    }

    public void addResourceStep(CaptureResourceStep inStep, ResourceDefinition inGeneratedRDef) throws PlanExecutionException {
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("path:" + inGeneratedRDef.getFullTargetPath(), this);
        }
        this.addDirective(new ResourceSnapshot(inGeneratedRDef.getFullTargetPath(), DeployMode.ADD_TO.equals(inGeneratedRDef.getDeployMode()) ? SnapshotFilter.FILES : SnapshotFilter.BOTH));
    }

    public InstalledComponentID getInstalledComponentID() {
        return this.mInstalledComponentID;
    }

    public SnapshotID getSnapshotID() {
        return this.mSnapshotID;
    }

    public Enumeration getSnapshotDirectives() {
        return this.mFiles.elements();
    }

    public Enumeration getSnapshotDirectivesReverseOrder() {
        Vector clone = (Vector)this.mFiles.clone();
        Collections.reverse(clone);
        return clone.elements();
    }

    private void addDirective(SnapshotDirective inDirective) {
        this.mFiles.add(inDirective);
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("added directive:" + inDirective, this);
        }
    }

    public String toString() {
        return "SnapshotID:" + this.mSnapshotID + ":instID:" + this.mInstalledComponentID + ":details:" + this.mFiles;
    }

    private SnapshotSet() {
    }

    public void setSnapshotID(SnapshotID snapshotID) {
        this.mSnapshotID = snapshotID;
    }

    static class FileSnapshot
    extends SnapshotDirective {
        private CaptureFileStep mFileStep;

        FileSnapshot(CaptureFileStep inFileStep, MachineInfo inMI) throws PlanExecutionException {
            this.mFileStep = inFileStep;
            if (!FileSpec.getIsAbsolutePath(this.getPath(), inMI)) {
                throw new PlanExecutionException(new ROXMessage("pe.SNAP_NOT_ABS_PATH", this.getPath()));
            }
        }

        public String getPath() {
            return this.mFileStep.getPath();
        }

        public SnapshotOwnership getOwnership() {
            return this.mFileStep.getOwnership();
        }

        public boolean getIsRecursive() {
            return this.mFileStep.getIsRecursive();
        }

        public SnapshotFilter getFilter() {
            return this.mFileStep.getFilter();
        }

        public String getDisplayName() {
            return this.mFileStep.getDisplayName();
        }

        public String toString() {
            return "FileSnapshot,path:" + this.mFileStep.getPath() + ":Ownr:" + this.mFileStep.getOwnership() + ":recursive:" + this.mFileStep.getIsRecursive() + ":filter:" + this.mFileStep.getFilter() + ":displayName:" + this.mFileStep.getDisplayName();
        }
    }

    static class ResourceSnapshot
    extends SnapshotDirective {
        private String mPath;
        private SnapshotFilter mFilter;

        ResourceSnapshot(String inPath, SnapshotFilter inFilter) {
            this.mPath = inPath;
            this.mFilter = inFilter;
        }

        public String getPath() {
            return this.mPath;
        }

        public SnapshotFilter getFilter() {
            return this.mFilter;
        }

        public boolean getIsRecursive() {
            return true;
        }

        public SnapshotOwnership getOwnership() {
            return SnapshotOwnership.SET_SELF;
        }

        public String getDisplayName() {
            return null;
        }

        public String toString() {
            return "ResourceSnapshot,Path:" + this.mPath + ":filter:" + this.mFilter;
        }
    }

    public static abstract class SnapshotDirective
    implements RPCSerializable {
        public abstract String getPath();

        public abstract SnapshotOwnership getOwnership();

        public abstract boolean getIsRecursive();

        public abstract SnapshotFilter getFilter();

        public abstract String getDisplayName();
    }
}

