/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.executor.query;

import com.raplix.rolloutexpress.event.ROXEventFactoryTable;
import com.raplix.rolloutexpress.event.ROXTaskStartEvent;
import com.raplix.rolloutexpress.event.query.bean.ExecutionPlanBean;
import com.raplix.rolloutexpress.event.query.bean.RunningPlanBean;
import com.raplix.rolloutexpress.event.query.bean.TaskBean;
import com.raplix.rolloutexpress.executor.TaskID;
import com.raplix.rolloutexpress.executor.TaskInfo;
import com.raplix.rolloutexpress.executor.TaskInfoTable;
import com.raplix.rolloutexpress.executor.query.RunningPlanQueryOrder;
import com.raplix.rolloutexpress.message.ROXMessageManager;
import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.persist.HasObjectID;
import com.raplix.rolloutexpress.persist.Visibility;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.persist.query.MultiObjectQueryImplBase;
import com.raplix.rolloutexpress.persist.query.MultiSelectableObjectQuery;
import com.raplix.rolloutexpress.persist.query.QueryContext;
import com.raplix.rolloutexpress.persist.query.ResultProcessor;
import com.raplix.rolloutexpress.persist.query.builder.AndExp;
import com.raplix.rolloutexpress.persist.query.builder.ColumnNode;
import com.raplix.rolloutexpress.persist.query.builder.ConditionalExpression;
import com.raplix.rolloutexpress.persist.query.builder.QueryBuilder;
import com.raplix.rolloutexpress.persist.query.builder.SelectList;
import com.raplix.rolloutexpress.persist.query.builder.TableList;
import com.raplix.rolloutexpress.systemmodel.catdb.CategoryID;
import com.raplix.rolloutexpress.systemmodel.plandb.ExecutionPlanImplTable;
import com.raplix.rolloutexpress.systemmodel.plandb.PlanToCategoryLinkTable;
import com.raplix.rolloutexpress.systemmodel.plandb.SummaryExecutionPlan;
import com.raplix.util.logger.Logger;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Vector;

public class MultiRunningPlanQuery
extends MultiObjectQueryImplBase
implements MultiSelectableObjectQuery {
    private Visibility mVisibilityFilter;
    private CategoryID mCategoryFilter;
    private Boolean mRunningFilter;
    private ConditionalExpression mQueryConditional;
    static final ExecutionPlanImplTable mPlan = new ExecutionPlanImplTable("ep");
    static final TaskInfoTable mTask = new TaskInfoTable("ti");
    static final ROXEventFactoryTable mEvent = new ROXEventFactoryTable("ef");
    static final PlanToCategoryLinkTable LINK_T = PlanToCategoryLinkTable.DEFAULT;
    private static final String MSG_QUERY_DURATION = "event.QUERY_DURATION";
    public static final String ORDERNAME_BY_DATE_DSC = "eventdate-";

    public static MultiRunningPlanQuery allPlans() throws PersistenceManagerException {
        MultiRunningPlanQuery mrpq = new MultiRunningPlanQuery();
        mrpq.setObjectOrder(RunningPlanQueryOrder.BY_DATE_DSC);
        return mrpq;
    }

    public static MultiRunningPlanQuery byTaskIDs(TaskID[] IDs) {
        return new MultiRunningPlanQuery(TaskInfoTable.emptyIn(MultiRunningPlanQuery.mTask.ID, TaskInfoTable.rList(IDs)));
    }

    public HasObjectID[] selectObjects() throws RPCException, PersistenceManagerException {
        return this.select();
    }

    public RunningPlanBean[] select() throws RPCException, PersistenceManagerException {
        long time = System.currentTimeMillis();
        MultiRunningPlanQueryResultSetProcessor resultProcessor = new MultiRunningPlanQueryResultSetProcessor(mPlan, mEvent, mTask);
        RunningPlanBean[] result = (RunningPlanBean[])this.selectArray(this.getSelectStatement(), resultProcessor, RunningPlanBean.class);
        if (Logger.isInfoEnabled(this)) {
            Logger.info(ROXMessageManager.messageAsString(MSG_QUERY_DURATION, new Object[]{"RunningPlanQuery", new Long(System.currentTimeMillis() - time)}), this);
        }
        return result;
    }

    public Visibility getVisibilityFilter() {
        return this.mVisibilityFilter;
    }

    public void setVisibilityFilter(Visibility visibilityFilter) {
        this.mVisibilityFilter = visibilityFilter;
    }

    public CategoryID getCategoryFilter() {
        return this.mCategoryFilter;
    }

    public void setCategoryFilter(CategoryID categoryFilter) {
        this.mCategoryFilter = categoryFilter;
    }

    public Boolean getRunningFilter() {
        return this.mRunningFilter;
    }

    public void setRunningFilter(Boolean runningFilter) {
        this.mRunningFilter = runningFilter;
    }

    protected void addFilterCondition(QueryContext ctx) throws RPCException, PersistenceManagerException {
        super.addFilterCondition(ctx);
        if (this.getVisibilityFilter() != null) {
            ctx.addAndWhereCondition(ExecutionPlanImplTable.equals(mPlan.cVisibility(), this.getVisibilityFilter()));
        }
        if (this.getCategoryFilter() != null) {
            ConditionalExpression matchesCat = LINK_T.matchesCategoryID(this.getCategoryFilter(), MultiRunningPlanQuery.mPlan.ID);
            ctx.addAndWhereCondition(matchesCat);
        }
        if (this.getRunningFilter() != null) {
            ConditionalExpression runningFilter = TaskInfoTable.isNull(MultiRunningPlanQuery.mTask.TaskComplete);
            if (!this.getRunningFilter().booleanValue()) {
                runningFilter = TaskInfoTable.not(runningFilter);
            }
            ctx.addAndWhereCondition(runningFilter);
        }
        ctx.addAndWhereCondition(TaskInfoTable.not(TaskInfoTable.equals(MultiRunningPlanQuery.mTask.ID, TaskID.TASK_SENTINEL_ID)));
    }

    private MultiRunningPlanQuery() {
        super(RunningPlanQueryOrder.FACTORY);
    }

    private MultiRunningPlanQuery(ConditionalExpression cond) {
        super(RunningPlanQueryOrder.FACTORY);
        this.mQueryConditional = cond;
    }

    protected TableList getTableList() {
        return QueryBuilder.tList(mPlan, mTask, mEvent);
    }

    protected SelectList getSelectList() {
        return QueryBuilder.sList(mTask.allColumns(), mPlan.allColumns(), mEvent.allColumns());
    }

    protected ConditionalExpression getWhereCondition() {
        AndExp where = QB.and();
        if (null != this.mQueryConditional) {
            where.add(this.mQueryConditional);
        }
        where.add(QueryBuilder.equals((ColumnNode)MultiRunningPlanQuery.mPlan.ID, MultiRunningPlanQuery.mEvent.PlanID));
        where.add(QueryBuilder.equals(MultiRunningPlanQuery.mEvent.EventType, ROXTaskStartEvent.class.getName()));
        where.add(QueryBuilder.equals((ColumnNode)MultiRunningPlanQuery.mEvent.TaskID, MultiRunningPlanQuery.mTask.ID));
        return where;
    }

    private static final class MultiRunningPlanQueryResultSetProcessor
    extends ResultProcessor {
        private ExecutionPlanImplTable mPlanTable;
        private ROXEventFactoryTable mEventTable;
        private TaskInfoTable mTaskTable;

        public MultiRunningPlanQueryResultSetProcessor(ExecutionPlanImplTable inPlanTable, ROXEventFactoryTable inEventTable, TaskInfoTable inTaskTable) {
            this.mPlanTable = inPlanTable;
            this.mEventTable = inEventTable;
            this.mTaskTable = inTaskTable;
        }

        public Object processRow(ResultSet inResultSet) throws PersistenceManagerException, SQLException {
            SummaryExecutionPlan thePlan = SummaryExecutionPlan.createFromResultSet(this.mPlanTable, inResultSet);
            TaskInfo theTask = this.mTaskTable.retrieveObject(inResultSet);
            ROXTaskStartEvent theEvent = (ROXTaskStartEvent)this.mEventTable.retrieveObject(inResultSet).instantiate();
            RunningPlanBean bean = new RunningPlanBean(new TaskBean(theTask), new ExecutionPlanBean(thePlan));
            bean.setIsRunning(theTask.getTaskComplete() == null);
            return bean;
        }

        public Vector getResults() {
            return this.mResults;
        }
    }
}

