/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.executor.query;

import com.raplix.rolloutexpress.event.ROXEventFactoryTable;
import com.raplix.rolloutexpress.event.ROXTaskStartEvent;
import com.raplix.rolloutexpress.event.query.bean.ExecutionPlanBean;
import com.raplix.rolloutexpress.event.query.bean.RunningPlanBean;
import com.raplix.rolloutexpress.event.query.bean.TaskBean;
import com.raplix.rolloutexpress.executor.AutoGeneratedPlan;
import com.raplix.rolloutexpress.executor.AutoGeneratedPlanID;
import com.raplix.rolloutexpress.executor.AutoGeneratedPlanTable;
import com.raplix.rolloutexpress.executor.PlanExecutorMessages;
import com.raplix.rolloutexpress.executor.TaskInfo;
import com.raplix.rolloutexpress.executor.TaskInfoTable;
import com.raplix.rolloutexpress.executor.query.AutoGenPlanQueryOrder;
import com.raplix.rolloutexpress.message.ROXMessageManager;
import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.persist.HasObjectID;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.persist.query.MultiObjectQueryImplBase;
import com.raplix.rolloutexpress.persist.query.MultiSelectableObjectQuery;
import com.raplix.rolloutexpress.persist.query.ResultProcessor;
import com.raplix.rolloutexpress.persist.query.builder.AndExp;
import com.raplix.rolloutexpress.persist.query.builder.ColumnNode;
import com.raplix.rolloutexpress.persist.query.builder.ConditionalExpression;
import com.raplix.rolloutexpress.persist.query.builder.QueryBuilder;
import com.raplix.rolloutexpress.persist.query.builder.SelectList;
import com.raplix.rolloutexpress.persist.query.builder.TableClause;
import com.raplix.rolloutexpress.persist.query.builder.TableList;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentID;
import com.raplix.rolloutexpress.systemmodel.componentdb.NamedBlockType;
import com.raplix.rolloutexpress.systemmodel.plandb.ExecutionPlanImplTable;
import com.raplix.rolloutexpress.systemmodel.plandb.SummaryExecutionPlan;
import com.raplix.util.logger.Logger;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.TreeSet;
import java.util.Vector;

public class MultiAutoGenPlanQuery
extends MultiObjectQueryImplBase
implements PlanExecutorMessages,
MultiSelectableObjectQuery {
    private ComponentID mComponentID;
    private String mProcedureName;
    private NamedBlockType mProcedureType;
    private ConditionalExpression mQueryConditional;
    private boolean mAutoGenPlansOnly = false;
    static final AutoGeneratedPlanTable agPlan = new AutoGeneratedPlanTable("agp");
    static final ExecutionPlanImplTable exPlan = new ExecutionPlanImplTable("ep");
    static final ROXEventFactoryTable event = new ROXEventFactoryTable("ef");
    static final ROXEventFactoryTable innerEvent = new ROXEventFactoryTable("ief");
    static final TaskInfoTable task = new TaskInfoTable("ti");
    private static final String MSG_QUERY_DURATION = "event.QUERY_DURATION";
    public static final String ORDERNAME_BY_DATE_ASC = "eventdate";

    public static MultiAutoGenPlanQuery all() {
        MultiAutoGenPlanQuery result = new MultiAutoGenPlanQuery((ConditionalExpression)null);
        result.setObjectOrder(AutoGenPlanQueryOrder.BY_COMPONENT_ASC);
        result.mAutoGenPlansOnly = true;
        return result;
    }

    public static MultiAutoGenPlanQuery autoGenPlansForComponent(ComponentID inComponentID, String inProcedureName, NamedBlockType inProcedureType) {
        MultiAutoGenPlanQuery magpq = new MultiAutoGenPlanQuery(inComponentID, inProcedureName, inProcedureType);
        magpq.setObjectOrder(AutoGenPlanQueryOrder.BY_DATE_ASC);
        return magpq;
    }

    public static MultiAutoGenPlanQuery byIDs(AutoGeneratedPlanID[] IDs) {
        MultiAutoGenPlanQuery theQuery = new MultiAutoGenPlanQuery(QueryBuilder.emptyIn(MultiAutoGenPlanQuery.agPlan.ID, QueryBuilder.rList(IDs)));
        theQuery.mAutoGenPlansOnly = true;
        return theQuery;
    }

    public RunningPlanBean[] select() throws RPCException, PersistenceManagerException {
        long time = System.currentTimeMillis();
        MultiAutoGenPlanQueryResultSetProcessor resultProcessor = new MultiAutoGenPlanQueryResultSetProcessor(agPlan, exPlan, task, false);
        RunningPlanBean[] result = (RunningPlanBean[])this.selectArray(this.getSelectStatement(), resultProcessor, RunningPlanBean.class);
        TreeSet<RunningPlanBean> finalList = new TreeSet<RunningPlanBean>(RunningPlanBean.STATUSDATERUNNINGPLANBEAN_COMPARATOR);
        for (int i = 0; i < result.length; ++i) {
            finalList.add(result[i]);
        }
        if (Logger.isInfoEnabled(this)) {
            Logger.info(ROXMessageManager.messageAsString(MSG_QUERY_DURATION, new Object[]{"AutoGenPlanQuery", new Long(System.currentTimeMillis() - time)}), this);
        }
        return finalList.toArray(new RunningPlanBean[0]);
    }

    public HasObjectID[] selectObjects() throws RPCException, PersistenceManagerException {
        long time = System.currentTimeMillis();
        MultiAutoGenPlanQueryResultSetProcessor resultProcessor = new MultiAutoGenPlanQueryResultSetProcessor(agPlan, exPlan, task, this.mAutoGenPlansOnly);
        HasObjectID[] result = (HasObjectID[])this.selectArray(this.getSelectStatement(), resultProcessor, AutoGeneratedPlan.class);
        if (Logger.isInfoEnabled(this)) {
            Logger.info(ROXMessageManager.messageAsString(MSG_QUERY_DURATION, new Object[]{"AutoGenPlanQuery", new Long(System.currentTimeMillis() - time)}), this);
        }
        return result;
    }

    private MultiAutoGenPlanQuery(ComponentID inComponentID, String inProcedureName, NamedBlockType inProcedureType) {
        super(AutoGenPlanQueryOrder.FACTORY);
        this.mComponentID = inComponentID;
        this.mProcedureName = inProcedureName;
        this.mProcedureType = inProcedureType;
    }

    private MultiAutoGenPlanQuery(ConditionalExpression cond) {
        super(AutoGenPlanQueryOrder.FACTORY);
        this.mQueryConditional = cond;
    }

    protected TableList getTableList() {
        if (this.mAutoGenPlansOnly) {
            return QueryBuilder.tList(agPlan);
        }
        return QueryBuilder.tList(QueryBuilder.tList(agPlan, exPlan, event), (TableClause)task);
    }

    protected SelectList getSelectList() {
        if (this.mAutoGenPlansOnly) {
            return agPlan.allColumns();
        }
        return QueryBuilder.sList(agPlan.allColumns(), exPlan.allColumns(), task.allColumns());
    }

    protected ConditionalExpression getWhereCondition() {
        AndExp where = null;
        if (null != this.mQueryConditional || !this.mAutoGenPlansOnly) {
            where = QueryBuilder.and();
        }
        if (null != this.mQueryConditional) {
            where.add(this.mQueryConditional);
        }
        if (!this.mAutoGenPlansOnly) {
            where.add(QueryBuilder.equals((ColumnNode)MultiAutoGenPlanQuery.agPlan.PlanID, MultiAutoGenPlanQuery.exPlan.ID));
            where.add(QueryBuilder.equals((ColumnNode)MultiAutoGenPlanQuery.agPlan.PlanID, MultiAutoGenPlanQuery.event.PlanID));
            where.add(QueryBuilder.equals(MultiAutoGenPlanQuery.event.EventType, ROXTaskStartEvent.class.getName()));
            where.add(QueryBuilder.equals((ColumnNode)MultiAutoGenPlanQuery.event.TaskID, MultiAutoGenPlanQuery.task.ID));
            if (null != this.mComponentID) {
                where.add(QueryBuilder.equals(MultiAutoGenPlanQuery.agPlan.ComponentID, this.mComponentID));
            }
            if (null != this.mProcedureName) {
                where.add(QueryBuilder.equals(MultiAutoGenPlanQuery.agPlan.ProcedureName, this.mProcedureName));
            }
            if (null != this.mProcedureType) {
                where.add(QueryBuilder.equals(MultiAutoGenPlanQuery.agPlan.ProcedureTypeAsString, this.mProcedureType.toString()));
            }
        }
        return where;
    }

    private static final class MultiAutoGenPlanQueryResultSetProcessor
    extends ResultProcessor {
        private AutoGeneratedPlanTable mAGPlanTable;
        private ExecutionPlanImplTable mEXPlanTable;
        private TaskInfoTable mTaskTable;
        private boolean mAutoGenPlansOnly;

        public MultiAutoGenPlanQueryResultSetProcessor(AutoGeneratedPlanTable inagPlanTable, ExecutionPlanImplTable inexPlanTable, TaskInfoTable inTaskTable, boolean inAutoGenPlansOnly) {
            this.mAGPlanTable = inagPlanTable;
            this.mEXPlanTable = inexPlanTable;
            this.mTaskTable = inTaskTable;
            this.mAutoGenPlansOnly = inAutoGenPlansOnly;
        }

        public Object processRow(ResultSet inResultSet) throws PersistenceManagerException, SQLException {
            if (this.mAutoGenPlansOnly) {
                return this.mAGPlanTable.retrieveObject(inResultSet);
            }
            SummaryExecutionPlan thePlan = SummaryExecutionPlan.createFromResultSet(this.mEXPlanTable, inResultSet);
            TaskInfo theTask = this.mTaskTable.retrieveObject(inResultSet);
            RunningPlanBean bean = new RunningPlanBean(new TaskBean(theTask), new ExecutionPlanBean(thePlan));
            bean.setIsRunning(theTask.getTaskComplete() == null);
            return bean;
        }

        public Vector getResults() {
            return this.mResults;
        }
    }
}

