/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.executor.query;

import com.raplix.rolloutexpress.executor.AutoGeneratedPlan;
import com.raplix.rolloutexpress.executor.AutoGeneratedPlanTable;
import com.raplix.rolloutexpress.executor.TaskInfoTable;
import com.raplix.rolloutexpress.net.rpc.RPCSerializable;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.persist.query.ResultProcessor;
import com.raplix.rolloutexpress.persist.query.builder.ColumnNode;
import com.raplix.rolloutexpress.persist.query.builder.OrderByList;
import com.raplix.rolloutexpress.persist.query.builder.QueryBuilder;
import com.raplix.rolloutexpress.persist.query.builder.SelectList;
import com.raplix.rolloutexpress.persist.query.builder.TableClause;
import com.raplix.rolloutexpress.persist.query.builder.TableColumnList;
import com.raplix.rolloutexpress.persist.query.builder.TableList;
import com.raplix.rolloutexpress.persist.query.builder.WhereClause;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentID;
import com.raplix.rolloutexpress.systemmodel.componentdb.NamedBlockType;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Vector;

public class AutogenPlanRunHistoryBean
implements RPCSerializable {
    private String mProcedureName;
    private NamedBlockType mProcedureType;

    public AutogenPlanRunHistoryBean() {
    }

    public AutogenPlanRunHistoryBean(String inProcedureName, NamedBlockType inProcedureType) {
        this.setProcedureName(inProcedureName);
        this.setProcedureType(inProcedureType);
    }

    public String getProcedureName() {
        return this.mProcedureName;
    }

    public int getProcedureTypeAsInt() {
        if (null == this.mProcedureType) {
            return -1;
        }
        if (this.mProcedureType.equals(NamedBlockType.INSTALL)) {
            return 105;
        }
        if (this.mProcedureType.equals(NamedBlockType.UNINSTALL)) {
            return 109;
        }
        if (this.mProcedureType.equals(NamedBlockType.CONTROL)) {
            return 102;
        }
        return -1;
    }

    public NamedBlockType getProcedureType() {
        return this.mProcedureType;
    }

    public void setProcedureName(String inProcedureName) {
        this.mProcedureName = inProcedureName;
    }

    public void setProcedureType(NamedBlockType inProcedureType) {
        this.mProcedureType = inProcedureType;
    }

    public static AutogenPlanRunHistoryBean[] queryAutogenRunHistory(ComponentID inComponentID) throws PersistenceManagerException {
        AutogenRunHistoryRetriever retriever = new AutogenRunHistoryRetriever(inComponentID);
        return retriever.getResults();
    }

    private static final class AutogenRunHistoryResultSetProcessor
    extends ResultProcessor {
        private AutoGeneratedPlanTable mAGPlanTable;

        public AutogenRunHistoryResultSetProcessor(AutoGeneratedPlanTable inAGPlanTable) {
            this.mAGPlanTable = inAGPlanTable;
        }

        public Object processRow(ResultSet inResultSet) throws PersistenceManagerException, SQLException {
            AutoGeneratedPlan agPlan = this.mAGPlanTable.retrieveObject(inResultSet);
            AutogenPlanRunHistoryBean bean = new AutogenPlanRunHistoryBean(agPlan.getProcedureName(), agPlan.getProcedureType());
            return bean;
        }

        public Vector getResults() {
            return this.mResults;
        }
    }

    private static class AutogenRunHistoryRetriever
    extends QueryBuilder {
        private AutogenPlanRunHistoryBean[] mResults = null;

        protected AutogenRunHistoryRetriever(ComponentID inComponentID) throws PersistenceManagerException {
            this.mResults = this.getRunHistory(inComponentID);
        }

        protected AutogenPlanRunHistoryBean[] getRunHistory(ComponentID inComponentID) throws PersistenceManagerException {
            AutoGeneratedPlanTable agPlanTable = new AutoGeneratedPlanTable("agp");
            TaskInfoTable taskTable = new TaskInfoTable("ti");
            TableColumnList selectList = agPlanTable.allColumns();
            TableList tableList = AutogenRunHistoryRetriever.tList(agPlanTable, (TableClause)taskTable);
            WhereClause where = AutogenRunHistoryRetriever.where(AutogenRunHistoryRetriever.and(AutogenRunHistoryRetriever.equals(agPlanTable.ComponentID, inComponentID), AutogenRunHistoryRetriever.equals((ColumnNode)agPlanTable.PlanID, taskTable.PlanID)));
            OrderByList orderBy = AutogenRunHistoryRetriever.oList(AutogenRunHistoryRetriever.orderByAsc(agPlanTable.ProcedureTypeAsString), AutogenRunHistoryRetriever.orderByAsc(agPlanTable.ProcedureName));
            AutogenRunHistoryResultSetProcessor historyProcessor = new AutogenRunHistoryResultSetProcessor(agPlanTable);
            AutogenRunHistoryRetriever.execute(AutogenRunHistoryRetriever.select((SelectList)selectList, tableList, where, orderBy), historyProcessor);
            Vector results = historyProcessor.getResults();
            return results.toArray(new AutogenPlanRunHistoryBean[0]);
        }

        protected AutogenPlanRunHistoryBean[] getResults() {
            return this.mResults;
        }
    }
}

