/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.executor.eventhandlers;

import com.raplix.rolloutexpress.event.ROXEvent;
import com.raplix.rolloutexpress.event.ROXStepStartEvent;
import com.raplix.rolloutexpress.executor.StepInfo;
import com.raplix.rolloutexpress.executor.StepStatus;
import com.raplix.rolloutexpress.executor.TaskInfo;
import com.raplix.rolloutexpress.executor.eventhandlers.StepEventHandler;
import com.raplix.rolloutexpress.net.rpc.CommandException;
import com.raplix.util.logger.Logger;

public class StepStartEventHandler
extends StepEventHandler {
    protected void handleEvent(ROXEvent inEvent, TaskInfo inTaskInfo) throws CommandException {
        StepInfo[] actualSteps;
        ROXStepStartEvent event = (ROXStepStartEvent)inEvent;
        StepInfo principalStep = event.getStepInfo();
        if (Logger.isDebugEnabled("executor.eventhandlers")) {
            Logger.debug("Handling StepStartEvent for " + principalStep, "executor.eventhandlers");
        }
        principalStep.setHostsStarted(1);
        principalStep.setDescription(event.getMessage());
        principalStep.setStartDate(event.getDate());
        principalStep.setStepStatus(event.getIsPreflight() ? StepStatus.PREFLIGHT_RUNNING : StepStatus.DEPLOYMENT_RUNNING);
        if (Logger.isDebugEnabled("executor.eventhandlers")) {
            Logger.debug("Step is now " + principalStep, "executor.eventhandlers");
        }
        this.addObjectToSave(principalStep);
        inTaskInfo.addStep(principalStep);
        if (event.getIsPreflight() && principalStep.getMappable() && null != (actualSteps = inTaskInfo.findSteps(principalStep.getStepMap()))) {
            for (int i = 0; i < actualSteps.length; ++i) {
                StepInfo currentStep = actualSteps[i];
                if (currentStep.equals(principalStep) || currentStep.getDescription() != null) continue;
                currentStep.setDescription(event.getMessage());
                this.addObjectToSave(currentStep);
            }
        }
    }
}

