/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.executor.eventhandlers;

import com.raplix.rolloutexpress.event.ROXEvent;
import com.raplix.rolloutexpress.event.ROXStepFailedEvent;
import com.raplix.rolloutexpress.executor.RunLevel;
import com.raplix.rolloutexpress.executor.StepID;
import com.raplix.rolloutexpress.executor.StepInfo;
import com.raplix.rolloutexpress.executor.StepStatus;
import com.raplix.rolloutexpress.executor.TaskInfo;
import com.raplix.rolloutexpress.executor.TaskStatus;
import com.raplix.rolloutexpress.executor.eventhandlers.StepEventHandler;
import com.raplix.rolloutexpress.net.rpc.CommandException;
import com.raplix.util.logger.Logger;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.TreeSet;

public class StepFailedEventHandler
extends StepEventHandler {
    protected boolean shouldSkipStep(StepInfo inStep, StepInfo inParentStep) throws CommandException {
        if (inStep.getStepStatus().completed()) {
            return false;
        }
        if (!inStep.getMandatoryStep()) {
            return true;
        }
        if (null == inStep.getParentStepID()) {
            return false;
        }
        return !inParentStep.getStepStatus().hasStarted();
    }

    protected void handleEvent(ROXEvent inEvent, TaskInfo inTaskInfo) throws CommandException {
        ROXStepFailedEvent event = (ROXStepFailedEvent)inEvent;
        StepInfo principalStep = event.getStepInfo();
        if (Logger.isDebugEnabled("executor.eventhandlers")) {
            Logger.debug("In StepFailedEventHandler, received a stepfailed for " + principalStep, "executor.eventhandlers");
        }
        if (event.getSeverity() == 4) {
            if (Logger.isDebugEnabled("executor.eventhandlers")) {
                Logger.debug("StepFailed is of type error", "executor.eventhandlers");
            }
            TreeSet<StepInfo> steps = new TreeSet<StepInfo>(StepInfo.RUNLEVELSTEPMAPHOSTSTEPMAP_COMPARATOR);
            Hashtable<StepID, StepInfo> stepsByID = new Hashtable<StepID, StepInfo>();
            StepStatus failedStatus = null;
            if (event.getHandled()) {
                steps.add(principalStep);
            } else {
                int i;
                StepInfo[] tmpSteps;
                if (event.getIsPreflight()) {
                    tmpSteps = inTaskInfo.getPreflightSteps();
                    for (i = 0; i < tmpSteps.length; ++i) {
                        stepsByID.put(tmpSteps[i].getStepID(), tmpSteps[i]);
                        if (!event.getTargetID().equals(tmpSteps[i].getTargetID())) continue;
                        steps.add(tmpSteps[i]);
                    }
                    failedStatus = StepStatus.PREFLIGHT_ERROR;
                } else {
                    failedStatus = StepStatus.PRIOR_ERROR;
                }
                if (inTaskInfo.getRunLevel().equals(RunLevel.ACTUAL)) {
                    tmpSteps = inTaskInfo.getActualSteps();
                    for (i = 0; i < tmpSteps.length; ++i) {
                        stepsByID.put(tmpSteps[i].getStepID(), tmpSteps[i]);
                        if (!event.getTargetID().equals(tmpSteps[i].getTargetID())) continue;
                        steps.add(tmpSteps[i]);
                    }
                }
            }
            StepInfo currentStep = null;
            Iterator i = steps.tailSet(event.getStepInfo()).iterator();
            while (i.hasNext()) {
                currentStep = (StepInfo)i.next();
                if (Logger.isDebugEnabled("executor.eventhandlers")) {
                    Logger.debug("Examining currentStep: " + currentStep, "executor.eventhandlers");
                }
                StepInfo parent = null;
                if (null != currentStep.getParentStepID()) {
                    parent = (StepInfo)stepsByID.get(currentStep.getParentStepID());
                }
                if (!this.shouldSkipStep(currentStep, parent) && (failedStatus != StepStatus.PREFLIGHT_ERROR || !currentStep.getRunLevel().equals(RunLevel.ACTUAL))) continue;
                if (currentStep.getMappable()) {
                    if (Logger.isDebugEnabled("executor.eventhandlers")) {
                        Logger.debug("Setting failed marker for " + currentStep.getStepMap() + "|" + currentStep.getTargetID() + "|" + currentStep.getRunLevel(), "executor.eventhandlers");
                    }
                    inTaskInfo.setStepFailed(currentStep.getStepMap(), currentStep.getTargetID(), currentStep.getRunLevel());
                }
                if (!currentStep.equals(principalStep) && !currentStep.getStepStatus().failed()) {
                    if (Logger.isDebugEnabled("executor.eventhandlers")) {
                        Logger.debug("Setting stepstatus to " + failedStatus + " and skipped to true", "executor.eventhandlers");
                    }
                    currentStep.setStepStatus(failedStatus);
                    currentStep.setSkipped(true);
                    this.addObjectToSave(currentStep);
                } else {
                    this.updatePrincipalStep(currentStep, event);
                    this.addObjectToSave(currentStep);
                }
                if (currentStep.getParentStepID() != null && currentStep.getParentStepID().equals(principalStep.getStepID())) continue;
                if (Logger.isDebugEnabled("executor.eventhandlers")) {
                    Logger.debug("Setting current step error count to " + inTaskInfo.getFailedTargetCountForStep(currentStep.getStepMap(), currentStep.getRunLevel()), "executor.eventhandlers");
                }
                currentStep.setHostsFailed(1);
                this.addObjectToSave(currentStep);
            }
            inTaskInfo.setErrorCount(inTaskInfo.getErrorCount() + 1);
            inTaskInfo.setPendingStepStatus(principalStep, StepStatus.INCOMPLETE_ERROR);
            if (!event.getHandled()) {
                inTaskInfo.setPendingTaskStatus(TaskStatus.INCOMPLETE_ERROR);
            }
        } else {
            principalStep.retrieve();
            this.updatePrincipalStep(principalStep, event);
            this.addObjectToSave(principalStep);
            inTaskInfo.setWarningCount(inTaskInfo.getWarningCount() + 1);
            inTaskInfo.setPendingStepStatus(principalStep, StepStatus.COMPLETE_WARNING);
            if (!event.getHandled()) {
                inTaskInfo.setPendingTaskStatus(TaskStatus.COMPLETE_WARNINGS);
            }
        }
    }

    protected void updatePrincipalStep(StepInfo inStep, ROXStepFailedEvent inEvent) throws CommandException {
        inStep.setExceptionDescription(inEvent.getExceptionDescription());
        inStep.setSeverity(inEvent.getSeverity());
        inStep.setHandled(inEvent.getHandled());
    }

    protected static String getRegisterClassName() {
        return ROXStepFailedEvent.class.getName();
    }
}

