/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.executor.eventhandlers;

import com.raplix.rolloutexpress.event.ROXEvent;
import com.raplix.rolloutexpress.event.ROXStepCompleteEvent;
import com.raplix.rolloutexpress.executor.StepInfo;
import com.raplix.rolloutexpress.executor.StepStatus;
import com.raplix.rolloutexpress.executor.TaskInfo;
import com.raplix.rolloutexpress.executor.eventhandlers.StepEventHandler;
import com.raplix.rolloutexpress.net.rpc.CommandException;
import com.raplix.util.logger.Logger;

public class StepCompleteEventHandler
extends StepEventHandler {
    protected void handleEvent(ROXEvent inEvent, TaskInfo inTaskInfo) throws CommandException {
        StepStatus status;
        ROXStepCompleteEvent event = (ROXStepCompleteEvent)inEvent;
        StepInfo principalStep = event.getStepInfo();
        if (Logger.isDebugEnabled("executor.eventhandlers")) {
            Logger.debug("In StepCompleteEventHandler, received a stepcompleted for " + principalStep, "executor.eventhandlers");
        }
        if ((status = inTaskInfo.getPendingStepStatus(principalStep)) == null) {
            status = StepStatus.COMPLETE;
        }
        principalStep.retrieve();
        principalStep.setStepStatus(status);
        principalStep.setCompleteDate(event.getDate());
        if (status.succeeded()) {
            principalStep.setHostsCompleted(1);
        }
        this.addObjectToSave(principalStep);
    }
}

