/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.executor.eventhandlers;

import com.raplix.rolloutexpress.event.ROXEvent;
import com.raplix.rolloutexpress.event.ROXStepAbortEvent;
import com.raplix.rolloutexpress.event.ROXStepCompleteEvent;
import com.raplix.rolloutexpress.event.ROXStepStartEvent;
import com.raplix.rolloutexpress.event.ROXTaskAbortEvent;
import com.raplix.rolloutexpress.event.ROXTaskAbortRequestedEvent;
import com.raplix.rolloutexpress.event.ROXTaskTimeoutEvent;
import com.raplix.rolloutexpress.executor.PlanExecutorMessages;
import com.raplix.rolloutexpress.executor.TaskInfo;
import com.raplix.rolloutexpress.executor.eventhandlers.PreflightCompleteEventHandler;
import com.raplix.rolloutexpress.executor.eventhandlers.StepAbortEventHandler;
import com.raplix.rolloutexpress.executor.eventhandlers.StepCompleteEventHandler;
import com.raplix.rolloutexpress.executor.eventhandlers.StepFailedEventHandler;
import com.raplix.rolloutexpress.executor.eventhandlers.StepStartEventHandler;
import com.raplix.rolloutexpress.executor.eventhandlers.TaskAbortEventHandler;
import com.raplix.rolloutexpress.executor.eventhandlers.TaskAbortRequestedEventHandler;
import com.raplix.rolloutexpress.executor.eventhandlers.TaskCompleteEventHandler;
import com.raplix.rolloutexpress.executor.eventhandlers.TaskStartEventHandler;
import com.raplix.rolloutexpress.executor.eventhandlers.TaskTimeoutEventHandler;
import com.raplix.rolloutexpress.message.ROXMessageManager;
import com.raplix.rolloutexpress.net.rpc.CommandException;
import com.raplix.rolloutexpress.persist.PersistenceManager;
import com.raplix.rolloutexpress.persist.PersistentObject;
import com.raplix.rolloutexpress.persist.Transaction;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.persist.map.exception.ClassMapException;
import com.raplix.rolloutexpress.persist.query.exception.QueryException;
import com.raplix.util.logger.Logger;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;

public abstract class EventHandlerBase
implements PlanExecutorMessages {
    private Hashtable mObjectsToSave = new Hashtable();
    private PersistenceManager mPM;
    private static Hashtable sHandlers = new Hashtable();
    private static Boolean sHandlersInitialized = new Boolean(false);
    public static final String LOGGER_EVENTHANDLER = "executor.eventhandlers";

    protected void addObjectToSave(PersistentObject inPO) {
        this.mObjectsToSave.put(inPO.getObjectID(), inPO);
    }

    private void setPersistenceManager(PersistenceManager inPM) {
        this.mPM = inPM;
    }

    protected PersistenceManager getPersistenceManager() {
        return this.mPM;
    }

    protected abstract void handleEvent(ROXEvent var1, TaskInfo var2) throws CommandException;

    protected static String getRegisterClassName() {
        return Object.class.getName();
    }

    private static void initializeHandlers() {
        sHandlers.put(TaskStartEventHandler.getRegisterClassName(), new TaskStartEventHandler());
        sHandlers.put(TaskCompleteEventHandler.getRegisterClassName(), new TaskCompleteEventHandler());
        sHandlers.put(PreflightCompleteEventHandler.getRegisterClassName(), new PreflightCompleteEventHandler());
        sHandlers.put(ROXTaskAbortRequestedEvent.class.getName(), new TaskAbortRequestedEventHandler());
        sHandlers.put(ROXTaskAbortEvent.class.getName(), new TaskAbortEventHandler());
        sHandlers.put(ROXTaskTimeoutEvent.class.getName(), new TaskTimeoutEventHandler());
        sHandlers.put(ROXStepStartEvent.class.getName(), new StepStartEventHandler());
        sHandlers.put(ROXStepCompleteEvent.class.getName(), new StepCompleteEventHandler());
        sHandlers.put(ROXStepAbortEvent.class.getName(), new StepAbortEventHandler());
        sHandlers.put(StepFailedEventHandler.getRegisterClassName(), new StepFailedEventHandler());
        sHandlersInitialized = new Boolean(true);
    }

    protected boolean beforeHandle(TaskInfo inTaskInfo, ROXEvent inEvent) throws CommandException {
        return true;
    }

    protected void afterSave(TaskInfo inTaskInfo, ROXEvent inEvent, Collection inObjectsSaved) throws CommandException {
    }

    public static synchronized void processEvent(TaskInfo inTaskInfo, ROXEvent inEvent, PersistenceManager inPM) {
        block5: {
            EventHandlerBase handler;
            if (!sHandlersInitialized.booleanValue()) {
                EventHandlerBase.initializeHandlers();
            }
            if (null == (handler = (EventHandlerBase)sHandlers.get(inEvent.getClass().getName()))) {
                return;
            }
            try {
                handler.mObjectsToSave.clear();
                if (handler.beforeHandle(inTaskInfo, inEvent)) {
                    handler.setPersistenceManager(inPM);
                    handler.handleEvent(inEvent, inTaskInfo);
                    handler.saveObjects();
                    handler.afterSave(inTaskInfo, inEvent, handler.mObjectsToSave.values());
                }
            }
            catch (CommandException ce) {
                if (!Logger.isErrorEnabled(EventHandlerBase.class)) break block5;
                Logger.error(ROXMessageManager.messageAsString("pe.EVENTHANDLER_PROBLEM", new Object[]{inEvent.toString(), inTaskInfo.toString()}), ce, EventHandlerBase.class);
            }
        }
    }

    protected void saveObjects() throws CommandException {
        this.getPersistenceManager().getTransactionManager().transact(new EventHandlerTransaction(this.mObjectsToSave.values()));
    }

    private static final class EventHandlerTransaction
    implements Transaction {
        private Collection mObjects;

        private EventHandlerTransaction(Collection inObjects) {
            this.mObjects = inObjects;
        }

        public Object execute() throws ClassMapException, SQLException, PersistenceManagerException, QueryException {
            if (Logger.isDebugEnabled(EventHandlerBase.LOGGER_EVENTHANDLER)) {
                Logger.debug("In EventHandlerBase, saving objects:\n" + this.mObjects, EventHandlerBase.LOGGER_EVENTHANDLER);
            }
            Iterator i = this.mObjects.iterator();
            while (i.hasNext()) {
                PersistentObject po = (PersistentObject)i.next();
                if (Logger.isDebugEnabled(EventHandlerBase.LOGGER_EVENTHANDLER)) {
                    Logger.debug("saving object " + po, EventHandlerBase.LOGGER_EVENTHANDLER);
                }
                po.save();
            }
            return null;
        }
    }
}

