/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.executor;

import com.raplix.rolloutexpress.event.ROXEvent;
import com.raplix.rolloutexpress.event.ROXEventFactory;
import com.raplix.rolloutexpress.event.ROXEventFactoryTable;
import com.raplix.rolloutexpress.event.query.bean.ExceptionInterface;
import com.raplix.rolloutexpress.event.query.bean.TaskBean;
import com.raplix.rolloutexpress.event.query.bean.TaskInterface;
import com.raplix.rolloutexpress.executor.RunLevel;
import com.raplix.rolloutexpress.executor.TaskID;
import com.raplix.rolloutexpress.executor.TaskInfo;
import com.raplix.rolloutexpress.executor.TaskInfoTable;
import com.raplix.rolloutexpress.executor.TaskStatus;
import com.raplix.rolloutexpress.executor.target.TargetID;
import com.raplix.rolloutexpress.net.rpc.RPCSerializable;
import com.raplix.rolloutexpress.persist.PersistentBean;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.persist.query.ResultProcessor;
import com.raplix.rolloutexpress.persist.query.builder.AndExp;
import com.raplix.rolloutexpress.persist.query.builder.ColumnNode;
import com.raplix.rolloutexpress.persist.query.builder.ConditionalExpression;
import com.raplix.rolloutexpress.persist.query.builder.DoubleColumn;
import com.raplix.rolloutexpress.persist.query.builder.IntColumn;
import com.raplix.rolloutexpress.persist.query.builder.OrExp;
import com.raplix.rolloutexpress.persist.query.builder.QueryBuilder;
import com.raplix.rolloutexpress.persist.query.builder.SelectList;
import com.raplix.rolloutexpress.persist.query.builder.TableList;
import com.raplix.rolloutexpress.persist.query.builder.WhereClause;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;

public class TaskStatusBean
implements RPCSerializable,
TaskInterface {
    private TaskStatus mTaskStatus;
    private int mErrorCount;
    private int mWarningCount;
    private double mProgress;
    private boolean mPreflightFailed;
    private boolean mTaskAbortRequested;
    private boolean mTaskAborted;
    private boolean mTaskFailed;
    private boolean mPreflightOnly;
    private TaskBean mTask;
    private Vector mSteps;
    static /* synthetic */ Class class$com$raplix$rolloutexpress$event$ROXStepFailedEvent;
    static /* synthetic */ Class class$com$raplix$rolloutexpress$event$ROXTaskFailedEvent;
    static /* synthetic */ Class class$com$raplix$rolloutexpress$event$ROXTaskProgressEvent;

    private TaskStatusBean() {
    }

    public TaskStatusBean(TaskInfo inTaskInfo) {
        this.mTask = new TaskBean(inTaskInfo);
        this.mTaskStatus = inTaskInfo.getTaskStatus();
    }

    public void setTaskStatus(TaskStatus inTaskStatus) {
        this.mTaskStatus = inTaskStatus;
    }

    public TaskStatus getTaskStatus() {
        return this.mTaskStatus;
    }

    public void setErrorCount(int inErrorCount) {
        this.mErrorCount = inErrorCount;
    }

    public int getErrorCount() {
        return this.mErrorCount;
    }

    public void setWarningCount(int inWarningCount) {
        this.mWarningCount = inWarningCount;
    }

    public int getWarningCount() {
        return this.mWarningCount;
    }

    public Date getStartDate() {
        return this.mTask.getTaskInfo().getTaskStart();
    }

    public Date getCompleteDate() {
        return this.mTask.getTaskInfo().getTaskComplete();
    }

    public void setPreflightFailed(boolean inPreflightFailed) {
        this.mPreflightFailed = inPreflightFailed;
    }

    public boolean getPreflightFailed() {
        return this.mPreflightFailed;
    }

    public void setTaskAbortRequested(boolean inTaskAbortRequested) {
        this.mTaskAbortRequested = inTaskAbortRequested;
    }

    public boolean getTaskAbortRequested() {
        return this.mTaskAbortRequested;
    }

    public boolean getTaskAborted() {
        if (null == this.mTaskStatus) {
            return false;
        }
        return this.mTaskStatus.equals(TaskStatus.INCOMPLETE_ABORT);
    }

    public boolean getTaskFailed() {
        if (null == this.mTaskStatus) {
            return false;
        }
        return this.mTaskStatus.equals(TaskStatus.INCOMPLETE_ERROR);
    }

    public void setPreflightOnly(boolean inPreflightOnly) {
        this.mPreflightOnly = inPreflightOnly;
    }

    public boolean getPreflightOnly() {
        return this.mPreflightOnly;
    }

    public TaskID getTaskID() {
        return this.mTask.getTaskID();
    }

    public void setTaskID(TaskID inTaskID) {
        this.mTask.setTaskID(inTaskID);
    }

    public TaskInfo getTaskInfo() {
        return this.mTask.getTaskInfo();
    }

    public boolean getIsPreflight() {
        return this.mTask.getIsPreflight();
    }

    public void setIsPreflight(boolean isPreflight) {
        this.mTask.setIsPreflight(isPreflight);
    }

    public boolean preflightInUse() {
        return this.mTask.preflightInUse();
    }

    public double getProgress() {
        return this.mProgress;
    }

    protected void setProgress(double inProgress) {
        this.mProgress = inProgress;
    }

    public Collection getSteps() {
        return this.mSteps;
    }

    public void getErrorsAndWarnings(RunLevel inRunLevel, Vector outWarnings, Vector outErrors) throws PersistenceManagerException {
        this.getErrorsAndWarnings(null, inRunLevel, outWarnings, outErrors);
    }

    public void getErrorsAndWarnings(TargetID inTargetID, RunLevel inRunLevel, Vector outWarnings, Vector outErrors) throws PersistenceManagerException {
        TaskStatusBean.getErrorsAndWarnings(this.getTaskID(), inTargetID, inRunLevel, outWarnings, outErrors);
    }

    public static void getErrorsAndWarnings(TaskID inTaskID, TargetID inTargetID, RunLevel inRunLevel, Vector outWarnings, Vector outErrors) throws PersistenceManagerException {
        ExceptionInterface event;
        outWarnings.clear();
        outErrors.clear();
        ErrorWarningFinder finder = new ErrorWarningFinder(inTaskID, inTargetID, inRunLevel);
        HashSet<String> messages = new HashSet<String>();
        Vector rawMessages = finder.getWarnings();
        Iterator i = rawMessages.iterator();
        while (i.hasNext()) {
            event = (ExceptionInterface)i.next();
            if (!messages.add(event.getExceptionDescription())) continue;
            outWarnings.add(event);
        }
        messages.clear();
        rawMessages = finder.getErrors();
        i = rawMessages.iterator();
        while (i.hasNext()) {
            event = (ExceptionInterface)i.next();
            if (!messages.add(event.getExceptionDescription())) continue;
            outErrors.add(event);
        }
    }

    public static TaskStatusBean taskStatusQuery(TaskID inTaskID) throws PersistenceManagerException {
        if (null == inTaskID) {
            throw new NullPointerException();
        }
        TaskStatusRetriever statusRetriever = new TaskStatusRetriever(inTaskID);
        return statusRetriever.getResult();
    }

    private static final class TaskStatusBeanResultSetProcessor
    extends ResultProcessor {
        TaskInfoTable mTaskTable;

        public TaskStatusBeanResultSetProcessor(TaskInfoTable inTaskInfoTable) {
            this.mTaskTable = inTaskInfoTable;
        }

        public Object processRow(ResultSet inResultSet) throws PersistenceManagerException, SQLException {
            TaskInfo theTaskInfo = this.mTaskTable.retrieveObject(inResultSet);
            TaskStatusBean bean = new TaskStatusBean(theTaskInfo);
            bean.setTaskStatus(theTaskInfo.getTaskStatus());
            bean.setPreflightFailed(theTaskInfo.getPreflightFailed());
            bean.setTaskAbortRequested(theTaskInfo.getAbortRequested());
            bean.setPreflightOnly(theTaskInfo.getRunLevel().equals(RunLevel.PREFLIGHT));
            double progress = DoubleColumn.getValue(inResultSet, inResultSet.getMetaData().getColumnCount() - 2);
            bean.setProgress(progress);
            int errorCount = IntColumn.getValue(inResultSet, inResultSet.getMetaData().getColumnCount() - 1);
            bean.setErrorCount(errorCount);
            int warningCount = IntColumn.getValue(inResultSet, inResultSet.getMetaData().getColumnCount());
            bean.setWarningCount(warningCount);
            return bean;
        }

        public Vector getResults() {
            return this.mResults;
        }
    }

    private static class TaskStatusRetriever
    extends QueryBuilder {
        TaskStatusBean mResult = null;

        protected TaskStatusRetriever(TaskID inTaskID) throws PersistenceManagerException {
            this.mResult = this.getTaskInfo(inTaskID);
        }

        protected TaskStatusBean getTaskInfo(TaskID inTaskID) throws PersistenceManagerException {
            TaskInfoTable infoTable = new TaskInfoTable("ti");
            ROXEventFactoryTable event3 = new ROXEventFactoryTable("e3");
            ROXEventFactoryTable event4 = new ROXEventFactoryTable("e4");
            ROXEventFactoryTable event5 = new ROXEventFactoryTable("e5");
            SelectList selectList = TaskStatusRetriever.sList((SelectList)infoTable.allColumns(), TaskStatusRetriever.sList(TaskStatusRetriever.scalar(TaskStatusRetriever.select(TaskStatusRetriever.sList(event3.PercentDone), TaskStatusRetriever.tList(event3), TaskStatusRetriever.where(TaskStatusRetriever.and(TaskStatusRetriever.equals((ColumnNode)event3.TaskID, infoTable.ID), TaskStatusRetriever.equals(event3.EventType, (class$com$raplix$rolloutexpress$event$ROXTaskProgressEvent == null ? (class$com$raplix$rolloutexpress$event$ROXTaskProgressEvent = TaskStatusBean.class$("com.raplix.rolloutexpress.event.ROXTaskProgressEvent")) : class$com$raplix$rolloutexpress$event$ROXTaskProgressEvent).getName()))))), TaskStatusRetriever.scalar(TaskStatusRetriever.select(TaskStatusRetriever.sList(TaskStatusRetriever.count()), TaskStatusRetriever.tList(event4), TaskStatusRetriever.where(TaskStatusRetriever.and(TaskStatusRetriever.equals((ColumnNode)event4.TaskID, infoTable.ID), TaskStatusRetriever.and(TaskStatusRetriever.and(TaskStatusRetriever.equals(event4.SeverityCode, 4), TaskStatusRetriever.equals(event4.Handled, false)), TaskStatusRetriever.or(TaskStatusRetriever.equals(event4.EventType, (class$com$raplix$rolloutexpress$event$ROXStepFailedEvent == null ? (class$com$raplix$rolloutexpress$event$ROXStepFailedEvent = TaskStatusBean.class$("com.raplix.rolloutexpress.event.ROXStepFailedEvent")) : class$com$raplix$rolloutexpress$event$ROXStepFailedEvent).getName()), TaskStatusRetriever.equals(event4.EventType, (class$com$raplix$rolloutexpress$event$ROXTaskFailedEvent == null ? (class$com$raplix$rolloutexpress$event$ROXTaskFailedEvent = TaskStatusBean.class$("com.raplix.rolloutexpress.event.ROXTaskFailedEvent")) : class$com$raplix$rolloutexpress$event$ROXTaskFailedEvent).getName()))))))), TaskStatusRetriever.scalar(TaskStatusRetriever.select(TaskStatusRetriever.sList(TaskStatusRetriever.count()), TaskStatusRetriever.tList(event5), TaskStatusRetriever.where(TaskStatusRetriever.and(TaskStatusRetriever.equals((ColumnNode)event5.TaskID, infoTable.ID), TaskStatusRetriever.and(TaskStatusRetriever.and(TaskStatusRetriever.equals(event5.SeverityCode, 3), TaskStatusRetriever.equals(event5.Handled, false)), TaskStatusRetriever.or(TaskStatusRetriever.equals(event5.EventType, (class$com$raplix$rolloutexpress$event$ROXStepFailedEvent == null ? (class$com$raplix$rolloutexpress$event$ROXStepFailedEvent = TaskStatusBean.class$("com.raplix.rolloutexpress.event.ROXStepFailedEvent")) : class$com$raplix$rolloutexpress$event$ROXStepFailedEvent).getName()), TaskStatusRetriever.equals(event5.EventType, (class$com$raplix$rolloutexpress$event$ROXTaskFailedEvent == null ? (class$com$raplix$rolloutexpress$event$ROXTaskFailedEvent = TaskStatusBean.class$("com.raplix.rolloutexpress.event.ROXTaskFailedEvent")) : class$com$raplix$rolloutexpress$event$ROXTaskFailedEvent).getName())))))))));
            TableList tableList = TaskStatusRetriever.tList(infoTable);
            WhereClause where = TaskStatusRetriever.where(TaskStatusRetriever.equals(infoTable.ID, inTaskID));
            TaskStatusBeanResultSetProcessor statusProcessor = new TaskStatusBeanResultSetProcessor(infoTable);
            TaskStatusRetriever.execute(TaskStatusRetriever.select(selectList, tableList, where), statusProcessor);
            Vector results = statusProcessor.getResults();
            if (results.isEmpty()) {
                return null;
            }
            return (TaskStatusBean)results.get(0);
        }

        protected TaskStatusBean getResult() {
            return this.mResult;
        }
    }

    private static class ErrorWarningFinder
    extends QueryBuilder {
        Vector mErrors = new Vector();
        Vector mWarnings = new Vector();

        protected ErrorWarningFinder(TaskID inTaskID, TargetID inTargetID, RunLevel inRunLevel) throws PersistenceManagerException {
            this.executeQuery(inTaskID, inTargetID, inRunLevel);
        }

        protected void executeQuery(TaskID inTaskID, TargetID inTargetID, RunLevel inRunLevel) throws PersistenceManagerException {
            if (null == inTaskID) {
                throw new NullPointerException();
            }
            this.mErrors.clear();
            this.mWarnings.clear();
            ROXEventFactoryTable events = ROXEventFactoryTable.DEFAULT;
            AndExp whereClause = ErrorWarningFinder.and();
            OrExp eventType = ErrorWarningFinder.or(ErrorWarningFinder.and(ErrorWarningFinder.equals(events.EventType, (class$com$raplix$rolloutexpress$event$ROXStepFailedEvent == null ? (class$com$raplix$rolloutexpress$event$ROXStepFailedEvent = TaskStatusBean.class$("com.raplix.rolloutexpress.event.ROXStepFailedEvent")) : class$com$raplix$rolloutexpress$event$ROXStepFailedEvent).getName()), ErrorWarningFinder.equals(events.Handled, false)), ErrorWarningFinder.equals(events.EventType, (class$com$raplix$rolloutexpress$event$ROXTaskFailedEvent == null ? (class$com$raplix$rolloutexpress$event$ROXTaskFailedEvent = TaskStatusBean.class$("com.raplix.rolloutexpress.event.ROXTaskFailedEvent")) : class$com$raplix$rolloutexpress$event$ROXTaskFailedEvent).getName()));
            whereClause.add(ErrorWarningFinder.equals(events.TaskID, inTaskID.toString()));
            whereClause.add((ConditionalExpression)eventType);
            if (null != inTargetID) {
                whereClause.add(ErrorWarningFinder.equals(events.TargetID, inTargetID.toString()));
            }
            if (null != inRunLevel) {
                whereClause.add(ErrorWarningFinder.equals(events.IsPreflight, inRunLevel.equals(RunLevel.PREFLIGHT)));
            }
            PersistentBean[] results = ErrorWarningFinder.executeMultiResult(ErrorWarningFinder.select((SelectList)events.allColumns(), ErrorWarningFinder.tList(events), ErrorWarningFinder.where(whereClause), ErrorWarningFinder.oList(ErrorWarningFinder.orderByDesc(events.Date))), events);
            for (int i = 0; i < results.length; ++i) {
                ROXEventFactory eventFactory = (ROXEventFactory)results[i];
                ROXEvent event = eventFactory.instantiate();
                if (event.getSeverity() == 3) {
                    this.mWarnings.add(event);
                }
                if (event.getSeverity() != 4) continue;
                this.mErrors.add(event);
            }
        }

        protected Vector getErrors() {
            return this.mErrors;
        }

        protected Vector getWarnings() {
            return this.mWarnings;
        }
    }
}

