/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.executor;

import com.raplix.rolloutexpress.net.rpc.RPCSerializable;
import com.raplix.util.enum.Enum;
import com.raplix.util.enum.EnumFactory;
import com.raplix.util.enum.NoSuchEnumException;

public class TaskStatus
extends Enum
implements RPCSerializable {
    public static final Factory FACTORY = new Factory();
    public static final TaskStatus NOT_STARTED = new TaskStatus("Not Started");
    public static final TaskStatus PREFLIGHT_RUNNING = new TaskStatus("Preflight Running");
    public static final TaskStatus DEPLOYMENT_RUNNING = new TaskStatus("Deployment Running");
    public static final TaskStatus COMPLETE = new TaskStatus("Complete");
    public static final TaskStatus COMPLETE_WARNINGS = new TaskStatus("Complete With Warnings");
    public static final TaskStatus INCOMPLETE_ABORT = new TaskStatus("Incomplete - Aborted");
    public static final TaskStatus INCOMPLETE_TIMEOUT = new TaskStatus("Incomplete - Timed Out");
    public static final TaskStatus INCOMPLETE_ERROR = new TaskStatus("Incomplete - Error");

    private TaskStatus(String stringValue) {
        super(stringValue, FACTORY);
    }

    private TaskStatus() {
    }

    public boolean notRunning() {
        return !this.running();
    }

    public boolean running() {
        return this.equals(NOT_STARTED) || this.equals(PREFLIGHT_RUNNING) || this.equals(DEPLOYMENT_RUNNING);
    }

    public boolean succeeded() {
        return !this.failed();
    }

    public boolean failed() {
        return this.equals(INCOMPLETE_ERROR) || this.equals(INCOMPLETE_TIMEOUT) || this.equals(INCOMPLETE_ABORT);
    }

    public static TaskStatus chooseStatus(TaskStatus lhs, TaskStatus rhs) {
        if (null == lhs || null == rhs) {
            throw new NullPointerException();
        }
        if (lhs.equals(INCOMPLETE_ERROR) || rhs.equals(INCOMPLETE_ERROR)) {
            return INCOMPLETE_ERROR;
        }
        if (lhs.equals(INCOMPLETE_ABORT) || rhs.equals(INCOMPLETE_ABORT)) {
            return INCOMPLETE_ABORT;
        }
        if (lhs.equals(INCOMPLETE_TIMEOUT) || rhs.equals(INCOMPLETE_TIMEOUT)) {
            return INCOMPLETE_TIMEOUT;
        }
        if (lhs.equals(COMPLETE_WARNINGS) || rhs.equals(COMPLETE_WARNINGS)) {
            return COMPLETE_WARNINGS;
        }
        if (lhs.equals(COMPLETE) || rhs.equals(COMPLETE)) {
            return COMPLETE;
        }
        if (lhs.equals(DEPLOYMENT_RUNNING) || rhs.equals(DEPLOYMENT_RUNNING)) {
            return DEPLOYMENT_RUNNING;
        }
        if (lhs.equals(PREFLIGHT_RUNNING) || rhs.equals(PREFLIGHT_RUNNING)) {
            return PREFLIGHT_RUNNING;
        }
        return NOT_STARTED;
    }

    public static class Factory
    extends EnumFactory {
        private static final TaskStatus[] EMPTY_ARR = new TaskStatus[0];

        private Factory() {
            super(8);
        }

        public TaskStatus get(String value) throws NoSuchEnumException {
            return (TaskStatus)this.getEnum(value);
        }

        public TaskStatus get(int value) throws NoSuchEnumException {
            return (TaskStatus)this.getEnum(value);
        }

        public TaskStatus[] getAll() {
            return (TaskStatus[])this.getAllEnums(EMPTY_ARR);
        }
    }
}

