/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.executor;

import com.raplix.rolloutexpress.Application;
import com.raplix.rolloutexpress.ConfigurationException;
import com.raplix.rolloutexpress.UnsupportedSubsystemException;
import com.raplix.rolloutexpress.config.VariableSettingsHolder;
import com.raplix.rolloutexpress.event.TargetStatus;
import com.raplix.rolloutexpress.event.TargetStatusID;
import com.raplix.rolloutexpress.event.TargetStatusTable;
import com.raplix.rolloutexpress.event.query.MultiTargetStatusQuery;
import com.raplix.rolloutexpress.executor.CompiledPlan;
import com.raplix.rolloutexpress.executor.ComponentsInstallDataList;
import com.raplix.rolloutexpress.executor.HostData;
import com.raplix.rolloutexpress.executor.HostsUnpreparedException;
import com.raplix.rolloutexpress.executor.MultiStepStatusQuery;
import com.raplix.rolloutexpress.executor.PETransaction;
import com.raplix.rolloutexpress.executor.PlanExecutionException;
import com.raplix.rolloutexpress.executor.PlanExecutorMessages;
import com.raplix.rolloutexpress.executor.PlanPreprocessor;
import com.raplix.rolloutexpress.executor.PlanSubsystem;
import com.raplix.rolloutexpress.executor.RunLevel;
import com.raplix.rolloutexpress.executor.StepCreationTraverser;
import com.raplix.rolloutexpress.executor.StepInfo;
import com.raplix.rolloutexpress.executor.StepStatus;
import com.raplix.rolloutexpress.executor.StepStatusBean;
import com.raplix.rolloutexpress.executor.SubplanInfo;
import com.raplix.rolloutexpress.executor.TaskDescriptor;
import com.raplix.rolloutexpress.executor.TaskID;
import com.raplix.rolloutexpress.executor.TaskInfoTable;
import com.raplix.rolloutexpress.executor.TaskStatus;
import com.raplix.rolloutexpress.executor.query.MultiSubplanInfoQuery;
import com.raplix.rolloutexpress.executor.target.HostResolver;
import com.raplix.rolloutexpress.executor.target.Target;
import com.raplix.rolloutexpress.executor.target.TargetID;
import com.raplix.rolloutexpress.executor.virtual.VirtualAgentManager;
import com.raplix.rolloutexpress.net.rpc.CommandException;
import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.net.rpc.RPCSerializable;
import com.raplix.rolloutexpress.persist.PersistentObject;
import com.raplix.rolloutexpress.persist.ReEntrantTransaction;
import com.raplix.rolloutexpress.persist.UsingObject;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.persist.query.builder.ColumnNode;
import com.raplix.rolloutexpress.persist.query.builder.IDColumn;
import com.raplix.rolloutexpress.persist.query.builder.QueryBuilder;
import com.raplix.rolloutexpress.persist.query.builder.Select;
import com.raplix.rolloutexpress.persist.query.builder.WhereClause;
import com.raplix.rolloutexpress.systemmodel.hostdbx.Host;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostID;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostIDSet;
import com.raplix.rolloutexpress.systemmodel.installdb.InMemoryInstallDBContext;
import com.raplix.rolloutexpress.systemmodel.installdb.InstallDBContext;
import com.raplix.rolloutexpress.systemmodel.installdb.PersistentInstallDBContext;
import com.raplix.rolloutexpress.systemmodel.plandb.ExecNativeStep;
import com.raplix.rolloutexpress.systemmodel.plandb.ExecutionPlanID;
import com.raplix.rolloutexpress.systemmodel.plandb.SummaryExecutionPlan;
import com.raplix.rolloutexpress.systemmodel.userdb.JobInfo;
import com.raplix.rolloutexpress.systemmodel.userdb.UserID;
import com.raplix.util.Util;
import com.raplix.util.logger.Logger;
import com.raplix.util.threads.ResourceID;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Vector;

public class TaskInfo
extends PersistentObject
implements RPCSerializable,
PlanExecutorMessages,
UsingObject,
JobInfo {
    private CompiledPlan mPlan;
    private RunLevel mRunLevel;
    private UserID mRoxUser;
    private int mPlanTimeoutSecs;
    private int mNativeCallTimeoutSecs;
    private String mDefaultUserToRunAs;
    private ExecutionPlanID mPlanID;
    private Date mTaskStart;
    private Date mTaskComplete;
    private TaskStatus mTaskStatus = TaskStatus.NOT_STARTED;
    private TaskStatus mPendingTaskStatus = TaskStatus.COMPLETE;
    private boolean mPreflightFailed;
    private boolean mAbortRequested;
    private int mErrorCount;
    private int mWarningCount;
    private int mPlanThrottle;
    private boolean mDetailedPreflight;
    private transient HostResolver mHostResolver;
    private transient boolean mTaskWasAborted;
    private transient Hashtable mHostDataTable;
    private transient InstallDBContext mInstallDBContext;
    private transient Hashtable mHostStepCounterTableActual = new Hashtable();
    private transient Hashtable mHostStepCounterTablePreflight = new Hashtable();
    private transient VirtualAgentManager mVAMgr = new VirtualAgentManager();
    private Hashtable mActualSteps;
    private Hashtable mPreflightSteps;
    private transient VariableSettingsHolder mPlanParamValues;
    private transient PlanSubsystem mPlanSubsystem;
    private transient boolean mfNonPlan = false;
    private static transient Hashtable sTasksByID = new Hashtable();
    private transient Hashtable mPendingStepStatus = new Hashtable();
    private transient Hashtable mStepFailuresByStepIDPreflight = new Hashtable();
    private transient Hashtable mStepFailuresByStepIDActual = new Hashtable();
    private transient Hashtable mInstallData = new Hashtable();
    private transient boolean mShouldVerifySystemServices;
    private transient long mStartMillis = System.currentTimeMillis();
    private transient Application mApplication;
    private transient TaskDescriptor mDescriptor;
    private transient boolean mfNoPhysicalHostLocking;
    private transient ArrayList mCleanupTasks = new ArrayList();

    TaskInfo() {
    }

    public static TaskInfo createNonPlanTaskInfo(PlanSubsystem inPS, HostResolver inResolver) throws PlanExecutionException {
        return new TaskInfo(inPS, inResolver, new PersistentInstallDBContext());
    }

    public InstallDBContext getInstallDBContext() {
        return this.mInstallDBContext;
    }

    public void setInstallDBContext(InstallDBContext context) {
        this.mInstallDBContext = context;
    }

    private TaskInfo(PlanSubsystem inPS, HostResolver inResolver, InstallDBContext inContext) throws PlanExecutionException {
        this.mHostResolver = inResolver;
        this.mHostDataTable = new Hashtable();
        this.mInstallDBContext = inContext;
        this.mPlanSubsystem = inPS;
        this.mfNonPlan = true;
        try {
            this.setNativeCallTimeoutSecs(inPS.getConfigNonPlanExecNativeTimeout());
            this.setPlanTimeoutSecs(inPS.getConfigDefaultPlanTimeout());
        }
        catch (ConfigurationException ex) {
            throw new PlanExecutionException(ex);
        }
    }

    public TaskInfo(TaskDescriptor inTaskDescriptor, Application inApplication, HostResolver inResolver) throws PlanExecutionException {
        inTaskDescriptor.validate();
        this.mDescriptor = inTaskDescriptor;
        this.mApplication = inApplication;
        this.mPlan = inTaskDescriptor.getCompiledPlan();
        this.setRunLevel(inTaskDescriptor.getRunLevel());
        this.mRoxUser = inTaskDescriptor.getRoxUser();
        this.mDefaultUserToRunAs = inTaskDescriptor.getDefaultUserToRunAs();
        this.mPlanTimeoutSecs = inTaskDescriptor.getPlanTimeoutSecs();
        this.mNativeCallTimeoutSecs = inTaskDescriptor.getNativeCallTimeoutSecs();
        this.mPlanThrottle = inTaskDescriptor.getPlanThrottle();
        this.mDetailedPreflight = inTaskDescriptor.getDetailedPreflight();
        this.mPlanParamValues = inTaskDescriptor.getPlanParameterValues();
        this.mHostResolver = inResolver;
        try {
            this.mPlanSubsystem = inApplication.getPlanSubsystem();
        }
        catch (UnsupportedSubsystemException ex) {
            throw new PlanExecutionException(ex);
        }
    }

    protected void createSteps() throws PlanExecutionException {
        StepCreationTraverser stepCreator = new StepCreationTraverser(this);
        this.mDescriptor.getCompiledPlan().traversePlan(stepCreator);
    }

    public synchronized void initialize(boolean fVerifySystemServices, boolean inRunProcessors) throws PlanExecutionException {
        if (null == this.getID()) {
            throw new NullPointerException();
        }
        TaskInfo.addTaskToCache(this);
        if (inRunProcessors && null != this.mHostResolver && null != this.mDescriptor && null != this.mApplication) {
            PlanPreprocessor preprocessor = new PlanPreprocessor(this.mHostResolver, this.mDescriptor.getSubplanPrompts(), this.mApplication, this);
            this.mDescriptor.getCompiledPlan().traversePlan(preprocessor);
            if (fVerifySystemServices) {
                this.verifySystemServices(preprocessor.getPhysicalHosts());
            }
            this.mShouldVerifySystemServices = fVerifySystemServices;
            this.createSteps();
        }
        this.mTaskWasAborted = false;
        this.mfNoPhysicalHostLocking = this.mPlanSubsystem.getConfigSkipLockingOfPhysicalHosts();
        try {
            this.initTargetStatus();
        }
        catch (PersistenceManagerException pme) {
            throw new PlanExecutionException(pme);
        }
        this.initHostData();
    }

    public void initialize(boolean fVerifySystemServices) throws PlanExecutionException {
        this.initialize(fVerifySystemServices, true);
    }

    public long getStartMillis() {
        return this.mStartMillis;
    }

    public TaskID getTaskID() {
        return (TaskID)this.getObjectID();
    }

    public TaskID getID() {
        return this.getTaskID();
    }

    public String getName() {
        try {
            SummaryExecutionPlan plan = this.getPlanID().getByIDQuery().selectSummaryView();
            return null == plan ? "" : plan.getName();
        }
        catch (CommandException ce) {
            return "";
        }
    }

    public String getDescription() {
        try {
            SummaryExecutionPlan plan = this.getPlanID().getByIDQuery().selectSummaryView();
            return null == plan ? "" : plan.getDescription();
        }
        catch (CommandException ce) {
            return "";
        }
    }

    public CompiledPlan getCompiledPlan() {
        return this.mPlan;
    }

    public RunLevel getRunLevel() {
        return this.mRunLevel;
    }

    public UserID getRoxUser() {
        return this.mRoxUser;
    }

    public UserID getTaskOwner() {
        return this.getRoxUser();
    }

    public int getPlanTimeoutSecs() {
        return this.mPlanTimeoutSecs;
    }

    public int getNativeCallTimeoutSecs() {
        return this.mNativeCallTimeoutSecs;
    }

    public int getPlanThrottle() {
        return this.mPlanThrottle;
    }

    public boolean getDetailedPreflight() {
        return this.mDetailedPreflight;
    }

    public SubplanInfo[] getSubplanInfos() throws PlanExecutionException {
        try {
            return MultiSubplanInfoQuery.byTaskID(this.getID()).select();
        }
        catch (CommandException ce) {
            throw new PlanExecutionException(ce);
        }
    }

    public ExecutionPlanID getPlanID() {
        if (this.mPlan == null || this.mPlan.getTopLevelPlan() == null) {
            return this.mPlanID;
        }
        return this.mPlan.getTopLevelPlan().getID();
    }

    public Date getTaskStart() {
        return this.mTaskStart;
    }

    public Date getTaskComplete() {
        return this.mTaskComplete;
    }

    public TargetStatus[] getAllTargetsStatus() throws PlanExecutionException {
        try {
            return MultiTargetStatusQuery.byTaskID(this.getID()).select();
        }
        catch (CommandException ce) {
            throw new PlanExecutionException(ce);
        }
    }

    public Vector getAllSuccessfulHosts() throws PlanExecutionException {
        Vector<HostID> theSuccessfulHosts = new Vector<HostID>();
        TargetStatus[] allTargetsStatus = this.getAllTargetsStatus();
        for (int i = 0; i < allTargetsStatus.length; ++i) {
            TargetStatus currStatus = allTargetsStatus[i];
            if (currStatus.getStatus() != 1) continue;
            theSuccessfulHosts.add(currStatus.getHostID());
        }
        return theSuccessfulHosts;
    }

    public int getNumberFailedHosts() throws PlanExecutionException {
        int count = 0;
        TargetStatus[] allTargetsStatus = this.getAllTargetsStatus();
        for (int i = 0; i < allTargetsStatus.length; ++i) {
            if (!allTargetsStatus[i].failed()) continue;
            ++count;
        }
        return count;
    }

    public TargetStatus getTargetStatus(TargetID inTargetID) throws PlanExecutionException {
        if (inTargetID == null) {
            return null;
        }
        try {
            return TargetStatusID.getByTaskAndTarget(this.getID(), inTargetID).select();
        }
        catch (CommandException ce) {
            throw new PlanExecutionException(ce);
        }
    }

    public void prepareForActual() {
        this.mInstallDBContext = new PersistentInstallDBContext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HostData getHostData(HostID inHostID) throws PersistenceManagerException, RPCException, PlanExecutionException {
        if (inHostID == null) {
            return null;
        }
        Hashtable hashtable = this.mHostDataTable;
        synchronized (hashtable) {
            HostData theData = (HostData)this.mHostDataTable.get(inHostID);
            if (theData == null) {
                Host theHost = this.getHostResolver().getHost(inHostID);
                if (Logger.isDebugEnabled(this)) {
                    Logger.debug("inserting a new hostData for host " + theHost.getName(), this);
                }
                theData = new HostData(theHost);
                this.mHostDataTable.put(inHostID, theData);
            }
            return theData;
        }
    }

    public boolean getTaskWasAborted() {
        return this.mTaskWasAborted;
    }

    public VirtualAgentManager getVirtualAgentManager() {
        return this.mVAMgr;
    }

    public ResourceID getHostLockMapping(Host inHost) {
        if (this.mfNonPlan) {
            return null;
        }
        return this.mPlanSubsystem.getHostLockMapping(inHost);
    }

    public boolean getIsNonPlanTaskInfo() {
        return this.mfNonPlan;
    }

    public boolean getSkipPhysicalHostLocking() {
        return this.mfNoPhysicalHostLocking;
    }

    void setCompiledPlan(CompiledPlan inPlan) {
        this.mPlan = inPlan;
    }

    public void setRunLevel(RunLevel inRunLevel) {
        this.mRunLevel = inRunLevel;
    }

    public void setRoxUser(UserID inRoxUser) {
        this.mRoxUser = inRoxUser;
    }

    public void setPlanTimeoutSecs(int inPlanTimeout) {
        this.mPlanTimeoutSecs = inPlanTimeout;
    }

    public void setNativeCallTimeoutSecs(int inNativeCallTimeout) {
        this.mNativeCallTimeoutSecs = inNativeCallTimeout;
    }

    public void setPlanThrottle(int inPlanThrottle) {
        this.mPlanThrottle = inPlanThrottle;
    }

    public void setDetailedPreflight(boolean inFastPreflight) {
        this.mDetailedPreflight = inFastPreflight;
    }

    private void setRunLevelAsString(String inRunLevel) {
        if (inRunLevel.equalsIgnoreCase("Actual")) {
            inRunLevel = "Actual";
        }
        this.mRunLevel = RunLevel.FACTORY.get(inRunLevel);
    }

    private String getRunLevelAsString() {
        if (this.mRunLevel.toString().equals("Actual")) {
            return "ACTUAL";
        }
        return this.mRunLevel.toString();
    }

    private void setTaskStatusAsString(String inTaskStatus) {
        this.mTaskStatus = TaskStatus.FACTORY.get(inTaskStatus);
    }

    private String getTaskStatusAsString() {
        return this.mTaskStatus.toString();
    }

    public void setTaskStatus(TaskStatus inTaskStatus) {
        this.mTaskStatus = inTaskStatus;
    }

    public void setPendingTaskStatus(TaskStatus inTaskStatus) {
        this.mPendingTaskStatus = TaskStatus.chooseStatus(inTaskStatus, this.mPendingTaskStatus);
    }

    public void setTaskStatusToPending() {
        this.setTaskStatus(this.getPendingTaskStatus());
    }

    public TaskStatus getPendingTaskStatus() {
        return this.mPendingTaskStatus;
    }

    public TaskStatus getTaskStatus() {
        return this.mTaskStatus;
    }

    public void setPlanID(ExecutionPlanID inPlanID) {
        this.mPlanID = inPlanID;
    }

    public void setTaskStart(Date inTaskStart) {
        this.mTaskStart = inTaskStart;
    }

    public void setTaskComplete(Date inTaskComplete) {
        this.mTaskComplete = inTaskComplete;
    }

    public synchronized void setTargetStatusKeepFailure(TargetID inTargetID, int inStatus) throws PlanExecutionException {
        if (inTargetID == null) {
            throw new IllegalArgumentException();
        }
        TargetStatus currStatus = this.getTargetStatus(inTargetID);
        if (currStatus != null && currStatus.getStatus() == 2) {
            return;
        }
        currStatus.setStatus(inStatus);
        try {
            currStatus.save();
        }
        catch (PersistenceManagerException pme) {
            throw new PlanExecutionException(pme);
        }
    }

    public synchronized void setTargetStatus(TargetID inTargetID, int inStatus, boolean inSave) throws PlanExecutionException {
        if (inTargetID == null) {
            throw new IllegalArgumentException();
        }
        TargetStatus theStatus = this.getTargetStatus(inTargetID);
        if (theStatus != null) {
            theStatus.setStatus(inStatus);
        }
        if (inSave) {
            try {
                theStatus.save();
            }
            catch (PersistenceManagerException pme) {
                throw new PlanExecutionException(pme);
            }
        }
    }

    public void setTargetStatus(TargetID inTargetID, int inStatus) throws PlanExecutionException {
        this.setTargetStatus(inTargetID, inStatus, true);
    }

    public void setTaskWasAborted() {
        this.mTaskWasAborted = true;
    }

    private void deleteAllTargetStatus() throws PersistenceManagerException {
        TargetStatusTable t = TargetStatusTable.DEFAULT;
        TargetStatusTable.execute(TargetStatusTable.delete(t, TargetStatusTable.where(TargetStatusTable.equals(t.TaskID, this.getID()))));
    }

    public void initTargetStatus(boolean inCreateNew) throws PersistenceManagerException, PlanExecutionException {
        SubplanInfo[] infos = this.getSubplanInfos();
        this.deleteAllTargetStatus();
        if (infos == null || !inCreateNew) {
            return;
        }
        int nPrompts = infos.length;
        HashMap<TargetID, Target> hostMap = new HashMap<TargetID, Target>(nPrompts);
        for (int i = 0; i < nPrompts; ++i) {
            Target[] allTargets = infos[i].getTargets();
            for (int j = 0; j < allTargets.length; ++j) {
                hostMap.put(allTargets[j].getID(), allTargets[j]);
            }
        }
        Iterator it = hostMap.values().iterator();
        while (it.hasNext()) {
            Target currTarget = (Target)it.next();
            TargetStatus status = new TargetStatus(currTarget, 3, this.getID());
            status.save();
        }
    }

    public void initTargetStatus() throws PersistenceManagerException, PlanExecutionException {
        this.initTargetStatus(true);
    }

    private void initHostData() throws PlanExecutionException {
        this.mInstallDBContext = new InMemoryInstallDBContext();
        TargetStatus[] allTargetsStatus = this.getAllTargetsStatus();
        if (allTargetsStatus == null || allTargetsStatus.length == 0) {
            return;
        }
        int nTargets = allTargetsStatus.length;
        this.mHostDataTable = new Hashtable(nTargets);
        for (int i = 0; i < nTargets; ++i) {
            Host host = null;
            try {
                host = allTargetsStatus[i].getTarget().getCurrentHost();
            }
            catch (CommandException ce) {
                throw new PlanExecutionException(ce);
            }
            this.mHostDataTable.put(host.getID(), new HostData(host));
        }
    }

    public HostIDSet getUnpreppedHostIDSet(Host[] inPhysicalHosts) throws PlanExecutionException {
        HostIDSet unPreppedHostIDSet = new HostIDSet();
        try {
            for (int i = 0; i < inPhysicalHosts.length; ++i) {
                if (inPhysicalHosts[i].isPrepared()) continue;
                unPreppedHostIDSet.add(inPhysicalHosts[i].getID());
            }
        }
        catch (PersistenceManagerException ex) {
            throw new PlanExecutionException(ex.getMessage());
        }
        catch (RPCException ex) {
            throw new PlanExecutionException(ex.getMessage());
        }
        return unPreppedHostIDSet;
    }

    private void verifySystemServices(Host[] inPhysicalHosts) throws HostsUnpreparedException, PlanExecutionException {
        HostIDSet unpreppedHostsSet = new HostIDSet();
        unpreppedHostsSet = this.getUnpreppedHostIDSet(inPhysicalHosts);
        if (unpreppedHostsSet.size() > 0) {
            throw new HostsUnpreparedException(unpreppedHostsSet);
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer(1024);
        buf.append("{ TaskID: ").append(this.getObjectID()).append(", ");
        buf.append("CompiledPlan: ").append(this.mPlan);
        buf.append("mRunLevel: ").append(this.mRunLevel).append(", ");
        buf.append("mTaskStatus: ").append(this.mTaskStatus).append(", ");
        if (this.mRoxUser != null) {
            buf.append("RoxUser: ").append(this.mRoxUser).append(", ");
        }
        buf.append("PlanTimeout: ").append(this.mPlanTimeoutSecs).append(" ");
        buf.append("ExecNativeTimeout: ").append(this.mNativeCallTimeoutSecs).append(" ");
        try {
            buf.append("TargetStatus: [").append(Util.getStringFromArray(this.getAllTargetsStatus(), ",")).append("] ");
            buf.append("SubplanInfos [").append(Util.getStringFromArray(this.getSubplanInfos(), ",")).append("] }");
        }
        catch (PlanExecutionException planExecutionException) {
            // empty catch block
        }
        if (this.mDefaultUserToRunAs != null) {
            buf.append("DefaultUserToRunAs: ").append(this.mDefaultUserToRunAs);
        }
        buf.append("TaskStart: ").append(this.mTaskStart).append(",");
        buf.append("TaskComplete: ").append(this.mTaskComplete).append(",");
        buf.append(" }");
        return buf.toString();
    }

    public String getUserToRunAs(ExecNativeStep inStep) {
        String stepUser;
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("Determining user to run as for step " + inStep, this);
        }
        String user = this.getDefaultUserToRunAs();
        String string = stepUser = inStep == null ? "" : inStep.getUserToRunAs();
        if (stepUser != null) {
            if (Logger.isDebugEnabled(this)) {
                Logger.debug("Step specifies user " + stepUser, this);
            }
            user = stepUser;
        }
        if (null == user || "" == user) {
            return null;
        }
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("Step will be run as user " + user, this);
        }
        return user;
    }

    public String getDefaultUserToRunAs() {
        return this.mDefaultUserToRunAs;
    }

    public void setDefaultUserToRunAs(String inUser) {
        this.mDefaultUserToRunAs = inUser;
    }

    public synchronized void save() throws PersistenceManagerException {
        TaskInfo.retryOnDeadlock(new ReEntrantSave(this));
    }

    public static Select getSelectForRunningPlans(IDColumn inPlanColumn) {
        RunningTaskFinder finder = new RunningTaskFinder(inPlanColumn);
        return finder.getResults();
    }

    public void setPreflightFailed(boolean inPreflightFailed) {
        this.mPreflightFailed = inPreflightFailed;
    }

    public boolean getPreflightFailed() {
        return this.mPreflightFailed;
    }

    public void setAbortRequested(boolean inAbortRequested) {
        this.mAbortRequested = inAbortRequested;
    }

    public boolean getAbortRequested() {
        return this.mAbortRequested;
    }

    public void setErrorCount(int inErrorCount) {
        this.mErrorCount = inErrorCount;
    }

    public int getErrorCount() {
        return this.mErrorCount;
    }

    public void setWarningCount(int inWarningCount) {
        this.mWarningCount = inWarningCount;
    }

    public int getWarningCount() {
        return this.mWarningCount;
    }

    public int assignHostStepMap(TargetID inTargetID, RunLevel inRunLevel) {
        Integer result;
        Hashtable<TargetID, Integer> counterTable;
        Hashtable<TargetID, Integer> hashtable = counterTable = inRunLevel.equals(RunLevel.PREFLIGHT) ? this.mHostStepCounterTablePreflight : this.mHostStepCounterTableActual;
        if (null == counterTable) {
            counterTable = new Hashtable<TargetID, Integer>();
        }
        if ((result = (Integer)counterTable.get(inTargetID)) == null) {
            result = new Integer(1);
        }
        counterTable.put(inTargetID, new Integer(result + 1));
        return result;
    }

    public boolean getShouldVerifySystemServicesInstalled() {
        return this.mShouldVerifySystemServices;
    }

    public HostResolver getHostResolver() {
        return this.mHostResolver;
    }

    VariableSettingsHolder getPlanParamValues() {
        return this.mPlanParamValues;
    }

    public synchronized void addStep(StepInfo inStep) {
        if (inStep.getTaskInfo() == null) {
            inStep.setTaskInfo(this);
        }
        if (inStep.getRunLevel().equals(RunLevel.PREFLIGHT)) {
            if (null == this.mPreflightSteps) {
                this.mPreflightSteps = new Hashtable();
            }
            this.mPreflightSteps.put(inStep.getStepID(), inStep);
        } else {
            if (null == this.mActualSteps) {
                this.mActualSteps = new Hashtable();
            }
            this.mActualSteps.put(inStep.getStepID(), inStep);
        }
    }

    public StepInfo[] getPreflightSteps() throws PersistenceManagerException, RPCException {
        return this.getSteps(RunLevel.PREFLIGHT);
    }

    public StepInfo[] getPreflightSteps(boolean inRefresh) throws PersistenceManagerException, RPCException {
        return this.getSteps(RunLevel.PREFLIGHT, inRefresh);
    }

    public StepInfo[] getActualSteps() throws PersistenceManagerException, RPCException {
        return this.getActualSteps(false);
    }

    public StepInfo[] getActualSteps(boolean inRefresh) throws PersistenceManagerException, RPCException {
        return this.getSteps(RunLevel.ACTUAL, inRefresh);
    }

    public StepInfo[] getSteps(RunLevel inRunLevel) throws PersistenceManagerException, RPCException {
        return this.getSteps(inRunLevel, false);
    }

    public synchronized StepInfo[] getSteps(RunLevel inRunLevel, boolean inRefresh) throws PersistenceManagerException, RPCException {
        if (inRefresh || this.mActualSteps == null || this.mPreflightSteps == null) {
            MultiStepStatusQuery mssq = MultiStepStatusQuery.childrenOfThisTask(this.getTaskID());
            StepStatusBean[] results = mssq.select();
            if (null == this.mPreflightSteps) {
                this.mPreflightSteps = new Hashtable();
            } else {
                this.mPreflightSteps.clear();
            }
            if (null == this.mActualSteps) {
                this.mActualSteps = new Hashtable();
            } else {
                this.mActualSteps.clear();
            }
            if (null != results) {
                for (int index = 0; index < results.length; ++index) {
                    StepInfo info = results[index].getStepInfo();
                    info.setTaskInfo(this);
                    if (info.getRunLevel().equals(RunLevel.PREFLIGHT)) {
                        this.mPreflightSteps.put(info.getStepID(), info);
                        continue;
                    }
                    this.mActualSteps.put(info.getStepID(), info);
                }
            }
        }
        Vector output = new Vector();
        output.addAll(inRunLevel.equals(RunLevel.PREFLIGHT) ? this.mPreflightSteps.values() : this.mActualSteps.values());
        Collections.sort(output, StepInfo.RUNLEVELSTEPMAPHOSTSTEPMAP_COMPARATOR);
        return output.toArray(new StepInfo[0]);
    }

    public StepInfo[] findSteps(int inStepMap) throws PlanExecutionException {
        StepInfo[] preflightSteps = this.findSteps(inStepMap, RunLevel.PREFLIGHT);
        StepInfo[] actualSteps = this.findSteps(inStepMap, RunLevel.ACTUAL);
        Vector<StepInfo> results = new Vector<StepInfo>();
        results.addAll(Arrays.asList(preflightSteps));
        results.addAll(Arrays.asList(actualSteps));
        return results.toArray(new StepInfo[0]);
    }

    public StepInfo[] findSteps(int inStepMap, RunLevel inRunLevel) throws PlanExecutionException {
        return this.findSteps(inStepMap, inRunLevel, false);
    }

    public StepInfo[] findSteps(int inStepMap, RunLevel inRunLevel, boolean inRefresh) throws PlanExecutionException {
        try {
            StepInfo[] steps = null;
            LinkedList<StepInfo> stepsToReturn = new LinkedList<StepInfo>();
            steps = inRunLevel.equals(RunLevel.PREFLIGHT) ? this.getPreflightSteps(inRefresh) : this.getActualSteps(inRefresh);
            for (int index = 0; index < steps.length; ++index) {
                StepInfo currentStep = steps[index];
                if (currentStep.getStepMap() != inStepMap) continue;
                stepsToReturn.add(currentStep);
            }
            return stepsToReturn.toArray(new StepInfo[0]);
        }
        catch (PersistenceManagerException ex) {
            throw new PlanExecutionException(ex);
        }
        catch (RPCException ex) {
            throw new PlanExecutionException(ex);
        }
    }

    public StepInfo findStep(int inStepMap, TargetID inTarget, RunLevel inRunLevel) throws PlanExecutionException {
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("Looking up step " + inStepMap + " for target " + inTarget + " with runLevel " + inRunLevel, this);
        }
        return this.findStep(inStepMap, inTarget, inRunLevel, false);
    }

    public StepInfo findStep(int inStepMap, TargetID inTarget, RunLevel inRunLevel, boolean inRefresh) throws PlanExecutionException {
        try {
            StepInfo[] steps = null;
            steps = inRunLevel.equals(RunLevel.PREFLIGHT) ? this.getPreflightSteps(inRefresh) : this.getActualSteps(inRefresh);
            for (int index = 0; index < steps.length; ++index) {
                StepInfo currentStep = steps[index];
                if (!currentStep.getTargetID().equals(inTarget) || currentStep.getStepMap() != inStepMap) continue;
                return currentStep;
            }
        }
        catch (PersistenceManagerException ex) {
            throw new PlanExecutionException(ex);
        }
        catch (RPCException ex) {
            throw new PlanExecutionException(ex);
        }
        return null;
    }

    public void setPendingStepStatus(StepInfo inStepInfo, StepStatus inStatus) {
        this.mPendingStepStatus.put(inStepInfo.getStepID(), inStatus);
    }

    public StepStatus getPendingStepStatus(StepInfo inStepInfo) {
        return (StepStatus)this.mPendingStepStatus.get(inStepInfo.getStepID());
    }

    public void setStepFailed(int inStepID, TargetID inTargetID, RunLevel inRunLevel) {
        if (Logger.isDebugEnabled("executor.eventhandlers")) {
            Logger.debug("Setting target " + inTargetID + " to failed on step " + inStepID + " at runlevel " + inRunLevel, "executor.eventhandlers");
        }
        HashSet<TargetID> targets = null;
        targets = inRunLevel.equals(RunLevel.PREFLIGHT) ? (HashSet<TargetID>)this.mStepFailuresByStepIDPreflight.get(new Integer(inStepID)) : (HashSet)this.mStepFailuresByStepIDActual.get(new Integer(inStepID));
        if (null == targets) {
            targets = new HashSet<TargetID>();
            if (inRunLevel.equals(RunLevel.PREFLIGHT)) {
                this.mStepFailuresByStepIDPreflight.put(new Integer(inStepID), targets);
            } else {
                this.mStepFailuresByStepIDActual.put(new Integer(inStepID), targets);
            }
        }
        targets.add(inTargetID);
    }

    public int getFailedTargetCountForStep(int inStepID, RunLevel inRunLevel) {
        HashSet targets = null;
        targets = inRunLevel.equals(RunLevel.PREFLIGHT) ? (HashSet)this.mStepFailuresByStepIDPreflight.get(new Integer(inStepID)) : (HashSet)this.mStepFailuresByStepIDActual.get(new Integer(inStepID));
        if (null == targets) {
            return 0;
        }
        return targets.size();
    }

    void putInstallData(SubplanInfo inSubplanInfo, ComponentsInstallDataList inInstallData) {
        this.mInstallData.put(inSubplanInfo.getID(), inInstallData);
    }

    public ComponentsInstallDataList getInstallData(SubplanInfo inSubplanInfo) {
        return (ComponentsInstallDataList)this.mInstallData.get(inSubplanInfo.getID());
    }

    static void addTaskToCache(TaskInfo inTaskInfo) {
        if (null == inTaskInfo || null == inTaskInfo.getTaskID()) {
            return;
        }
        sTasksByID.put(inTaskInfo.getTaskID(), inTaskInfo);
    }

    public static TaskInfo getTaskFromCache(TaskID inTaskID) {
        if (null == inTaskID) {
            return null;
        }
        return (TaskInfo)sTasksByID.get(inTaskID);
    }

    static void removeTaskFromCache(TaskInfo inTaskInfo) {
        if (null == inTaskInfo || null == inTaskInfo.getTaskID()) {
            return;
        }
        sTasksByID.remove(inTaskInfo.getTaskID());
    }

    public void addCleanupTask(PETransaction inTransaction) {
        this.mCleanupTasks.add(inTransaction);
    }

    PETransaction[] getCleanupTasks() {
        return this.mCleanupTasks.toArray(new PETransaction[0]);
    }

    private static class RunningTaskFinder
    extends QueryBuilder {
        Select mResults = null;

        protected RunningTaskFinder(IDColumn inPlanColumn) {
            this.mResults = this.getRunningTasks(inPlanColumn);
        }

        protected Select getRunningTasks(IDColumn inPlanColumn) {
            TaskInfoTable tasks = TaskInfoTable.DEFAULT;
            WhereClause where = null;
            where = null == inPlanColumn ? RunningTaskFinder.where(RunningTaskFinder.isNull(tasks.TaskComplete)) : RunningTaskFinder.where(RunningTaskFinder.and(RunningTaskFinder.isNull(tasks.TaskComplete), RunningTaskFinder.equals((ColumnNode)tasks.PlanID, inPlanColumn)));
            return RunningTaskFinder.select(tasks.allColumns(), RunningTaskFinder.tList(tasks), where);
        }

        protected Select getResults() {
            return this.mResults;
        }
    }

    private static class ReEntrantSave
    implements ReEntrantTransaction {
        private TaskInfo mInfo;

        ReEntrantSave(TaskInfo info) {
            this.mInfo = info;
        }

        public Object execute() throws PersistenceManagerException {
            this.mInfo.safeSaveMS(null);
            return null;
        }
    }
}

