/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.executor;

import com.raplix.rolloutexpress.event.TargetStatus;
import com.raplix.rolloutexpress.event.query.MultiEventQuery;
import com.raplix.rolloutexpress.event.query.MultiTargetStatusQuery;
import com.raplix.rolloutexpress.event.query.bean.RunningPlanBean;
import com.raplix.rolloutexpress.executor.AutoGeneratedPlan;
import com.raplix.rolloutexpress.executor.MultiStepStatusQuery;
import com.raplix.rolloutexpress.executor.SubplanInfoTable;
import com.raplix.rolloutexpress.executor.TaskIDSet;
import com.raplix.rolloutexpress.executor.TaskInfo;
import com.raplix.rolloutexpress.executor.query.MultiExecNativeOutputQuery;
import com.raplix.rolloutexpress.executor.query.MultiRunningPlanQuery;
import com.raplix.rolloutexpress.executor.query.MultiSubplanInfoQuery;
import com.raplix.rolloutexpress.executor.query.SingleAutoGeneratedPlanQuery;
import com.raplix.rolloutexpress.executor.query.SingleTaskInfoQuery;
import com.raplix.rolloutexpress.executor.target.SummaryTarget;
import com.raplix.rolloutexpress.message.ROXMessage;
import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.persist.DeleteSessionContext;
import com.raplix.rolloutexpress.persist.DeleteSessionDependentContainer;
import com.raplix.rolloutexpress.persist.IDResolvingTypedSet;
import com.raplix.rolloutexpress.persist.ObjectID;
import com.raplix.rolloutexpress.persist.ObjectIDFactory;
import com.raplix.rolloutexpress.persist.PersistContext;
import com.raplix.rolloutexpress.persist.UsingObject;
import com.raplix.rolloutexpress.persist.exception.ObjectInUseException;
import com.raplix.rolloutexpress.persist.exception.ObjectNotDeletableException;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.persist.query.NoResultsFoundException;
import com.raplix.rolloutexpress.persist.query.ObjectFilter;
import com.raplix.rolloutexpress.persist.query.QueryContext;
import com.raplix.rolloutexpress.persist.query.builder.QueryBuilder;
import com.raplix.rolloutexpress.systemmodel.componentdb.SummaryComponent;
import com.raplix.rolloutexpress.systemmodel.folderdb.FolderID;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostID;
import com.raplix.rolloutexpress.systemmodel.installdb.PersistentInstalledComponentTable;
import com.raplix.rolloutexpress.systemmodel.userdb.FolderPermission;
import com.raplix.util.logger.Logger;
import java.security.AccessControlException;
import java.security.AccessController;

public class TaskID
extends ObjectID {
    public static final TaskID TASK_SENTINEL_ID = new TaskID("010010001019-0000000000000-00011-0000000001");
    private static TaskIDFactory idFactory = new TaskIDFactory();

    private TaskID() {
    }

    public TaskID(String inID) {
        super(inID);
    }

    public SingleTaskInfoQuery getByIDQuery() {
        return new SingleTaskInfoQuery(this);
    }

    public static TaskID generateTaskID() {
        return (TaskID)idFactory.generateObjectID();
    }

    public void findDependentObjects(DeleteSessionContext inContext, DeleteSessionDependentContainer inDependentContainer, DeleteSessionDependentContainer inPostDependentContainer) throws PersistenceManagerException {
        try {
            if (TASK_SENTINEL_ID.equals(this)) {
                throw new ObjectNotDeletableException(new ROXMessage("pm.CANNOT_DELETE_OBJECT"));
            }
            RunningPlanBean[] beans = MultiRunningPlanQuery.byTaskIDs(new TaskID[]{this}).select();
            if (beans.length > 0 && beans[0].getIsRunning()) {
                if (Logger.isDebugEnabled("persist.objectdeletion")) {
                    Logger.debug("Task cannot be deleted because it's currently running", "persist.objectdeletion");
                }
                throw new ObjectInUseException(new ROXMessage("pm.OBJECT_IN_USE"));
            }
            TaskInfo theTask = this.getByIDQuery().select();
            FolderID theFolderID = null;
            AutoGeneratedPlan theAGPlan = null;
            try {
                theAGPlan = SingleAutoGeneratedPlanQuery.byExecutionPlanID(theTask.getPlanID()).select();
                SummaryComponent comp = theAGPlan.getComponentID().getByIDQuery().selectSummaryView();
                theFolderID = comp.getPath();
            }
            catch (NoResultsFoundException e) {
                theFolderID = theTask.getPlanID().getByIDQuery().selectSummaryView().getPath();
            }
            TargetStatus[] targetStatusArray = MultiTargetStatusQuery.byTaskID(this).select();
            for (int x = 0; x < targetStatusArray.length; ++x) {
                SummaryTarget target = targetStatusArray[x].getTargetID().getByIDQuery().selectSummaryView();
                HostID currentHostID = target.getCurrentHostID();
                this.checkDeleteHistoryPermission(theFolderID, currentHostID);
                if (currentHostID.equals(target.getPhysicalHostID())) continue;
                this.checkDeleteHistoryPermission(theFolderID, target.getPhysicalHostID());
            }
        }
        catch (RPCException rpce) {
            throw new PersistenceManagerException(rpce);
        }
        try {
            inDependentContainer.addAllDependentObjects(MultiExecNativeOutputQuery.byTaskID(this).selectObjects());
            MultiSubplanInfoQuery subplanInfoQuery = MultiSubplanInfoQuery.all();
            subplanInfoQuery.addFilter(new ObjectFilter(){

                public void addFilterCondition(QueryContext ctx) {
                    SubplanInfoTable t = (SubplanInfoTable)ctx.getFirstTable();
                    ctx.addAndWhereCondition(SubplanInfoTable.equals(t.TaskID, TaskID.this));
                }
            });
            inDependentContainer.addAllDependentObjects(subplanInfoQuery.select());
            inDependentContainer.addAllDependentObjects(MultiTargetStatusQuery.byTaskID(this).selectObjects());
            inDependentContainer.addAllDependentObjects(MultiEventQuery.byTaskID(this).selectObjects());
            inDependentContainer.addAllDependentObjects(MultiStepStatusQuery.byTaskID(this).selectObjects());
        }
        catch (RPCException rpce) {
            throw new PersistenceManagerException(rpce);
        }
    }

    protected IDResolvingTypedSet getIDResolvingTypedSet() throws PersistenceManagerException {
        TaskIDSet idset = new TaskIDSet();
        idset.add(this);
        return idset;
    }

    protected void deleteMS(PersistContext context) throws PersistenceManagerException {
        PersistentInstalledComponentTable ct = PersistentInstalledComponentTable.DEFAULT;
        QueryBuilder.execute(QueryBuilder.update(ct, QueryBuilder.uList(QueryBuilder.set(ct.TaskID, TASK_SENTINEL_ID)), QueryBuilder.where(QueryBuilder.equals(ct.TaskID, this))));
        super.deleteMS(context);
    }

    private void checkDeleteHistoryPermission(FolderID inFolderID, HostID inHostID) throws ObjectInUseException, PersistenceManagerException {
        try {
            FolderPermission permObj = FolderPermission.createDeleteHistoryPermission(inFolderID, inHostID);
            if (Logger.isInfoEnabled("persist.objectdeletion")) {
                Logger.info(permObj.getMessage().getMessageString(), "persist.objectdeletion");
            }
            try {
                AccessController.checkPermission(permObj);
            }
            catch (AccessControlException e) {
                if (Logger.isDebugEnabled("persist.objectdeletion")) {
                    Logger.debug("Task cannot be deleted because it's in use by folder " + inFolderID + " for host ID " + inHostID, "persist.objectdeletion");
                }
                throw new ObjectInUseException(permObj.getMessage(), new UsingObject[]{inFolderID.getByIDQuery().selectSummaryView(), inHostID.getByIDQuery().selectSummaryView()});
            }
        }
        catch (RPCException rpc) {
            throw new PersistenceManagerException(rpc);
        }
    }

    public static class TaskIDFactory
    extends ObjectIDFactory {
        protected ObjectID newInstance(String inID) {
            return new TaskID(inID);
        }
    }
}

