/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.executor;

import com.raplix.rolloutexpress.event.TargetStatus;
import com.raplix.rolloutexpress.event.TargetStatusTable;
import com.raplix.rolloutexpress.event.query.bean.TaskBean;
import com.raplix.rolloutexpress.event.query.bean.TaskInterface;
import com.raplix.rolloutexpress.executor.PlanExecutorMessages;
import com.raplix.rolloutexpress.executor.TaskID;
import com.raplix.rolloutexpress.executor.TaskInfo;
import com.raplix.rolloutexpress.executor.TaskInfoTable;
import com.raplix.rolloutexpress.executor.TaskStatusByHost;
import com.raplix.rolloutexpress.executor.target.Target;
import com.raplix.rolloutexpress.executor.target.TargetID;
import com.raplix.rolloutexpress.executor.target.TargetIDSet;
import com.raplix.rolloutexpress.executor.target.TargetImplTable;
import com.raplix.rolloutexpress.message.ROXMessageManager;
import com.raplix.rolloutexpress.net.rpc.RPCSerializable;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.persist.query.ResultProcessor;
import com.raplix.rolloutexpress.persist.query.builder.AndExp;
import com.raplix.rolloutexpress.persist.query.builder.ColumnNode;
import com.raplix.rolloutexpress.persist.query.builder.OrderByList;
import com.raplix.rolloutexpress.persist.query.builder.QueryBuilder;
import com.raplix.rolloutexpress.persist.query.builder.SelectList;
import com.raplix.rolloutexpress.persist.query.builder.TableClause;
import com.raplix.rolloutexpress.persist.query.builder.TableList;
import com.raplix.rolloutexpress.persist.query.builder.WhereClause;
import com.raplix.rolloutexpress.systemmodel.hostdbx.Host;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostImplTable;
import com.raplix.rolloutexpress.systemmodel.hostdbx.SummaryHost;
import com.raplix.rolloutexpress.systemmodel.hostdbx.SummaryHostType;
import com.raplix.util.logger.Logger;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;

public class TaskHostStatusBean
implements RPCSerializable,
TaskInterface,
PlanExecutorMessages {
    private TaskStatusByHost mTaskStatusByHost = TaskStatusByHost.NOT_STARTED;
    private Host mHost;
    private TaskBean mTask = new TaskBean();
    private TargetID mTargetID;

    public TaskHostStatusBean() {
    }

    public TaskHostStatusBean(TaskInfo inTaskInfo, TaskStatusByHost inTaskStatusByHost) {
        this.mTask = new TaskBean(inTaskInfo);
        this.mTaskStatusByHost = inTaskStatusByHost;
    }

    public void setTaskStatusByHost(TaskStatusByHost inTaskStatusByHost) {
        this.mTaskStatusByHost = inTaskStatusByHost;
    }

    public TaskStatusByHost getTaskStatusByHost() {
        return this.mTaskStatusByHost;
    }

    public Date getPreparedDate() {
        if (null == this.mHost) {
            return null;
        }
        return this.mHost.getMachineInfoTimestamp();
    }

    public SummaryHost getSummaryHost() {
        return this.mHost;
    }

    public SummaryHostType getSummaryHostType() {
        if (null == this.mHost) {
            return null;
        }
        return this.mHost.getHostType();
    }

    public void setHost(Host inHost) {
        this.mHost = inHost;
    }

    public TaskID getTaskID() {
        return this.mTask.getTaskID();
    }

    public void setTaskID(TaskID inTaskID) {
        this.mTask.setTaskID(inTaskID);
    }

    public TaskInfo getTaskInfo() {
        return this.mTask.getTaskInfo();
    }

    public boolean getIsPreflight() {
        return this.mTask.getIsPreflight();
    }

    public void setIsPreflight(boolean isPreflight) {
        this.mTask.setIsPreflight(isPreflight);
    }

    public boolean preflightInUse() {
        return this.mTask.preflightInUse();
    }

    public String toString() {
        StringBuffer output = new StringBuffer();
        output.append("TaskHostStatusBean - ");
        output.append(this.mTask == null ? "null task" : (null == this.mTask.getTaskID() ? "null taskid" : this.mTask.getTaskID().toString())).append("|");
        output.append(this.mHost == null ? "null host" : (null == this.mHost.getID() ? "null hostid" : this.mHost.getID().toString())).append("|");
        output.append(this.getTaskStatusByHost()).append("|");
        output.append(this.getPreparedDate());
        return output.toString();
    }

    void setTargetID(TargetID inTargetID) {
        this.mTargetID = inTargetID;
    }

    TargetID getTargetID() {
        return this.mTargetID;
    }

    public static TaskHostStatusBean[] taskStatusByHostQuery(TaskID inTaskID) throws PersistenceManagerException {
        if (null == inTaskID) {
            throw new NullPointerException();
        }
        TaskStatusByHostRetriever statusRetriever = new TaskStatusByHostRetriever(inTaskID);
        return statusRetriever.getResult();
    }

    private static final class TaskHostStatusBeanResultSetProcessor
    extends ResultProcessor {
        private TaskInfoTable mTaskTable;
        private TargetStatusTable mTargetStatusTable;
        private HostImplTable mHostTable;
        private TargetIDSet mTargetSet;

        public TaskHostStatusBeanResultSetProcessor(TaskInfoTable inTaskInfoTable, TargetStatusTable inTargetStatusTable, HostImplTable inHostTable) {
            this.mTaskTable = inTaskInfoTable;
            this.mTargetStatusTable = inTargetStatusTable;
            this.mHostTable = inHostTable;
            this.mTargetSet = new TargetIDSet();
        }

        public Object processRow(ResultSet inResultSet) throws PersistenceManagerException, SQLException {
            TaskInfo theTaskInfo = this.mTaskTable.retrieveObject(inResultSet);
            TargetStatus theTargetStatus = this.mTargetStatusTable.retrieveObject(inResultSet);
            this.mTargetSet.add(theTargetStatus.getTargetID());
            TaskStatusByHost theStatus = null;
            switch (theTargetStatus.getStatus()) {
                case 0: {
                    theStatus = TaskStatusByHost.NOT_STARTED;
                    break;
                }
                case 1: {
                    theStatus = TaskStatusByHost.COMPLETE;
                    break;
                }
                case 2: {
                    theStatus = TaskStatusByHost.INCOMPLETE_ERROR;
                    break;
                }
                case 3: {
                    theStatus = TaskStatusByHost.IN_PROGRESS;
                    break;
                }
                case 4: {
                    theStatus = TaskStatusByHost.INCOMPLETE_ABORT;
                    break;
                }
                case 5: {
                    theStatus = TaskStatusByHost.INCOMPLETE_TIMEOUT;
                }
            }
            TaskHostStatusBean bean = new TaskHostStatusBean(theTaskInfo, theStatus);
            bean.setTargetID(theTargetStatus.getTargetID());
            return bean;
        }

        public Vector getResults() {
            Target[] targets;
            block7: {
                targets = null;
                try {
                    targets = this.mTargetSet.getByIDsQuery().select();
                }
                catch (Exception e) {
                    if (!Logger.isErrorEnabled(this)) break block7;
                    Logger.error(ROXMessageManager.messageAsString("pe.CANT_RETRIEVE_TARGETS"), this);
                }
            }
            Hashtable<TargetID, Target> targetsByID = null;
            if (targets != null) {
                targetsByID = new Hashtable<TargetID, Target>();
                for (int i = 0; i < targets.length; ++i) {
                    targetsByID.put(targets[i].getID(), targets[i]);
                }
            }
            Vector<TaskHostStatusBean> running = new Vector<TaskHostStatusBean>();
            Vector<TaskHostStatusBean> notrunning = new Vector<TaskHostStatusBean>();
            Iterator it = this.mResults.iterator();
            while (it.hasNext()) {
                TaskHostStatusBean bean = (TaskHostStatusBean)it.next();
                if (targetsByID != null) {
                    bean.setHost(((Target)targetsByID.get(bean.getTargetID())).getInitialHost());
                }
                if (bean.getTaskStatusByHost().isCompleted()) {
                    notrunning.add(bean);
                    continue;
                }
                running.add(bean);
            }
            this.mResults.clear();
            this.mResults.addAll(running);
            this.mResults.addAll(notrunning);
            return this.mResults;
        }
    }

    private static class TaskStatusByHostRetriever
    extends QueryBuilder {
        TaskHostStatusBean[] mResults = null;

        protected TaskStatusByHostRetriever(TaskID inTaskID) throws PersistenceManagerException {
            this.mResults = this.getTaskHostStatus(inTaskID);
        }

        protected TaskHostStatusBean[] getTaskHostStatus(TaskID inTaskID) throws PersistenceManagerException {
            TaskInfoTable infoTable = new TaskInfoTable("ti");
            TargetImplTable targetTable = new TargetImplTable("t");
            TargetStatusTable targetStatusTable = new TargetStatusTable("ts");
            HostImplTable hostTable = new HostImplTable("h");
            SelectList selectList = TaskStatusByHostRetriever.sList(infoTable.allColumns(), targetStatusTable.allColumns(), hostTable.allColumns());
            TableList tableList = TaskStatusByHostRetriever.tList(TaskStatusByHostRetriever.tList(infoTable, targetTable, targetStatusTable), (TableClause)hostTable);
            AndExp and = TaskStatusByHostRetriever.and();
            and.add(TaskStatusByHostRetriever.equals(infoTable.ID, inTaskID));
            and.add(TaskStatusByHostRetriever.equals((ColumnNode)infoTable.ID, targetStatusTable.TaskID));
            and.add(TaskStatusByHostRetriever.equals((ColumnNode)targetStatusTable.TargetID, targetTable.ID));
            and.add(TaskStatusByHostRetriever.equals((ColumnNode)targetTable.InitialHostID, hostTable.ID));
            WhereClause where = TaskStatusByHostRetriever.where(and);
            OrderByList orderBy = TaskStatusByHostRetriever.oList(TaskStatusByHostRetriever.orderByAsc(hostTable.MachineInfoTimestamp));
            TaskHostStatusBeanResultSetProcessor statusProcessor = new TaskHostStatusBeanResultSetProcessor(infoTable, targetStatusTable, hostTable);
            TaskStatusByHostRetriever.execute(TaskStatusByHostRetriever.select(selectList, tableList, where, orderBy), statusProcessor);
            Vector results = statusProcessor.getResults();
            if (results.isEmpty()) {
                return new TaskHostStatusBean[0];
            }
            return results.toArray(new TaskHostStatusBean[0]);
        }

        protected TaskHostStatusBean[] getResult() {
            return this.mResults;
        }
    }
}

