/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.executor;

import com.raplix.rolloutexpress.config.VariableSettingsHolder;
import com.raplix.rolloutexpress.executor.CompiledPlan;
import com.raplix.rolloutexpress.executor.PlanExecutionException;
import com.raplix.rolloutexpress.executor.PlanExecutorMessages;
import com.raplix.rolloutexpress.executor.RunLevel;
import com.raplix.rolloutexpress.executor.SubplanPrompt;
import com.raplix.rolloutexpress.message.ROXMessage;
import com.raplix.rolloutexpress.net.rpc.RPCSerializable;
import com.raplix.rolloutexpress.systemmodel.plandb.ExecutionPlanID;
import com.raplix.rolloutexpress.systemmodel.plandb.PromptParamList;
import com.raplix.rolloutexpress.systemmodel.userdb.UserID;
import com.raplix.util.Util;
import com.raplix.util.Validate;

public class TaskDescriptor
implements RPCSerializable,
PlanExecutorMessages {
    private CompiledPlan mPlan;
    private RunLevel mRunLevel;
    private UserID mRoxUser;
    private int mPlanTimeoutSecs;
    private int mNativeCallTimeoutSecs;
    private SubplanPrompt[] mSubplanPrompts;
    private String mDefaultUserToRunAs;
    private int mPlanThrottle;
    private boolean mDetailedPreflight;
    private VariableSettingsHolder mSpecifiedPlanParams;

    private TaskDescriptor() {
    }

    public TaskDescriptor(CompiledPlan inPlan, RunLevel inRunLevel, SubplanPrompt[] inSubplanPrompts, UserID inRoxUser, String inDefaultUserToRunAs, int inPlanTimeoutSecs, int inNativeCallTimeoutSecs, int inPlanThrottle, boolean inDetailedPreflight) throws PlanExecutionException {
        this.mPlan = inPlan;
        this.mRunLevel = inRunLevel;
        this.mRoxUser = inRoxUser;
        this.mDefaultUserToRunAs = inDefaultUserToRunAs;
        this.mPlanTimeoutSecs = inPlanTimeoutSecs;
        this.mNativeCallTimeoutSecs = inNativeCallTimeoutSecs;
        this.mSubplanPrompts = inSubplanPrompts;
        this.mPlanThrottle = inPlanThrottle;
        this.mDetailedPreflight = inDetailedPreflight;
    }

    public void validate() throws PlanExecutionException {
        if (this.mPlan == null) {
            throw new PlanExecutionException(new ROXMessage("pe.TASK_INFO_REQUIRES_PLAN", 2000));
        }
        if (this.mRunLevel == null) {
            throw new PlanExecutionException(new ROXMessage("pe.TASK_INFO_BAD_RUN_LEVEL", (Object[])new String[]{this.mRunLevel.toString()}, 2000));
        }
        if (this.mRoxUser == null) {
            throw new PlanExecutionException(new ROXMessage("pe.TASK_INFO_REQUIRES_USER", 2000));
        }
        if (this.mSubplanPrompts == null) {
            throw new PlanExecutionException(new ROXMessage("pe.TASK_INFO_REQUIERS_PLAN_PROMPTS", 2000));
        }
        if (this.mPlan.getNumSimpleSubplans() != this.mSubplanPrompts.length) {
            throw new PlanExecutionException(new ROXMessage("pe.ERR_INCORRECT_PROMPT", (Object[])new Integer[]{new Integer(this.mSubplanPrompts.length), new Integer(this.mPlan.getNumSimpleSubplans())}, 2000));
        }
        for (int i = 0; i < this.mSubplanPrompts.length; ++i) {
            if (this.mSubplanPrompts[i].getTargets() != null && this.mSubplanPrompts[i].getTargets().length != 0) continue;
            throw new PlanExecutionException(new ROXMessage("pe.TASK_INFO_NO_TARGET_HOSTS_SUBPLAN", (Object[])new String[]{this.mSubplanPrompts[i].getSubplanName()}, 2000));
        }
        try {
            Validate.assertValidTimeout(this.mNativeCallTimeoutSecs, 1);
        }
        catch (IllegalArgumentException ex) {
            throw new PlanExecutionException(new ROXMessage("pe.TASK_INFO_INVALID_NATIVE_CALL_TIMEOUT", (Object[])new String[]{Integer.toString(this.mNativeCallTimeoutSecs)}, 2000), (Throwable)ex);
        }
        try {
            Validate.assertValidTimeout(this.mPlanTimeoutSecs, 1);
        }
        catch (IllegalArgumentException ex) {
            throw new PlanExecutionException(new ROXMessage("pe.TASK_INFO_INVALID_PLAN_TIMEOUT", (Object[])new String[]{Integer.toString(this.mPlanTimeoutSecs)}, 2000), (Throwable)ex);
        }
        if (this.mPlanThrottle < 1) {
            throw new PlanExecutionException(new ROXMessage("pe.TASK_INFO_INVALID_PLAN_THROTTLE", 2000));
        }
        String[] paramNameList = this.getPlanParameters().getVarNames();
        PromptParamList defaultParams = this.getPlanParameters();
        if (paramNameList.length > 0 && this.mSpecifiedPlanParams == null) {
            throw new PlanExecutionException(new ROXMessage("pe.TASK_INFO_REQUIRES_PROMPT_VALUES", (Object[])new String[]{new Integer(paramNameList.length).toString()}, 2000));
        }
        for (int i = 0; i < paramNameList.length; ++i) {
            if (defaultParams.getVarValue(paramNameList[i]) != null || this.mSpecifiedPlanParams.getVarValue(paramNameList[i]) != null) continue;
            throw new PlanExecutionException(new ROXMessage("pe.TASK_INFO_PLAN_PARAM_EMPTY", (Object[])new String[]{paramNameList[i]}, 2000));
        }
    }

    public CompiledPlan getCompiledPlan() {
        return this.mPlan;
    }

    public RunLevel getRunLevel() {
        return this.mRunLevel;
    }

    public UserID getRoxUser() {
        return this.mRoxUser;
    }

    public int getPlanTimeoutSecs() {
        return this.mPlanTimeoutSecs;
    }

    public int getNativeCallTimeoutSecs() {
        return this.mNativeCallTimeoutSecs;
    }

    public SubplanPrompt[] getSubplanPrompts() {
        return this.mSubplanPrompts;
    }

    public ExecutionPlanID getPlanID() {
        if (this.mPlan == null || this.mPlan.getTopLevelPlan() == null) {
            return null;
        }
        return this.mPlan.getTopLevelPlan().getID();
    }

    public String getDefaultUserToRunAs() {
        return this.mDefaultUserToRunAs;
    }

    public PromptParamList getPlanParameters() {
        return this.getCompiledPlan().getTopLevelPlan().getParams();
    }

    public VariableSettingsHolder getPlanParameterValues() {
        return this.mSpecifiedPlanParams;
    }

    public boolean getDetailedPreflight() {
        return this.mDetailedPreflight;
    }

    public void setDetailedPreflight(boolean inDetailedPreflight) {
        this.mDetailedPreflight = inDetailedPreflight;
    }

    public int getPlanThrottle() {
        return this.mPlanThrottle;
    }

    public void setPlanThrottle(int inPlanThrottle) {
        this.mPlanThrottle = inPlanThrottle;
    }

    public void setRunLevel(RunLevel inRunLevel) {
        this.mRunLevel = inRunLevel;
    }

    public void setRoxUser(UserID inRoxUser) {
        this.mRoxUser = inRoxUser;
    }

    public void setPlanTimeoutSecs(int inPlanTimeoutSecs) {
        this.mPlanTimeoutSecs = inPlanTimeoutSecs;
    }

    public void setNativeCallTimeoutSecs(int inNativeCallTimeoutSecs) {
        this.mNativeCallTimeoutSecs = inNativeCallTimeoutSecs;
    }

    public void setSubplanPrompts(SubplanPrompt[] inPrompts) {
        this.mSubplanPrompts = inPrompts;
    }

    public void setDefaultUserToRunAs(String inUser) {
        this.mDefaultUserToRunAs = inUser;
    }

    public void setPlanParameterValues(VariableSettingsHolder inArgs) {
        this.mSpecifiedPlanParams = inArgs;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer(1024);
        buf.append("CompiledPlan: ").append(this.mPlan.toString());
        buf.append("mRunLevel: ").append(this.mRunLevel).append(", ");
        if (this.mRoxUser != null) {
            buf.append("RoxUser: ").append(this.mRoxUser.toString()).append(", ");
        }
        buf.append("PlanTimeout: ").append(this.mPlanTimeoutSecs).append(" ");
        buf.append("ExecNativeTimeout: ").append(this.mNativeCallTimeoutSecs).append(" ");
        buf.append("SubplanPrompts [").append(Util.getStringFromArray(this.mSubplanPrompts, ",")).append("] }");
        return buf.toString();
    }
}

