/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.executor;

import com.raplix.rolloutexpress.executor.CompiledSimpleSubplan;
import com.raplix.rolloutexpress.net.rpc.RPCSerializable;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentSelector;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostID;
import com.raplix.rolloutexpress.systemmodel.plandb.ExecutionPlanID;
import com.raplix.util.Util;
import com.raplix.util.collections.CollectionUtil;

public class SubplanPrompt
implements RPCSerializable {
    private String mSubplanName;
    private ExecutionPlanID mSubplanID;
    private HostID[] mTargets;
    private ComponentSelector[] mCompSelectors;
    private String mLimitToHostSet;

    private SubplanPrompt() {
        this.mCompSelectors = new ComponentSelector[0];
    }

    public SubplanPrompt(CompiledSimpleSubplan inSubplan, ComponentSelector[] inCompSelectors) {
        this(inSubplan.getName(), inSubplan.getSubplanPlanID(), null, inCompSelectors);
        this.setLimitToHostSet(inSubplan.getPlanData().getLimitToHostSet());
    }

    public SubplanPrompt(String inSubplanName, ExecutionPlanID inPlanID, HostID[] inTargets, ComponentSelector[] inCompSelectors) {
        this.mSubplanName = inSubplanName;
        this.mSubplanID = inPlanID;
        this.setInitialTargets(inTargets);
        this.setLimitToHostSet(null);
        this.mCompSelectors = inCompSelectors == null ? new ComponentSelector[]{} : inCompSelectors;
    }

    public String getSubplanName() {
        return this.mSubplanName;
    }

    public ExecutionPlanID getSubplanID() {
        return this.mSubplanID;
    }

    public HostID[] getTargets() {
        return this.mTargets;
    }

    public int getNumComponentSelectors() {
        return this.mCompSelectors.length;
    }

    public ComponentSelector getComponentSelector(int inCompNum) {
        return this.mCompSelectors[inCompNum];
    }

    public String getLimitToHostSet() {
        return this.mLimitToHostSet;
    }

    public void setInitialTargets(HostID[] inTargets) {
        this.mTargets = inTargets;
    }

    private void setLimitToHostSet(String inLimit) {
        this.mLimitToHostSet = inLimit;
    }

    public String toString() {
        StringBuffer out = new StringBuffer();
        out.append("{ subName: ").append(this.mSubplanName).append(" with targets: [");
        out.append(Util.getStringFromArray(this.mTargets, ",")).append("] }");
        out.append("{ compSelectors: ").append(CollectionUtil.toString(this.mCompSelectors)).append("}");
        return out.toString();
    }
}

