/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.executor;

import com.raplix.rolloutexpress.config.ConfigGenException;
import com.raplix.rolloutexpress.config.ConfigGenManager;
import com.raplix.rolloutexpress.config.ConfigGenerator;
import com.raplix.rolloutexpress.executor.CompiledPlanExecutor;
import com.raplix.rolloutexpress.executor.ExecutionState;
import com.raplix.rolloutexpress.executor.PlanExecutionException;
import com.raplix.rolloutexpress.executor.PlanTargetedConfigContext;
import com.raplix.rolloutexpress.executor.virtual.VirtualAgent;
import com.raplix.rolloutexpress.net.rpc.RPCSerializable;
import com.raplix.rolloutexpress.systemmodel.plandb.ExecStep;
import com.raplix.rolloutexpress.systemmodel.plandb.ExecSubplanStep;
import com.raplix.rolloutexpress.systemmodel.plandb.ExecutionPlan;
import com.raplix.rolloutexpress.systemmodel.plandb.ExecutionPlanData;
import com.raplix.rolloutexpress.systemmodel.plandb.ExecutionPlanID;
import com.raplix.rolloutexpress.systemmodel.plandb.InlineSubplanStep;

public class SubplanInvoker
implements RPCSerializable {
    private ExecutionPlanData mPlanData;
    private ExecSubplanStep mInvokingStep;
    private ExecutionPlanID mSubplanPlanID;

    private SubplanInvoker() {
    }

    public SubplanInvoker(ExecutionPlanData inPlanData, ExecutionPlanID inSubplanPlanID, ExecSubplanStep inInvokingStep) {
        this.mPlanData = inPlanData;
        this.mInvokingStep = inInvokingStep;
        this.mSubplanPlanID = inSubplanPlanID;
    }

    public ConfigGenerator pushNewCallScopes(ConfigGenerator inCG, VirtualAgent inAgent, ExecutionState inState, ConfigGenManager inCGMgr, boolean inHidePasswords) throws ConfigGenException, PlanExecutionException {
        if (this.mPlanData instanceof ExecutionPlan && this.mInvokingStep != null && this.mInvokingStep instanceof ExecSubplanStep) {
            ExecSubplanStep step = (ExecSubplanStep)this.mInvokingStep.generate(inCG);
            ExecutionPlan plan = (ExecutionPlan)this.mPlanData;
            inCG = inHidePasswords ? inState.getTopLevelPassSafeSessionConfigGen().newCallScope(plan.getParams(), CompiledPlanExecutor.hidePasswordValues(plan.getParams(), step.getArgs())) : inState.getTopLevelSessionConfigGen().newCallScope(plan.getParams(), step.getArgs());
        }
        if (this.mPlanData.isSimplePlan()) {
            PlanTargetedConfigContext planTargetedCtx = null;
            planTargetedCtx = inState.getCurrPlanTargetedCtx();
            if (planTargetedCtx == null) {
                planTargetedCtx = new PlanTargetedConfigContext(inAgent, inState);
                inState.setPlanTargetedCtx(planTargetedCtx);
            }
            inCG = inCG.newTargetScope(planTargetedCtx, inState.getTaskInfo().getInstallDBContext());
            inCG = inCG.newCallerScope(inState.getCaller());
        }
        inCG = inCG.newUnresVarScope(this.mPlanData.getLocalVars());
        return inCG;
    }

    public ExecutionPlanData getPlanData() {
        return this.mPlanData;
    }

    public ExecutionPlanID getSubplanPlanID() {
        return this.mSubplanPlanID;
    }

    public ExecStep getInvokingStep() {
        if (this.mPlanData instanceof InlineSubplanStep) {
            return (InlineSubplanStep)this.mPlanData;
        }
        return this.mInvokingStep;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("InvokingStep: ").append(this.getInvokingStep()).append(" SubplanID: ").append(this.getSubplanPlanID()).append(" SubplanData: ").append(this.getPlanData() == null ? "null" : this.getPlanData().getName());
        return buffer.toString();
    }
}

