/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.executor;

import [Lcom.raplix.rolloutexpress.systemmodel.hostdbx.HostID;;
import com.raplix.rolloutexpress.config.GeneratedVariableSettingsID;
import com.raplix.rolloutexpress.executor.PlanExecutionException;
import com.raplix.rolloutexpress.executor.SubplanInfoID;
import com.raplix.rolloutexpress.executor.SubplanPrompt;
import com.raplix.rolloutexpress.executor.SubplanToTargetLinkTable;
import com.raplix.rolloutexpress.executor.TaskID;
import com.raplix.rolloutexpress.executor.TaskInfo;
import com.raplix.rolloutexpress.executor.target.SummaryTarget;
import com.raplix.rolloutexpress.executor.target.Target;
import com.raplix.rolloutexpress.executor.target.TargetID;
import com.raplix.rolloutexpress.executor.target.TargetIDSet;
import com.raplix.rolloutexpress.net.rpc.CommandException;
import com.raplix.rolloutexpress.net.rpc.RPCSerializable;
import com.raplix.rolloutexpress.persist.HasObjectID;
import com.raplix.rolloutexpress.persist.PersistentObject;
import com.raplix.rolloutexpress.persist.Transaction;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.persist.util.Link;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentID;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostID;
import com.raplix.rolloutexpress.systemmodel.plandb.ExecutionPlanID;
import com.raplix.util.collections.CollectionUtil;
import com.raplix.util.collections.Mapper;

public class SubplanInfo
extends PersistentObject
implements RPCSerializable,
HasObjectID {
    private TaskID mTaskID;
    private String mSubplanName;
    private ExecutionPlanID mSubplanID;
    private ComponentID[] mComponentIDs;
    private GeneratedVariableSettingsID[] mVarsettingsIDs;
    private TargetIDSet mTargets = new TargetIDSet();
    private int mSubplanIndex;

    public SubplanInfo() {
    }

    public SubplanInfo(SubplanPrompt inPrompt, GeneratedVariableSettingsID[] ingvsIDs, ComponentID[] inCompIDs, Target[] inTargets, TaskInfo inTaskInfo, int inSubplanIndex) {
        if (inPrompt == null) {
            throw new IllegalArgumentException();
        }
        this.setTaskID(inTaskInfo.getID());
        this.mSubplanName = inPrompt.getSubplanName();
        this.mSubplanID = inPrompt.getSubplanID();
        this.setGeneratedVariableSettingsIDs(ingvsIDs);
        this.setComponentIDs(inCompIDs);
        this.setTargets(inTargets);
        this.mSubplanIndex = inSubplanIndex;
    }

    public TaskID getTaskID() {
        return this.mTaskID;
    }

    void setTaskID(TaskID inTaskID) {
        this.mTaskID = inTaskID;
    }

    public String getSubplanName() {
        return this.mSubplanName;
    }

    public SubplanInfoID getID() {
        return (SubplanInfoID)this.getObjectID();
    }

    public ExecutionPlanID getSubplanID() {
        return this.mSubplanID;
    }

    public Target[] getTargets() throws PlanExecutionException {
        try {
            return this.getTargetIDSet().getByIDsQuery().select();
        }
        catch (CommandException ce) {
            throw new PlanExecutionException(ce);
        }
    }

    public synchronized TargetIDSet getTargetIDSet() {
        return this.mTargets;
    }

    public HostID[] getInitialHostIDs() throws PlanExecutionException {
        try {
            SummaryTarget[] summaryTargets = this.getTargetIDSet().getByIDsQuery().selectSummaryView();
            return (HostID[])CollectionUtil.mapClass(summaryTargets, HostID;.class, new Target2InitialHostIDMapper());
        }
        catch (Exception ex) {
            throw new PlanExecutionException(ex);
        }
    }

    public ComponentID[] getComponentIDs() {
        return this.mComponentIDs;
    }

    public String toString() {
        StringBuffer output = new StringBuffer();
        output.append("SubplanInfo " + this.getID()).append("\n");
        output.append("\t").append("Targets:").append("\n").append("\t\t");
        try {
            if (this.getTargets() != null) {
                for (int i = 0; i < this.getTargets().length; ++i) {
                    output.append(this.getTargets()[i].toString()).append("\n");
                }
            } else {
                output.append("null").append("\n");
            }
        }
        catch (Exception e) {
            output.append("null").append("\n");
        }
        return output.toString();
    }

    public GeneratedVariableSettingsID[] getGeneratedVariableSettingsIDs() {
        return this.mVarsettingsIDs;
    }

    private synchronized void setTargets(Target[] inTargets) {
        this.mTargets = new TargetIDSet();
        if (null != inTargets) {
            for (int i = 0; i < inTargets.length; ++i) {
                this.mTargets.add(inTargets[i].getID());
            }
        }
    }

    private void setComponentIDs(ComponentID[] inComponentIDs) {
        this.mComponentIDs = inComponentIDs;
    }

    private void setGeneratedVariableSettingsIDs(GeneratedVariableSettingsID[] inVarSettingsIDs) {
        this.mVarsettingsIDs = inVarSettingsIDs;
    }

    public void save() throws PersistenceManagerException {
        SubplanInfo.transactMS(new Transaction(){

            public Object execute() throws PersistenceManagerException {
                SubplanInfo.super.save();
                SubplanToTargetLinkTable.DEFAULT.resetLinks(SubplanInfo.this.getID(), SubplanInfo.this.mTargets.toIDArray(), true);
                return null;
            }
        });
    }

    public void retrieve() throws PersistenceManagerException {
        SubplanInfo.transactMS(new Transaction(){

            public Object execute() throws PersistenceManagerException {
                SubplanInfo.super.retrieve();
                SubplanInfo.this.loadExternalDataMS();
                return null;
            }
        });
    }

    synchronized void loadExternalDataMS() throws PersistenceManagerException {
        Link[] children = SubplanToTargetLinkTable.DEFAULT.getByParentID(this.getID());
        this.mTargets = new TargetIDSet();
        for (int i = 0; i < children.length; ++i) {
            this.mTargets.add((TargetID)children[i].getChildObjectID());
        }
    }

    public int getSubplanIndex() {
        return this.mSubplanIndex;
    }

    public static class Target2InitialHostIDMapper
    implements Mapper {
        public void setMappedClass(Class cls) {
        }

        public Object map(Object element) throws Exception {
            return ((SummaryTarget)element).getInitialHostID();
        }
    }
}

