/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.executor;

import com.raplix.rolloutexpress.executor.PlanExecutorMessages;
import com.raplix.rolloutexpress.executor.StepInfo;
import com.raplix.rolloutexpress.executor.TaskStatusBean;
import com.raplix.rolloutexpress.executor.task.ExecNativeOutput;
import com.raplix.rolloutexpress.net.rpc.RPCSerializable;
import java.util.Comparator;

public class StepStatusBean
implements RPCSerializable,
PlanExecutorMessages {
    private TaskStatusBean mTaskStatusBean;
    private StepInfo mStepInfo;
    private ExecNativeOutput mExecNativeOutput;
    static final StepMapOnlyComparator STEPMAPCOMPARATOR = new StepMapOnlyComparator();

    private StepStatusBean() {
    }

    public StepStatusBean(TaskStatusBean inTaskStatusBean, StepInfo inStepInfo) {
        this.setTaskStatusBean(inTaskStatusBean);
        this.setStepInfo(inStepInfo);
    }

    public StepStatusBean(StepInfo inStepInfo) {
        this.setStepInfo(inStepInfo);
    }

    public TaskStatusBean getTaskStatusBean() {
        return this.mTaskStatusBean;
    }

    public StepInfo getStepInfo() {
        return this.mStepInfo;
    }

    public ExecNativeOutput getExecNativeOutput() {
        return this.mExecNativeOutput;
    }

    public boolean getStepFailed() {
        return this.getStepInfo().getSeverity() == 4;
    }

    protected void setExecNativeOutput(ExecNativeOutput inExecNativeOutput) {
        this.mExecNativeOutput = inExecNativeOutput;
    }

    protected void setTaskStatusBean(TaskStatusBean inTaskStatusBean) {
        if (null == inTaskStatusBean) {
            throw new NullPointerException();
        }
        this.mTaskStatusBean = inTaskStatusBean;
    }

    protected void setStepInfo(StepInfo inStepInfo) {
        if (null == inStepInfo) {
            throw new NullPointerException();
        }
        this.mStepInfo = inStepInfo;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(super.toString()).append("\n").append(this.getStepInfo());
        return buf.toString();
    }

    public int compareTo(Object o) {
        if (null == o) {
            return 1;
        }
        StepStatusBean otherBean = (StepStatusBean)o;
        if (null == this.getStepInfo()) {
            return otherBean.getStepInfo() == null ? 0 : -1;
        }
        return this.getStepInfo().compareTo(otherBean.getStepInfo());
    }

    public boolean equals(Object o) {
        try {
            StepStatusBean otherBean = (StepStatusBean)o;
            if (this.getStepInfo() == null) {
                return otherBean.getStepInfo() == null;
            }
            return this.getStepInfo().equals(otherBean.getStepInfo());
        }
        catch (ClassCastException cce) {
            return false;
        }
        catch (NullPointerException npe) {
            return false;
        }
    }

    static class StepMapOnlyComparator
    implements Comparator {
        StepMapOnlyComparator() {
        }

        public boolean equals(Object o) {
            return o instanceof StepMapOnlyComparator;
        }

        public int compare(Object lhs, Object rhs) {
            StepStatusBean leftBean = (StepStatusBean)lhs;
            StepStatusBean rightBean = (StepStatusBean)rhs;
            if (leftBean.getStepInfo().getStepMap() == rightBean.getStepInfo().getStepMap()) {
                return 0;
            }
            return leftBean.getStepInfo().getStepMap() < rightBean.getStepInfo().getStepMap() ? -1 : 1;
        }
    }
}

