/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.executor;

import com.raplix.rolloutexpress.net.rpc.RPCSerializable;
import com.raplix.util.enum.Enum;
import com.raplix.util.enum.EnumFactory;
import com.raplix.util.enum.NoSuchEnumException;

public class StepStatus
extends Enum
implements RPCSerializable {
    public static final Factory FACTORY = new Factory();
    public static final StepStatus NOT_STARTED = new StepStatus("Not Started");
    public static final StepStatus PREFLIGHT_RUNNING = new StepStatus("Preflight Running");
    public static final StepStatus DEPLOYMENT_RUNNING = new StepStatus("Deployment Running");
    public static final StepStatus COMPLETE = new StepStatus("Complete");
    public static final StepStatus COMPLETE_WARNING = new StepStatus("Complete - Warning");
    public static final StepStatus INCOMPLETE_ERROR = new StepStatus("Incomplete - Error");
    public static final StepStatus INCOMPLETE_ABORT = new StepStatus("Incomplete - Aborted");
    public static final StepStatus PREFLIGHT_ERROR = new StepStatus("Preflight Error");
    public static final StepStatus PRIOR_ERROR = new StepStatus("Prior Error");

    public static StepStatus chooseStatus(StepStatus lhs, StepStatus rhs) {
        if (null == lhs || null == rhs) {
            throw new NullPointerException();
        }
        if (lhs.equals(INCOMPLETE_ERROR) || rhs.equals(INCOMPLETE_ERROR)) {
            return INCOMPLETE_ERROR;
        }
        if (lhs.equals(INCOMPLETE_ABORT) || rhs.equals(INCOMPLETE_ABORT)) {
            return INCOMPLETE_ABORT;
        }
        if (lhs.equals(COMPLETE_WARNING) || rhs.equals(COMPLETE_WARNING)) {
            return COMPLETE_WARNING;
        }
        if (lhs.equals(PREFLIGHT_ERROR) || rhs.equals(PREFLIGHT_ERROR)) {
            return PREFLIGHT_ERROR;
        }
        if (lhs.equals(PRIOR_ERROR) || rhs.equals(PRIOR_ERROR)) {
            return PRIOR_ERROR;
        }
        if (lhs.equals(COMPLETE) || rhs.equals(COMPLETE)) {
            return COMPLETE;
        }
        if (lhs.equals(DEPLOYMENT_RUNNING) || rhs.equals(DEPLOYMENT_RUNNING)) {
            return DEPLOYMENT_RUNNING;
        }
        if (lhs.equals(PREFLIGHT_RUNNING) || rhs.equals(PREFLIGHT_RUNNING)) {
            return PREFLIGHT_RUNNING;
        }
        if (lhs.equals(COMPLETE) || rhs.equals(COMPLETE)) {
            return COMPLETE;
        }
        return NOT_STARTED;
    }

    public boolean succeeded() {
        return !this.failed();
    }

    public boolean running() {
        return !this.completed();
    }

    public boolean completed() {
        return this.equals(INCOMPLETE_ERROR) || this.equals(INCOMPLETE_ABORT) || this.equals(PREFLIGHT_ERROR) || this.equals(PRIOR_ERROR) || this.equals(COMPLETE) || this.equals(COMPLETE_WARNING);
    }

    public boolean failed() {
        return this.equals(INCOMPLETE_ERROR) || this.equals(PREFLIGHT_ERROR) || this.equals(PRIOR_ERROR);
    }

    public boolean hasStarted() {
        return this.equals(PREFLIGHT_RUNNING) || this.equals(DEPLOYMENT_RUNNING) || this.equals(COMPLETE) || this.equals(COMPLETE_WARNING) || this.equals(INCOMPLETE_ABORT) || this.equals(INCOMPLETE_ERROR);
    }

    private StepStatus(String stringValue) {
        super(stringValue, FACTORY);
    }

    private StepStatus() {
    }

    public static class Factory
    extends EnumFactory {
        private static final StepStatus[] EMPTY_ARR = new StepStatus[0];

        private Factory() {
            super(9);
        }

        public StepStatus get(String value) throws NoSuchEnumException {
            return (StepStatus)this.getEnum(value);
        }

        public StepStatus get(int value) throws NoSuchEnumException {
            return (StepStatus)this.getEnum(value);
        }

        public StepStatus[] getAll() {
            return (StepStatus[])this.getAllEnums(EMPTY_ARR);
        }
    }
}

