/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.executor;

import com.raplix.rolloutexpress.event.ROXEvent;
import com.raplix.rolloutexpress.executor.MultiStepStatusQuery;
import com.raplix.rolloutexpress.executor.RunLevel;
import com.raplix.rolloutexpress.executor.StepID;
import com.raplix.rolloutexpress.executor.StepStatus;
import com.raplix.rolloutexpress.executor.StepStatusBean;
import com.raplix.rolloutexpress.executor.TaskID;
import com.raplix.rolloutexpress.executor.TaskInfo;
import com.raplix.rolloutexpress.executor.UnrecognizedStepException;
import com.raplix.rolloutexpress.executor.target.TargetID;
import com.raplix.rolloutexpress.net.rpc.CommandException;
import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.net.rpc.RPCSerializable;
import com.raplix.rolloutexpress.persist.HasObjectID;
import com.raplix.rolloutexpress.persist.PersistentObject;
import com.raplix.rolloutexpress.persist.ReEntrantTransaction;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.systemmodel.plandb.AggregateStep;
import com.raplix.rolloutexpress.systemmodel.plandb.ExecStep;
import com.raplix.rolloutexpress.systemmodel.plandb.ExecutionPlanID;
import com.raplix.rolloutexpress.systemmodel.plandb.LabeledStep;
import com.raplix.rolloutexpress.systemmodel.plandb.TargetVariableStep;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.Vector;

public class StepInfo
extends PersistentObject
implements RPCSerializable,
Comparable,
HasObjectID {
    private TaskID mTaskID;
    private TaskInfo mTaskInfo;
    private ExecutionPlanID mExecutionPlanID;
    private TargetID mTargetID;
    private int mStepMap;
    private int mHostStepMap;
    private int mStepType;
    private int mNestingLevel = 0;
    private boolean mMappable = true;
    private boolean mChildrenMappable = true;
    private RunLevel mRunLevel = RunLevel.PREFLIGHT;
    private StepStatus mStepStatus = StepStatus.NOT_STARTED;
    private boolean mSkipped = false;
    private int mTargetCount = 0;
    private int mHostsStarted = 0;
    private int mHostsCompleted = 0;
    private int mHostsFailed = 0;
    private Date mStartDate;
    private Date mCompleteDate;
    private String mDescription;
    private String mExceptionDescription;
    private int mSeverity;
    private int mSubstepCounter;
    private StepID mParentStepID;
    private boolean mMandatoryStep;
    private Vector mChildren;
    private transient int mChildSeverity = 0;
    private transient CommandException mChildException;
    private boolean mHandled;
    private String mLabel;
    public static final RunLevelStepmapHostStepmapComparator RUNLEVELSTEPMAPHOSTSTEPMAP_COMPARATOR = new RunLevelStepmapHostStepmapComparator();

    StepInfo() {
    }

    public StepInfo(StepID inStepID) throws PersistenceManagerException {
        this.setObjectID(inStepID);
        this.retrieve();
        TaskInfo taskInfo = new TaskInfo();
        taskInfo.setObjectID(this.getTaskID());
        taskInfo.retrieve();
        this.setTaskInfo(taskInfo);
    }

    public StepInfo(ExecStep inExecStep, TaskInfo inTaskInfo, ExecutionPlanID inExecutionPlanID, TargetID inTargetID, RunLevel inRunLevel) {
        this.setStepType(inExecStep.getStepType());
        this.setStepMap(inExecStep.getStepMap());
        this.setHostStepMap(inTaskInfo.assignHostStepMap(inTargetID, inRunLevel));
        this.setTargetID(inTargetID);
        this.setTaskInfo(inTaskInfo);
        this.setExecutionPlanID(inExecutionPlanID);
        this.setRunLevel(inRunLevel);
        if (inExecStep instanceof LabeledStep) {
            this.setLabel(((LabeledStep)((Object)inExecStep)).getLabel());
        }
    }

    public StepInfo(int inStepType, int inStepMap, TaskInfo inTaskInfo, ExecutionPlanID inExecutionPlanID, TargetID inTargetID, RunLevel inRunLevel) {
        this.setStepType(inStepType);
        this.setStepMap(inStepMap);
        this.setHostStepMap(inTaskInfo.assignHostStepMap(inTargetID, inRunLevel));
        this.setTargetID(inTargetID);
        this.setTaskInfo(inTaskInfo);
        this.setExecutionPlanID(inExecutionPlanID);
        this.setRunLevel(inRunLevel);
    }

    public StepInfo(int inStepType, StepInfo inParent) {
        this(inStepType, inParent.getStepMap(), inParent.getTaskInfo(), inParent.getExecutionPlanID(), inParent.getTargetID(), inParent.getRunLevel());
        inParent.addChild(this);
    }

    public StepInfo(int inStepType, StepInfo inParent, TargetID inTargetID) {
        this(inStepType, inParent.getStepMap(), inParent.getTaskInfo(), inParent.getExecutionPlanID(), inTargetID, inParent.getRunLevel());
        inParent.addChild(this);
        this.setHostStepMap(inParent.getTaskInfo().assignHostStepMap(inParent.getTargetID(), inParent.getRunLevel()));
    }

    public StepInfo(int inStepType, int inStepMap, StepInfo inParent) {
        this(inStepType, inStepMap, inParent.getTaskInfo(), inParent.getExecutionPlanID(), inParent.getTargetID(), inParent.getRunLevel());
        inParent.addChild(this);
    }

    public StepInfo(ExecStep inExecStep, StepInfo inParent) {
        this(inExecStep, inParent.getTaskInfo(), inParent.getExecutionPlanID(), inParent.getTargetID(), inParent.getRunLevel());
        inParent.addChild(this);
        if (this.getMappable()) {
            this.setStepMap(inExecStep.getStepMap());
        } else {
            this.setStepMap(inParent.getStepMap());
        }
    }

    public Date getStartDate() {
        return this.mStartDate;
    }

    public Date getCompleteDate() {
        return this.mCompleteDate;
    }

    public String getDescription() {
        return this.mDescription;
    }

    public String getExceptionDescription() {
        return this.mExceptionDescription;
    }

    public int getSeverity() {
        return this.mSeverity;
    }

    public StepID getStepID() {
        return (StepID)this.getObjectID();
    }

    public StepID getID() {
        return this.getStepID();
    }

    public TaskID getTaskID() {
        return this.mTaskID;
    }

    public ExecutionPlanID getExecutionPlanID() {
        return this.mExecutionPlanID;
    }

    public TargetID getTargetID() {
        return this.mTargetID;
    }

    public int getStepMap() {
        return this.mStepMap;
    }

    public int getHostStepMap() {
        return this.mHostStepMap;
    }

    public int getNestingLevel() {
        return this.mNestingLevel;
    }

    public int getStepType() {
        return this.mStepType;
    }

    public boolean getMappable() {
        return this.mMappable;
    }

    public StepID getParentStepID() {
        return this.mParentStepID;
    }

    public boolean getSkipped() {
        return this.mSkipped;
    }

    public void setSkipped(boolean inSkipped) {
        this.mSkipped = inSkipped;
    }

    public boolean equals(Object o) {
        if (!(o instanceof StepInfo)) {
            return false;
        }
        StepInfo otherStep = (StepInfo)o;
        if (this.getStepID() == null) {
            return otherStep.getStepID() == null;
        }
        return this.getStepID().equals(otherStep.getStepID());
    }

    public int compareTo(Object o) {
        if (null == o) {
            return 1;
        }
        if (!(o instanceof StepInfo)) {
            return 1;
        }
        StepInfo otherStep = (StepInfo)o;
        if (otherStep.getStepMap() == this.getStepMap()) {
            if (otherStep.getHostStepMap() == this.getHostStepMap()) {
                return 0;
            }
            return otherStep.getHostStepMap() < this.getHostStepMap() ? 1 : -1;
        }
        return otherStep.getStepMap() < this.getStepMap() ? 1 : -1;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        String stepDesc = Integer.toString(this.getStepType());
        try {
            stepDesc = ExecStep.getStepTypeStringRepresentation(this.getStepType());
        }
        catch (UnrecognizedStepException unrecognizedStepException) {
            // empty catch block
        }
        buf.append(this.getDescription()).append("|").append(this.getStepID()).append("|").append(this.getStepMap()).append("|").append(this.getHostStepMap());
        buf.append("|").append(this.getMappable()).append("|").append(this.getChildrenMappable()).append("|").append(this.getMandatoryStep()).append("|");
        buf.append(this.getTaskID()).append("|").append(this.getTargetID()).append("|").append(this.getRunLevel()).append("|");
        buf.append(stepDesc).append("|").append(this.getStepStatus());
        return buf.toString();
    }

    public StepStatus getStepStatus() {
        return this.mStepStatus;
    }

    public void setStepStatus(StepStatus inStepStatus) {
        if (null == inStepStatus) {
            throw new NullPointerException();
        }
        this.mStepStatus = inStepStatus;
    }

    public boolean stepFailed() {
        return null != this.getExceptionDescription();
    }

    public TaskInfo getTaskInfo() {
        return this.mTaskInfo;
    }

    public static StepInfo createStep(TaskInfo inTaskInfo, ExecutionPlanID inExecutionPlanID, int inStepType, int inStepMap, TargetID inTarget, RunLevel inRunLevel, int inTargetCount, String inDescription, boolean inMandatoryStep) throws PersistenceManagerException {
        StepInfo info = new StepInfo(inStepType, inStepMap, inTaskInfo, inExecutionPlanID, inTarget, inRunLevel);
        info.setTargetCount(inTargetCount);
        info.setMandatoryStep(inMandatoryStep);
        if (null != inDescription) {
            info.setDescription(inDescription);
        }
        info.save();
        inTaskInfo.addStep(info);
        return info;
    }

    public static StepInfo createStep(TaskInfo inTaskInfo, ExecutionPlanID inExecutionPlanID, int inStepType, int inStepMap, TargetID inTarget, RunLevel inRunLevel) throws PersistenceManagerException {
        return StepInfo.createStep(inTaskInfo, inExecutionPlanID, inStepType, inStepMap, inTarget, inRunLevel, 1, null, false);
    }

    public static StepInfo createStep(TaskInfo inTaskInfo, ExecutionPlanID inExecutionPlanID, ExecStep inExecStep, TargetID inTarget, RunLevel inRunLevel) throws PersistenceManagerException {
        return StepInfo.createStep(inTaskInfo, inExecutionPlanID, inExecStep, inTarget, inRunLevel, 1, false);
    }

    public static StepInfo createStep(TaskInfo inTaskInfo, ExecutionPlanID inExecutionPlanID, ExecStep inExecStep, TargetID inTarget, RunLevel inRunLevel, int inTargetCount, boolean inMandatoryStep) throws PersistenceManagerException {
        StepInfo info = new StepInfo(inExecStep, inTaskInfo, inExecutionPlanID, inTarget, inRunLevel);
        info.setTargetCount(inTargetCount);
        info.setMandatoryStep(inMandatoryStep);
        info.save();
        inTaskInfo.addStep(info);
        return info;
    }

    public static StepInfo createStep(int inStepType, StepInfo inParentStepInfo) throws PersistenceManagerException {
        return StepInfo.createStep(inStepType, inParentStepInfo, false);
    }

    public static StepInfo createStep(int inStepType, StepInfo inParentStepInfo, boolean inMandatoryStep) throws PersistenceManagerException {
        StepInfo info = new StepInfo(inStepType, inParentStepInfo);
        info.save();
        info.setMandatoryStep(inMandatoryStep);
        inParentStepInfo.getTaskInfo().addStep(info);
        return info;
    }

    public static StepInfo createStep(int inStepType, int inStepMap, StepInfo inParentStepInfo) throws PersistenceManagerException {
        return StepInfo.createStep(inStepType, inStepMap, inParentStepInfo, null, false);
    }

    public static StepInfo createStep(int inStepType, int inStepMap, StepInfo inParentStepInfo, String inDescription, boolean inMandatoryStep) throws PersistenceManagerException {
        StepInfo info = new StepInfo(inStepType, inStepMap, inParentStepInfo);
        if (null != inDescription) {
            info.setDescription(inDescription);
        }
        info.setMandatoryStep(inMandatoryStep);
        info.save();
        inParentStepInfo.getTaskInfo().addStep(info);
        return info;
    }

    public static StepInfo createStep(ExecStep inExecStep, StepInfo inParentStepInfo, boolean inMandatoryStep) throws PersistenceManagerException {
        StepInfo info = new StepInfo(inExecStep, inParentStepInfo);
        info.setMandatoryStep(inMandatoryStep);
        info.save();
        inParentStepInfo.getTaskInfo().addStep(info);
        return info;
    }

    public static StepInfo createStep(ExecStep inExecStep, StepInfo inParentStepInfo, TargetID inTargetID) throws PersistenceManagerException {
        StepInfo info = new StepInfo(inExecStep, inParentStepInfo);
        info.setTargetID(inTargetID);
        info.save();
        inParentStepInfo.getTaskInfo().addStep(info);
        return info;
    }

    public void save() throws PersistenceManagerException {
        StepInfo.retryOnDeadlock(new ReEntrantSave(this));
    }

    protected void addChild(StepInfo inStep) {
        inStep.setTaskInfo(this.getTaskInfo());
        inStep.setExecutionPlanID(this.getExecutionPlanID());
        inStep.setMappable(this.getChildrenMappable());
        inStep.setNestingLevel(this.getNestingLevel() + 1);
        if (inStep.getMappable()) {
            inStep.setTargetCount(this.getTargetCount());
        } else {
            inStep.setTargetCount(1);
        }
        inStep.setParentStepID(this.getStepID());
    }

    protected void setExecStep(ExecStep inExecStep) {
        if (null == inExecStep) {
            throw new NullPointerException();
        }
        int stepType = inExecStep.getStepType();
        this.setStepType(stepType);
    }

    public void setStepMap(int inStepMap) {
        this.mStepMap = inStepMap;
    }

    public void setHostStepMap(int inHostStepMap) {
        this.mHostStepMap = inHostStepMap;
    }

    protected void setNestingLevel(int inNestingLevel) {
        this.mNestingLevel = inNestingLevel;
    }

    public void setChildrenMappable(boolean inChildrenMappable) {
        this.mChildrenMappable = inChildrenMappable;
    }

    public boolean getChildrenMappable() {
        return this.mChildrenMappable;
    }

    protected void setMappable(boolean inMappable) {
        this.mMappable = inMappable;
        if (!this.mMappable) {
            this.setChildrenMappable(false);
        }
    }

    void setTaskID(TaskID inTaskID) {
        if (null == inTaskID) {
            throw new NullPointerException();
        }
        this.mTaskID = inTaskID;
    }

    void setTaskInfo(TaskInfo inTaskInfo) {
        if (null == inTaskInfo) {
            throw new NullPointerException();
        }
        this.mTaskInfo = inTaskInfo;
        this.setTaskID(this.mTaskInfo.getTaskID());
    }

    public void setExecutionPlanID(ExecutionPlanID inExecutionPlanID) {
        if (null == inExecutionPlanID) {
            throw new NullPointerException();
        }
        this.mExecutionPlanID = inExecutionPlanID;
    }

    private void setTargetID(TargetID inTargetID) {
        if (inTargetID == null) {
            throw new NullPointerException();
        }
        this.mTargetID = inTargetID;
    }

    void setStepType(int inStepType) {
        this.mStepType = inStepType;
        this.setChildrenMappable(!this.isDynamicStep());
    }

    private boolean isDynamicStep() {
        Class stepTypeClass = ExecStep.getStepClassForType(this.getStepType());
        if (null == stepTypeClass) {
            return false;
        }
        return TargetVariableStep.class.isAssignableFrom(stepTypeClass);
    }

    public boolean canHaveChildren() {
        Class stepTypeClass = ExecStep.getStepClassForType(this.getStepType());
        if (null == stepTypeClass) {
            return false;
        }
        return AggregateStep.class.isAssignableFrom(stepTypeClass);
    }

    private void setStepStatusAsString(String inStepStatus) {
        this.mStepStatus = StepStatus.FACTORY.get(inStepStatus);
    }

    private String getStepStatusAsString() {
        return this.mStepStatus.toString();
    }

    protected void setParentStepID(StepID inStepID) {
        this.mParentStepID = inStepID;
    }

    void setRunLevel(RunLevel inRunLevel) {
        this.mRunLevel = inRunLevel;
    }

    public RunLevel getRunLevel() {
        return this.mRunLevel;
    }

    private void setRunLevelAsString(String inRunLevel) {
        this.mRunLevel = RunLevel.FACTORY.get(inRunLevel);
    }

    private String getRunLevelAsString() {
        return this.mRunLevel.toString();
    }

    public int getHostsStarted() {
        return this.mHostsStarted;
    }

    public int getHostsCompleted() {
        return this.mHostsCompleted;
    }

    public int getHostsFailed() {
        return this.mHostsFailed;
    }

    public int getTargetCount() {
        return this.mTargetCount;
    }

    public void setHostsStarted(int inHostsStarted) {
        this.mHostsStarted = inHostsStarted;
    }

    public void setHostsCompleted(int inHostsCompleted) {
        this.mHostsCompleted = inHostsCompleted;
    }

    public void setHostsFailed(int inHostsFailed) {
        this.mHostsFailed = inHostsFailed;
    }

    void setTargetCount(int inTargetCount) {
        this.mTargetCount = inTargetCount;
    }

    public void setStartDate(Date inStartDate) {
        this.mStartDate = inStartDate;
    }

    public void setCompleteDate(Date inCompleteDate) {
        this.mCompleteDate = inCompleteDate;
    }

    public void setDescription(String inDescription) {
        this.mDescription = inDescription;
    }

    public void setExceptionDescription(String inExceptionDescription) {
        this.mExceptionDescription = inExceptionDescription;
    }

    public void setSeverity(int inSeverity) {
        this.mSeverity = inSeverity;
    }

    int assignSubstepCounter() {
        this.mSubstepCounter = this.mSubstepCounter == 0 ? this.getStepMap() + 10 : (this.mSubstepCounter += 10);
        return this.mSubstepCounter;
    }

    public Collection getChildren() throws PersistenceManagerException, RPCException {
        return this.getChildren(false);
    }

    public Collection getChildren(boolean inRefresh) throws PersistenceManagerException, RPCException {
        if (inRefresh || this.mChildren == null) {
            MultiStepStatusQuery mssq = MultiStepStatusQuery.childrenOfThisStep(this.getStepID());
            StepStatusBean[] results = mssq.select();
            if (null == this.mChildren) {
                this.mChildren = new Vector();
            } else {
                this.mChildren.clear();
            }
            if (null != results) {
                for (int index = 0; index < results.length; ++index) {
                    StepInfo info = results[index].getStepInfo();
                    info.setTaskInfo(this.getTaskInfo());
                    this.mChildren.add(info);
                }
            }
        }
        return this.mChildren;
    }

    public StepInfo[] getChildSteps() throws PersistenceManagerException, RPCException {
        return this.getChildSteps(false);
    }

    public StepInfo[] getChildSteps(boolean inRefresh) throws PersistenceManagerException, RPCException {
        return this.getChildren(inRefresh).toArray(new StepInfo[0]);
    }

    public void sanitize() {
        this.setObjectID(null);
        this.mTargetID = null;
        this.mHostStepMap = -1;
        this.mStartDate = null;
        this.mCompleteDate = null;
        this.mParentStepID = null;
        this.mChildren = null;
    }

    public void setChildSeverity(int inChildSeverity, CommandException inException) {
        this.mChildSeverity = ROXEvent.chooseSeverity(this.mChildSeverity, inChildSeverity);
        if (this.mChildSeverity == inChildSeverity) {
            this.mChildException = inException;
        }
    }

    public CommandException getChildException() {
        return this.mChildException;
    }

    public int getChildSeverity() {
        return this.mChildSeverity;
    }

    public void setCountersFromStatus() {
        StepStatus status = this.getStepStatus();
        if (status.equals(StepStatus.NOT_STARTED)) {
            this.setHostsStarted(0);
            this.setHostsCompleted(0);
            this.setHostsFailed(0);
        }
        if (status.equals(StepStatus.PREFLIGHT_RUNNING) || status.equals(StepStatus.DEPLOYMENT_RUNNING)) {
            this.setHostsStarted(1);
            this.setHostsCompleted(0);
            this.setHostsFailed(0);
        }
        if (status.equals(StepStatus.COMPLETE) || status.equals(StepStatus.COMPLETE_WARNING)) {
            this.setHostsStarted(1);
            this.setHostsCompleted(1);
            this.setHostsFailed(0);
        }
        if (status.equals(StepStatus.INCOMPLETE_ERROR)) {
            this.setHostsStarted(1);
            this.setHostsCompleted(0);
            this.setHostsFailed(1);
        }
        if (status.equals(StepStatus.PREFLIGHT_ERROR) || status.equals(StepStatus.PRIOR_ERROR)) {
            this.setHostsStarted(0);
            this.setHostsCompleted(0);
            this.setHostsFailed(1);
        }
    }

    public boolean getMandatoryStep() {
        return this.mMandatoryStep;
    }

    public void setMandatoryStep(boolean inMandatoryStep) {
        this.mMandatoryStep = inMandatoryStep;
    }

    public boolean getHandled() {
        return this.mHandled;
    }

    public void setHandled(boolean inHandled) {
        this.mHandled = inHandled;
    }

    public String getLabel() {
        return this.mLabel;
    }

    private void setLabel(String inLabel) {
        this.mLabel = inLabel;
    }

    public static class RunLevelStepmapHostStepmapComparator
    implements Comparator {
        public boolean equals(Object o) {
            return o instanceof RunLevelStepmapHostStepmapComparator;
        }

        public int compare(Object lhs, Object rhs) {
            StepInfo left = (StepInfo)lhs;
            StepInfo right = (StepInfo)rhs;
            RunLevel leftRL = left.getRunLevel();
            RunLevel rightRL = right.getRunLevel();
            int leftMap = left.getStepMap();
            int rightMap = right.getStepMap();
            int leftHostMap = left.getHostStepMap();
            int rightHostMap = right.getHostStepMap();
            if (!leftRL.equals(rightRL)) {
                return leftRL.equals(RunLevel.PREFLIGHT) ? -1 : 1;
            }
            if (leftMap != rightMap) {
                return leftMap < rightMap ? -1 : 1;
            }
            if (leftHostMap != rightHostMap) {
                return leftHostMap < rightHostMap ? -1 : 1;
            }
            return 0;
        }
    }

    public static class StepInfoKey {
        private TaskID mTaskID;
        private ExecutionPlanID mPlanID;
        private TargetID mTargetID;
        private int mStepMap;
        private int mStepType;
        private RunLevel mRunLevel;

        public StepInfoKey(TaskID inTaskID, ExecutionPlanID inPlanID, TargetID inTargetID, int inStepMap, int inStepType, RunLevel inRunLevel) {
            this.mTaskID = inTaskID;
            this.mPlanID = inPlanID;
            this.mTargetID = inTargetID;
            this.mStepMap = inStepMap;
            this.mStepType = inStepType;
            this.mRunLevel = inRunLevel;
        }

        public TaskID getTaskID() {
            return this.mTaskID;
        }

        public ExecutionPlanID getPlanID() {
            return this.mPlanID;
        }

        public TargetID getTargetID() {
            return this.mTargetID;
        }

        public int getStepMap() {
            return this.mStepMap;
        }

        public int getStepType() {
            return this.mStepType;
        }

        public RunLevel getRunLevel() {
            return this.mRunLevel;
        }

        public boolean equalsBean(StepStatusBean bean) {
            return bean.getStepInfo().getTaskID().equals(this.mTaskID) && bean.getStepInfo().getExecutionPlanID().equals(this.mPlanID) && bean.getStepInfo().getTargetID().equals(this.mTargetID) && bean.getStepInfo().getStepMap() == this.mStepMap && bean.getStepInfo().getStepType() == this.mStepType && bean.getStepInfo().getRunLevel().equals(this.mRunLevel);
        }

        public String toString() {
            StringBuffer out = new StringBuffer();
            out.append("\n").append("TaskID | PlanID | TargetID | StepMap | StepType | RunLevel").append("\n");
            String stepDesc = Integer.toString(this.mStepType);
            try {
                stepDesc = ExecStep.getStepTypeStringRepresentation(this.mStepType);
            }
            catch (UnrecognizedStepException unrecognizedStepException) {
                // empty catch block
            }
            out.append(this.mTaskID).append("|").append(this.mPlanID).append("|").append(this.mTargetID).append("|").append(this.mStepMap).append("|").append(stepDesc).append("|").append(this.mRunLevel).append("\n");
            return out.toString();
        }
    }

    private static class ReEntrantSave
    implements ReEntrantTransaction {
        private StepInfo mInfo;

        ReEntrantSave(StepInfo info) {
            this.mInfo = info;
        }

        public Object execute() throws PersistenceManagerException {
            this.mInfo.safeSaveMS(null);
            return null;
        }
    }
}

