/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.executor;

import com.raplix.rolloutexpress.executor.StepID;
import com.raplix.rolloutexpress.executor.StepInfo;
import com.raplix.rolloutexpress.executor.TaskID;
import com.raplix.rolloutexpress.executor.query.MultiStepInfoQuery;
import com.raplix.rolloutexpress.executor.query.SingleStepInfoQuery;
import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.net.rpc.RPCSerializable;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostID;

public final class StepDescriptionContainer
implements RPCSerializable {
    private TaskID mTaskID;
    private HostID mHostID;
    private String mLabel;
    private StepID mStepID;
    private boolean mUsingStepID;

    public StepDescriptionContainer(TaskID inTaskID, HostID inHostID, String inLabel) {
        this.mTaskID = inTaskID;
        this.mHostID = inHostID;
        this.mLabel = inLabel;
        this.mUsingStepID = false;
    }

    public StepDescriptionContainer(StepID inStepID) {
        this.mStepID = inStepID;
        this.mUsingStepID = true;
    }

    protected StepDescriptionContainer() {
    }

    StepID getStepID() {
        return this.mStepID;
    }

    TaskID getTaskID() {
        return this.mTaskID;
    }

    HostID getHostID() {
        return this.mHostID;
    }

    String getLabel() {
        return this.mLabel;
    }

    StepInfo[] resolve() throws RPCException, PersistenceManagerException {
        if (this.mUsingStepID) {
            return new StepInfo[]{SingleStepInfoQuery.byID(this.mStepID).select()};
        }
        return MultiStepInfoQuery.byLabel(this.mTaskID, this.mHostID, this.mLabel).select();
    }
}

