/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.executor;

import com.raplix.rolloutexpress.executor.CompiledPlan;
import com.raplix.rolloutexpress.executor.CompiledPlanTraverser;
import com.raplix.rolloutexpress.executor.CompiledSimpleSubplan;
import com.raplix.rolloutexpress.executor.ComponentInstallData;
import com.raplix.rolloutexpress.executor.ComponentsInstallDataList;
import com.raplix.rolloutexpress.executor.PlanExecutionException;
import com.raplix.rolloutexpress.executor.PlanExecutorMessages;
import com.raplix.rolloutexpress.executor.RunLevel;
import com.raplix.rolloutexpress.executor.StepInfo;
import com.raplix.rolloutexpress.executor.SubplanInfo;
import com.raplix.rolloutexpress.executor.TaskInfo;
import com.raplix.rolloutexpress.executor.target.Target;
import com.raplix.rolloutexpress.executor.task.DynamicContainerStep;
import com.raplix.rolloutexpress.executor.task.TaskExecutor;
import com.raplix.rolloutexpress.message.ROXMessage;
import com.raplix.rolloutexpress.message.ROXMessageManager;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.systemmodel.componentdb.CallSpec;
import com.raplix.rolloutexpress.systemmodel.componentdb.Component;
import com.raplix.rolloutexpress.systemmodel.componentdb.InstallBlock;
import com.raplix.rolloutexpress.systemmodel.plandb.ExecStep;
import com.raplix.rolloutexpress.systemmodel.plandb.ExecutionPlanID;
import com.raplix.rolloutexpress.systemmodel.plandb.IfStep;
import com.raplix.rolloutexpress.systemmodel.plandb.InstallChildNotMappable;
import com.raplix.rolloutexpress.systemmodel.plandb.InstallStep;
import com.raplix.rolloutexpress.systemmodel.plandb.RetargetStep;
import com.raplix.rolloutexpress.systemmodel.plandb.TryStep;
import java.util.Hashtable;

public class StepCreationTraverser
implements CompiledPlanTraverser,
PlanExecutorMessages {
    private TaskInfo mTaskInfo;
    private int mStepCounter = 10;
    private Target[] mTargets;
    private ComponentsInstallDataList mComponentsInstallDataList;
    private int mInstallCounter;
    private Hashtable mTargetsSeen = new Hashtable();
    private SubplanInfo[] mSubplanInfos;

    public StepCreationTraverser(TaskInfo inTaskInfo) throws PlanExecutionException {
        this.mTaskInfo = inTaskInfo;
        this.mSubplanInfos = this.mTaskInfo.getSubplanInfos();
    }

    public void subplanEntered(CompiledSimpleSubplan inSubplan, CompiledPlan inPlan) throws PlanExecutionException {
        this.mInstallCounter = 0;
        SubplanInfo subplanInfo = this.mSubplanInfos[inSubplan.getSubplanIndex()];
        this.mTargets = subplanInfo.getTargets();
        this.mComponentsInstallDataList = this.mTaskInfo.getInstallData(subplanInfo);
        for (int index = 0; index < this.mTargets.length; ++index) {
            this.mTargetsSeen.put(this.mTargets[index].getID(), this.mTargets[index]);
        }
        int acquireHostMapStart = 0;
        if (null != inSubplan.getInvokingStep()) {
            if (inSubplan.getInvokingStep().getStepMap() == -1) {
                inSubplan.getInvokingStep().setStepMap(this.assignStepCounter());
            }
            acquireHostMapStart = inSubplan.getInvokingStep().getStepMap();
        }
        this.createAcquireHostSteps(acquireHostMapStart, inSubplan.getExecutionPlan().getID());
    }

    public void stepEncountered(int inStepNum, ExecStep inStep, CompiledSimpleSubplan inSubplan, CompiledPlan inPlan) throws PlanExecutionException {
        try {
            this.performWorkForStep(inStepNum, inStep, null == inSubplan.getInvokingStep() ? -1 : inSubplan.getInvokingStep().getStepMap(), inSubplan, inPlan, true, true);
        }
        catch (Exception e) {
            throw new PlanExecutionException(e);
        }
    }

    protected void performWorkForStep(int inStepNum, ExecStep inStep, int inParentStepMap, CompiledSimpleSubplan inSubplan, CompiledPlan inPlan, boolean inExploreInstallSteps, boolean inWriteSteps) throws PlanExecutionException, PersistenceManagerException {
        if (inWriteSteps) {
            inStep.setStepMap(this.assignStepCounter());
            this.createSteps(inStep, inSubplan.getSubplanPlanID(), inParentStepMap, false);
        }
        switch (inStep.getStepType()) {
            case 105: {
                if (!inExploreInstallSteps) break;
                this.handleInstallStep(inStepNum, (InstallStep)inStep, inSubplan, inPlan, inWriteSteps);
                break;
            }
            case 127: {
                this.handleIfStep(inStepNum, inStep, inSubplan, inPlan, inExploreInstallSteps, inWriteSteps);
                break;
            }
            case 125: {
                this.handleTryStep(inStepNum, inStep, inSubplan, inPlan, inExploreInstallSteps, inWriteSteps);
                break;
            }
            case 128: {
                this.handleRetargetStep(inStepNum, inStep, inSubplan, inPlan, inExploreInstallSteps, false);
            }
        }
    }

    protected void handleRetargetStep(int inStepNum, ExecStep inStep, CompiledSimpleSubplan inSubplan, CompiledPlan inPlan, boolean inExploreInstallSteps, boolean inWriteSteps) throws PlanExecutionException, PersistenceManagerException {
        RetargetStep parentStep = (RetargetStep)inStep;
        this.processSubSteps(parentStep.getSteps(), parentStep, inExploreInstallSteps, inStepNum, inSubplan, inPlan, inWriteSteps);
    }

    protected void processSubSteps(ExecStep[] inSteps, ExecStep inParentStep, boolean inExploreInstallSteps, int inStepNum, CompiledSimpleSubplan inSubplan, CompiledPlan inPlan, boolean inWriteSteps) throws PlanExecutionException, PersistenceManagerException {
        if (inSteps != null) {
            for (int i = 0; i < inSteps.length; ++i) {
                this.performWorkForStep(inStepNum, inSteps[i], inParentStep.getStepMap(), inSubplan, inPlan, inExploreInstallSteps, inWriteSteps);
            }
        }
    }

    protected void handleTryStep(int inStepNum, ExecStep inStep, CompiledSimpleSubplan inSubplan, CompiledPlan inPlan, boolean inExploreInstallSteps, boolean inWriteSteps) throws PlanExecutionException, PersistenceManagerException {
        TryStep parentStep = (TryStep)inStep;
        this.processSubSteps(parentStep.getTrySteps(), parentStep, inExploreInstallSteps, inStepNum, inSubplan, inPlan, false);
        this.processSubSteps(parentStep.getCatchSteps(), parentStep, inExploreInstallSteps, inStepNum, inSubplan, inPlan, false);
        this.processSubSteps(parentStep.getFinallySteps(), parentStep, inExploreInstallSteps, inStepNum, inSubplan, inPlan, false);
    }

    protected void handleIfStep(int inStepNum, ExecStep inStep, CompiledSimpleSubplan inSubplan, CompiledPlan inPlan, boolean inExploreInstallSteps, boolean inWriteSteps) throws PlanExecutionException, PersistenceManagerException {
        ExecStep[] elseSteps;
        IfStep parentStep = (IfStep)inStep;
        ExecStep[] thenSteps = parentStep.getThenSteps();
        if (thenSteps != null) {
            DynamicContainerStep thenStep = new DynamicContainerStep(parentStep.getThenSteps(), new ROXMessage("pe.step.IF_THEN"));
            this.performWorkForStep(inStepNum, thenStep, parentStep.getStepMap(), inSubplan, inPlan, false, false);
            this.processSubSteps(thenSteps, parentStep, inExploreInstallSteps, inStepNum, inSubplan, inPlan, false);
        }
        if ((elseSteps = parentStep.getElseSteps()) != null) {
            DynamicContainerStep elseStep = new DynamicContainerStep(parentStep.getElseSteps(), new ROXMessage("pe.step.IF_ELSE"));
            this.performWorkForStep(inStepNum, elseStep, parentStep.getStepMap(), inSubplan, inPlan, false, false);
            this.processSubSteps(elseSteps, parentStep, inExploreInstallSteps, inStepNum, inSubplan, inPlan, false);
        }
    }

    protected void handleInstallStep(int inStepNum, InstallStep inStep, CompiledSimpleSubplan inSubplan, CompiledPlan inPlan, boolean inWriteSteps) throws PlanExecutionException, PersistenceManagerException {
        ComponentInstallData theInstallData = this.mComponentsInstallDataList.getComponentInstallData(this.mInstallCounter++);
        inStep.setClientData(theInstallData);
        Component theComponent = theInstallData.getComponent();
        String blockName = inStep.getBlockName();
        CallSpec callSpec = new CallSpec(inSubplan.getExecutionPlan().toCaller(), null);
        InstallBlock theNamedBlock = theComponent.resolveInstallBlock(blockName, callSpec);
        if (theNamedBlock == null) {
            throw new PlanExecutionException("pe.NO_BLOCK_DEFINED", (Object[])new String[]{blockName});
        }
        ExecStep[] subSteps = theNamedBlock.getExecSteps();
        if (null != subSteps) {
            this.processSubSteps(subSteps, inStep, false, inStepNum, inSubplan, inPlan, inWriteSteps);
            for (int j = 0; j < subSteps.length; ++j) {
                if (!(subSteps[j] instanceof InstallChildNotMappable)) continue;
                StepInfo[] steps = this.mTaskInfo.findSteps(subSteps[j].getStepMap());
                for (int i = 0; i < steps.length; ++i) {
                    StepInfo step = steps[i];
                    step.setChildrenMappable(false);
                }
            }
        }
        theNamedBlock.getDeclaringComponent().addLocalInstallBlock(theNamedBlock);
    }

    private void createSteps(ExecStep inStep, ExecutionPlanID inPlanID, int inParentStepMap, boolean inMandatoryStep) throws PlanExecutionException, PersistenceManagerException {
        this.createSteps(inStep, inPlanID, inParentStepMap, inMandatoryStep, RunLevel.PREFLIGHT);
        this.createSteps(inStep, inPlanID, inParentStepMap, inMandatoryStep, RunLevel.ACTUAL);
    }

    private void createSteps(ExecStep inStep, ExecutionPlanID inPlanID, int inParentStepMap, boolean inMandatoryStep, RunLevel inRunLevel) throws PlanExecutionException, PersistenceManagerException {
        if (inRunLevel.equals(RunLevel.PREFLIGHT) || inRunLevel.equals(RunLevel.ACTUAL) && this.mTaskInfo.getRunLevel().equals(RunLevel.ACTUAL)) {
            for (int index = 0; index < this.mTargets.length; ++index) {
                StepInfo newStep = null;
                StepInfo parentStep = null;
                if (inParentStepMap != -1) {
                    parentStep = this.mTaskInfo.findStep(inParentStepMap, this.mTargets[index].getID(), inRunLevel);
                }
                newStep = null == parentStep ? StepInfo.createStep(this.mTaskInfo, inPlanID, inStep, this.mTargets[index].getID(), inRunLevel, this.mTargets.length, inMandatoryStep) : StepInfo.createStep(inStep, parentStep, inMandatoryStep);
            }
        }
    }

    private void createAcquireHostSteps(int starting, ExecutionPlanID inPlanID) throws PlanExecutionException {
        int stepMap = starting + 3;
        for (int i = 0; i < this.mTargets.length; ++i) {
            String msg = ROXMessageManager.messageAsString("pe.step.ACQUIRE_HOST");
            try {
                StepInfo.createStep(this.mTaskInfo, inPlanID, 135, stepMap, this.mTargets[i].getID(), RunLevel.PREFLIGHT, this.mTargets.length, msg, true);
                if (TaskExecutor.isPreflightRunLevel(this.mTaskInfo.getRunLevel())) continue;
                StepInfo.createStep(this.mTaskInfo, inPlanID, 135, stepMap, this.mTargets[i].getID(), RunLevel.ACTUAL, this.mTargets.length, msg, true);
                continue;
            }
            catch (PersistenceManagerException ex) {
                throw new PlanExecutionException(ex);
            }
        }
    }

    public void subplanExited(CompiledSimpleSubplan inSubplan, CompiledPlan inPlan) throws PlanExecutionException {
    }

    public Object getResults() {
        return null;
    }

    private int assignStepCounter() {
        int currentCounter = this.mStepCounter;
        this.mStepCounter += 10;
        return currentCounter;
    }
}

