/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.executor;

import [Lcom.raplix.rolloutexpress.systemmodel.componentdb.ComponentSelector;;
import com.raplix.rolloutexpress.executor.CompiledPlan;
import com.raplix.rolloutexpress.executor.CompiledSimpleSubplan;
import com.raplix.rolloutexpress.executor.InstallStepGathererTraverser;
import com.raplix.rolloutexpress.executor.PlanExecutionException;
import com.raplix.rolloutexpress.executor.SubplanPrompt;
import com.raplix.rolloutexpress.message.ROXMessage;
import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentRef;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentSelector;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentSelectorManager;
import com.raplix.rolloutexpress.systemmodel.plandb.Caller;
import com.raplix.rolloutexpress.systemmodel.plandb.InstallStep;
import com.raplix.rolloutexpress.systemmodel.plandb.OverrideRepoComponentTargeter;
import com.raplix.rolloutexpress.systemmodel.plandb.RepoComponentTargeter;
import com.raplix.util.collections.CollectionUtil;
import com.raplix.util.logger.Logger;
import java.util.Vector;

public class PromptCollectorCompiledPlanTraverser
extends InstallStepGathererTraverser {
    private SubplanPrompt[] mSubplanPrompts;
    private Vector mCurrCompSelectors;
    private ComponentSelectorManager mCompSelMgr;

    public SubplanPrompt[] getPrompts() {
        return this.mSubplanPrompts;
    }

    public Object getResults() {
        return this.getPrompts();
    }

    public PromptCollectorCompiledPlanTraverser(CompiledPlan inPlan) {
        this.mSubplanPrompts = new SubplanPrompt[inPlan.getNumSimpleSubplans()];
        this.mCompSelMgr = new ComponentSelectorManager();
    }

    public void subplanEntered(CompiledSimpleSubplan inSubplan, CompiledPlan inPlan) {
        this.mCurrCompSelectors = new Vector();
    }

    public void subplanExited(CompiledSimpleSubplan inSubplan, CompiledPlan inPlan) {
        ComponentSelector[] theCompSelectorsArray = (ComponentSelector[])CollectionUtil.mapClass(this.mCurrCompSelectors, ComponentSelector;.class);
        this.mSubplanPrompts[inSubplan.getSubplanIndex()] = new SubplanPrompt(inSubplan, theCompSelectorsArray);
    }

    protected void handleInstallStep(InstallStep inInstallStep, int inStepNum, CompiledSimpleSubplan inSubplan, CompiledPlan inPlan) throws PlanExecutionException {
        RepoComponentTargeter targeter = inInstallStep.getTargeter();
        if (!(targeter instanceof OverrideRepoComponentTargeter)) {
            throw new PlanExecutionException(new ROXMessage("pe.PLAN_INSTALL_WRONG_TARGET", inSubplan.getName()));
        }
        try {
            Caller caller = inSubplan.getExecutionPlan().toCaller();
            ComponentRef compRef = ((OverrideRepoComponentTargeter)targeter).getTargetComponentRef(caller);
            this.mCurrCompSelectors.add(this.mCompSelMgr.getComponentSelector(compRef));
            if (Logger.isDebugEnabled(this)) {
                Logger.debug("Added compSelector for " + compRef.getComponentName(), this);
            }
        }
        catch (PersistenceManagerException e) {
            throw new PlanExecutionException(e);
        }
        catch (RPCException e) {
            throw new PlanExecutionException(e);
        }
    }
}

