/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.executor;

import com.raplix.rolloutexpress.config.TargetedConfigContext;
import com.raplix.rolloutexpress.executor.ExecutionState;
import com.raplix.rolloutexpress.executor.PlanExecutionException;
import com.raplix.rolloutexpress.executor.TaskInfo;
import com.raplix.rolloutexpress.executor.target.HostResolver;
import com.raplix.rolloutexpress.executor.virtual.VirtualAgent;
import com.raplix.rolloutexpress.net.rpc.CommandException;
import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.systemmodel.hostdbx.Host;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostID;
import com.raplix.util.logger.Logger;

public class PlanTargetedConfigContext
extends TargetedConfigContext {
    private TaskInfo mTaskInfo;
    private Host mCurTargetHost;

    public PlanTargetedConfigContext(VirtualAgent inAgent, ExecutionState inState) throws PlanExecutionException {
        this(inAgent.getTarget().getCurrentHostID(), inState.getTaskInfo());
    }

    public PlanTargetedConfigContext(HostID inTargetHost, TaskInfo inTaskInfo) throws PlanExecutionException {
        super(PlanTargetedConfigContext.resolveHost(inTargetHost, inTaskInfo.getHostResolver()));
        this.mTaskInfo = inTaskInfo;
        this.setTargetHost(super.getTargetHost());
    }

    public Host getHost(String hostName) throws PersistenceManagerException, RPCException {
        return this.mTaskInfo.getHostResolver().getHost(hostName);
    }

    public Host getHost(HostID hostID) throws PersistenceManagerException, RPCException {
        return this.mTaskInfo.getHostResolver().getHost(hostID);
    }

    public Host getTargetHost() {
        Host theHost = (Host)this.mCurTargetHost.clone();
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("targetHost is " + theHost.getName(), this);
        }
        return theHost;
    }

    public void setTargetHost(Host inHost) {
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("Resetting targetHost to " + inHost.getName(), this);
        }
        this.mCurTargetHost = inHost;
    }

    private static Host resolveHost(HostID inHostID, HostResolver inResolver) throws PlanExecutionException {
        try {
            return inResolver.getHost(inHostID);
        }
        catch (CommandException ex) {
            throw new PlanExecutionException(ex);
        }
    }
}

