/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.executor;

import com.raplix.rolloutexpress.Application;
import com.raplix.rolloutexpress.CannotEnforceException;
import com.raplix.rolloutexpress.ConfigurationException;
import com.raplix.rolloutexpress.ConsistencyEnforcer;
import com.raplix.rolloutexpress.DefaultConfiguration;
import com.raplix.rolloutexpress.InconsistencyFixException;
import com.raplix.rolloutexpress.RaplixException;
import com.raplix.rolloutexpress.Subsystem;
import com.raplix.rolloutexpress.SubsystemID;
import com.raplix.rolloutexpress.UnsupportedSubsystemException;
import com.raplix.rolloutexpress.command.exceptions.CommandExecutionErrorException;
import com.raplix.rolloutexpress.command.rpcinterfaces.NativePlatformIntegrationInterface;
import com.raplix.rolloutexpress.config.ConfigGenManager;
import com.raplix.rolloutexpress.config.ConfigGenerator;
import com.raplix.rolloutexpress.event.EmptyQueryException;
import com.raplix.rolloutexpress.event.NotificationManager;
import com.raplix.rolloutexpress.event.NotificationManagerException;
import com.raplix.rolloutexpress.event.ROXEvent;
import com.raplix.rolloutexpress.event.ROXStepEvent;
import com.raplix.rolloutexpress.event.ROXStepStartEvent;
import com.raplix.rolloutexpress.event.ROXTaskEvent;
import com.raplix.rolloutexpress.event.TargetStatus;
import com.raplix.rolloutexpress.event.TargetStatusTable;
import com.raplix.rolloutexpress.event.query.MultiEventQuery;
import com.raplix.rolloutexpress.event.query.MultiTargetStatusQuery;
import com.raplix.rolloutexpress.event.query.bean.RunningPlanBean;
import com.raplix.rolloutexpress.executor.CompiledPlan;
import com.raplix.rolloutexpress.executor.CompiledPlanExecutor;
import com.raplix.rolloutexpress.executor.CompiledSimpleSubplan;
import com.raplix.rolloutexpress.executor.ExecutionState;
import com.raplix.rolloutexpress.executor.HostData;
import com.raplix.rolloutexpress.executor.InvalidExecStepTypeException;
import com.raplix.rolloutexpress.executor.MalformedStepDescriptionException;
import com.raplix.rolloutexpress.executor.MultiStepStatusQuery;
import com.raplix.rolloutexpress.executor.NoOutputForExecStepException;
import com.raplix.rolloutexpress.executor.NoSuchTaskException;
import com.raplix.rolloutexpress.executor.NoTracePlanRecorder;
import com.raplix.rolloutexpress.executor.NonPlanExecutionRunner;
import com.raplix.rolloutexpress.executor.PlanAutoGenerator;
import com.raplix.rolloutexpress.executor.PlanCompiler;
import com.raplix.rolloutexpress.executor.PlanExecutionException;
import com.raplix.rolloutexpress.executor.PlanExecutionRunner;
import com.raplix.rolloutexpress.executor.PlanExecutorMessages;
import com.raplix.rolloutexpress.executor.PlanInterface;
import com.raplix.rolloutexpress.executor.PlanPermissionException;
import com.raplix.rolloutexpress.executor.PlanPreprocessor;
import com.raplix.rolloutexpress.executor.PlanTargetedConfigContext;
import com.raplix.rolloutexpress.executor.PromptCollectorCompiledPlanTraverser;
import com.raplix.rolloutexpress.executor.RunLevel;
import com.raplix.rolloutexpress.executor.ServerBootID;
import com.raplix.rolloutexpress.executor.StepDescriptionContainer;
import com.raplix.rolloutexpress.executor.StepID;
import com.raplix.rolloutexpress.executor.StepInfo;
import com.raplix.rolloutexpress.executor.StepStatusBean;
import com.raplix.rolloutexpress.executor.StringConstants;
import com.raplix.rolloutexpress.executor.SubplanInvoker;
import com.raplix.rolloutexpress.executor.SubplanPrompt;
import com.raplix.rolloutexpress.executor.TaskDescriptor;
import com.raplix.rolloutexpress.executor.TaskHostStatusBean;
import com.raplix.rolloutexpress.executor.TaskID;
import com.raplix.rolloutexpress.executor.TaskInfo;
import com.raplix.rolloutexpress.executor.TaskInfoTable;
import com.raplix.rolloutexpress.executor.TaskStatusBean;
import com.raplix.rolloutexpress.executor.eventhandlers.EventHandlerTaskListener;
import com.raplix.rolloutexpress.executor.query.AutogenPlanRunHistoryBean;
import com.raplix.rolloutexpress.executor.query.MultiAutoGenPlanQuery;
import com.raplix.rolloutexpress.executor.query.MultiTaskInfoQuery;
import com.raplix.rolloutexpress.executor.query.SingleExecNativeOutputQuery;
import com.raplix.rolloutexpress.executor.snapshot.CleanupStepGatherer;
import com.raplix.rolloutexpress.executor.snapshot.PrepareStepGatherer;
import com.raplix.rolloutexpress.executor.snapshot.SnapshotItemGatherer;
import com.raplix.rolloutexpress.executor.snapshot.SnapshotPurgeData;
import com.raplix.rolloutexpress.executor.snapshot.SnapshotStepsContext;
import com.raplix.rolloutexpress.executor.snapshot.StepGatherer;
import com.raplix.rolloutexpress.executor.target.HostResolver;
import com.raplix.rolloutexpress.executor.target.NoRAOnHostException;
import com.raplix.rolloutexpress.executor.target.Target;
import com.raplix.rolloutexpress.executor.task.ExecNativeOutput;
import com.raplix.rolloutexpress.executor.task.PauseTaskExecutor;
import com.raplix.rolloutexpress.executor.task.SnapshotUtil;
import com.raplix.rolloutexpress.executor.task.TaskExecutor;
import com.raplix.rolloutexpress.executor.virtual.RealAgent;
import com.raplix.rolloutexpress.executor.virtual.VACreationData;
import com.raplix.rolloutexpress.message.ROXMessage;
import com.raplix.rolloutexpress.message.ROXMessageManager;
import com.raplix.rolloutexpress.net.rpc.CommandException;
import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.net.rpc.RPCManager;
import com.raplix.rolloutexpress.persist.PersistenceManager;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.persist.query.NoResultsFoundException;
import com.raplix.rolloutexpress.persist.query.ObjectFilter;
import com.raplix.rolloutexpress.persist.query.QueryContext;
import com.raplix.rolloutexpress.systemmodel.componentdb.Component;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentID;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentSelector;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentSelectorManager;
import com.raplix.rolloutexpress.systemmodel.componentdb.NamedBlockType;
import com.raplix.rolloutexpress.systemmodel.folderdb.FolderID;
import com.raplix.rolloutexpress.systemmodel.hostdbx.Host;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostID;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostIDSet;
import com.raplix.rolloutexpress.systemmodel.hostdbx.SummaryHost;
import com.raplix.rolloutexpress.systemmodel.installdb.InstalledComponent;
import com.raplix.rolloutexpress.systemmodel.installdb.InstalledComponentID;
import com.raplix.rolloutexpress.systemmodel.installdb.MultiSnapshotQuery;
import com.raplix.rolloutexpress.systemmodel.installdb.Snapshot;
import com.raplix.rolloutexpress.systemmodel.installdb.SnapshotID;
import com.raplix.rolloutexpress.systemmodel.plandb.Caller;
import com.raplix.rolloutexpress.systemmodel.plandb.ExecStep;
import com.raplix.rolloutexpress.systemmodel.plandb.ExecutionPlan;
import com.raplix.rolloutexpress.systemmodel.plandb.ExecutionPlanID;
import com.raplix.rolloutexpress.systemmodel.plandb.PauseStep;
import com.raplix.rolloutexpress.systemmodel.plugindb.SystemPluginConstants;
import com.raplix.rolloutexpress.systemmodel.userdb.FolderPermission;
import com.raplix.rolloutexpress.systemmodel.userdb.SessionManager;
import com.raplix.rolloutexpress.systemmodel.userdb.UserDBSubsystem;
import com.raplix.rolloutexpress.systemmodel.userdb.UserID;
import com.raplix.util.Util;
import com.raplix.util.collections.CollectionUtil;
import com.raplix.util.logger.Logger;
import com.raplix.util.rwlock.LockContext;
import com.raplix.util.threads.ActiveDetector;
import com.raplix.util.threads.Context;
import com.raplix.util.threads.ContextThread;
import com.raplix.util.threads.FIFOQueue;
import com.raplix.util.threads.ResourceID;
import java.security.AccessControlException;
import java.security.AccessController;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Stack;
import java.util.Vector;

public class PlanSubsystem
extends Subsystem
implements PlanInterface,
PlanExecutorMessages,
StringConstants,
ConsistencyEnforcer {
    public static final SubsystemID CLASS_SUBSYSTEM_ID = new SubsystemID(PlanSubsystem.class.getName());
    private static final String CONFIG_PREFIX = "pe";
    private NotificationManager mNotMgr;
    private UserDBSubsystem mUserDB;
    private PersistenceManager mPM;
    private Context mGlobalContext;
    private ConfigGenManager mCfgMgr;
    private boolean mPauseDuringPreflight = false;
    private Application mApp;
    private ActiveDetector mLockDetector;
    private Hashtable mHostToQueueLockMap;
    protected static final String CONFIG_VARNAME_DEFAULT_USER_TO_RUN_AS = "defaultUserToRunAs";
    protected static final String CONFIG_VARNAME_DEFAULT_INSTALL_USER = "defaultDeployedFileUser";
    protected static final String CONFIG_VARNAME_DEFAULT_INSTALL_GROUP = "defaultDeployedFileGroup";
    protected static final String CONFIG_VARNAME_MAX_OUTPUT_SNAPSHOT_BYTES = "maxOutputSnapshotBytes";
    protected static final String CONFIG_VARNAME_NON_PLAN_EXEC_NATIVE_TIMEOUT = "nonPlanExecNativeTimeout";
    protected static final String CONFIG_VARNAME_DEFAULT_PLAN_TIMEOUT = "defaultPlanTimeout";
    protected static final String CONFIG_VARNAME_ARCHIVE_SUFFIXES = "archiveSuffixes";
    protected static final String CONFIG_VARNAME_DEFAULT_PLAN_THROTTLE = "defaultMaxSimultaneousHosts";
    protected static final String CONFIG_VARNAME_REBOOT_INTERVAL = "rebootWaitInterval";
    protected static final String CONFIG_VARNAME_LOCK_PHYSICAL_HOST = "lockPhysicalHost";
    protected static final String DEFAULT_CONFIG_DEFAULT_USER_TO_RUN_AS = null;
    protected static final String DEFAULT_CONFIG_DEFAULT_INSTALL_USER = null;
    protected static final String DEFAULT_CONFIG_DEFAULT_INSTALL_GROUP = null;
    protected static final String DEFAULT_MAX_OUTPUT_SNAPSHOT_BYTES = "10240";
    protected static final String DEFAULT_NON_PLAN_EXEC_NATIVE_TIMEOUT = "600";
    protected static final String DEFAULT_PLAN_TIMEOUT = "1800";
    protected static final String DEFAULT_ARCHIVE_SUFFIXES = ".jar,.war,.ear,.zip";
    protected static final String DEFAULT_CONFIG_DEFAULT_PLAN_THROTTLE = "10";
    protected static final String DEFAULT_CONFIG_REBOOT_INTERVAL = "5";
    protected static final boolean DEFAULT_DETAILED_PREFLIGHT = false;
    protected static final boolean DEFAULT_CONFIG_LOCK_PHYSICAL_HOST = true;
    private static DefaultConfiguration[] sDefaultConfiguration = new DefaultConfiguration[]{new DefaultConfiguration("defaultUserToRunAs", DEFAULT_CONFIG_DEFAULT_USER_TO_RUN_AS, "The system user name as whom to execute native commands"), new DefaultConfiguration("defaultDeployedFileUser", DEFAULT_CONFIG_DEFAULT_INSTALL_USER, "The system user name who will own installed resources if not specified by the Plan"), new DefaultConfiguration("defaultDeployedFileGroup", DEFAULT_CONFIG_DEFAULT_INSTALL_GROUP, "The system group name who will own installed resources if not specified by the Plan"), new DefaultConfiguration("maxOutputSnapshotBytes", "10240", "This is the default maximum output snapshot size for the exec native step"), new DefaultConfiguration("nonPlanExecNativeTimeout", "600", "This is the timeout (in seconds) for exec native steps executed outside a plan"), new DefaultConfiguration("archiveSuffixes", ".jar,.war,.ear,.zip", "Comma separated list of acceptable archive suffixes"), new DefaultConfiguration("defaultPlanTimeout", "1800", "This is the default timeout (in seconds) for all the plnas."), new DefaultConfiguration("defaultMaxSimultaneousHosts", "10", "This is the default number of hosts that are allowed to run simultaneously."), new DefaultConfiguration("rebootWaitInterval", "5", "This is the time interval (in seconds) the master server waits between pings to a remote agent who is in the process of rebooting."), new DefaultConfiguration("lockPhysicalHost", true, "This specifies whether or not to lock physical hosts during plan run. By default all hosts are locked.")};
    private static String[] sConfigArchiveSuffixes = null;
    private static final int NUM_RETRIES_ENATIVE_OUTPUT = 300;
    private final ServerBootID mSnapshotRequestServerBootID = ServerBootID.generateServerBootID();
    private long mSnapshotRequestID = 0L;
    private final Object SNAP_REQUEST_LOCK = new Object();
    static /* synthetic */ Class class$com$raplix$rolloutexpress$event$ROXPreflightCompleteEvent;

    private PlanSubsystem() {
    }

    public PlanSubsystem(Application inApp) throws ConfigurationException {
        super(inApp, CLASS_SUBSYSTEM_ID);
        try {
            this.mApp = inApp;
            this.mUserDB = inApp.getUserDBSubsystem();
            this.mCfgMgr = inApp.getConfigGenSubsystem();
            this.mNotMgr = inApp.getNotificationManager();
            this.mPM = inApp.getPMSubsystem();
        }
        catch (UnsupportedSubsystemException ex) {
            ROXMessage msg = new ROXMessage("pe.NO_SUBSYSTEM");
            if (Logger.isErrorEnabled(this)) {
                Logger.error(msg.toString(), ex, this);
            }
            throw new ConfigurationException(msg, (Throwable)ex, 2);
        }
        this.mGlobalContext = new Context("PlanSubsystem_Context");
        this.mLockDetector = new ActiveDetector();
        this.mHostToQueueLockMap = new Hashtable(100);
    }

    public TaskID runPlan(TaskDescriptor inTaskDescriptor) throws PlanExecutionException {
        return this.runPlan(inTaskDescriptor, this.getShouldVerifySystemServices(), new HostResolver());
    }

    private TaskID runPlan(final TaskDescriptor inTaskDescriptor, final boolean fVerifySystemServices, final HostResolver inResolver) throws PlanExecutionException {
        LockContext lockContext = new LockContext(){

            public Object execute() throws PlanExecutionException {
                TaskInfo theTaskInfo = new TaskInfo(inTaskDescriptor, PlanSubsystem.this.mApplication, inResolver);
                theTaskInfo = PlanSubsystem.this.storeTaskInfo(theTaskInfo);
                theTaskInfo.initialize(fVerifySystemServices);
                CompiledPlanExecutor executor = null;
                try {
                    executor = new CompiledPlanExecutor(theTaskInfo, PlanSubsystem.this.getGlobalContext(), PlanSubsystem.this.mApplication);
                }
                catch (UnsupportedSubsystemException ex) {
                    throw new PlanExecutionException("pe.FAIL_EXEC_NO_SUBSYSTEM", (Throwable)ex);
                }
                try {
                    PlanSubsystem.this.startSubsystemTask(executor);
                }
                catch (RaplixException e) {
                    throw new PlanExecutionException(e);
                }
                return theTaskInfo.getTaskID();
            }
        };
        try {
            return (TaskID)this.mPM.getSystemLockObject().readLock(ROXMessageManager.messageAsString("pe.RUN_PLAN_LOCK_MESSAGE", new Object[]{inTaskDescriptor.getCompiledPlan().getTopLevelPlan().getName()}), lockContext);
        }
        catch (PlanExecutionException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PlanExecutionException(e);
        }
    }

    public TaskDescriptor generateTaskDescriptorForPlan(ExecutionPlanID inPlanID) throws PlanExecutionException {
        int planThrottle;
        int nativeTimeout;
        int planTimeout;
        String userToRunAs;
        SubplanPrompt[] thePrompts;
        CompiledPlan theCPlan;
        block7: {
            ExecutionPlan plan = null;
            theCPlan = null;
            try {
                plan = inPlanID.getByIDQuery().select();
                PlanCompiler theCompiler = new PlanCompiler();
                theCPlan = theCompiler.compilePlan(plan);
                PromptCollectorCompiledPlanTraverser theTraverser = new PromptCollectorCompiledPlanTraverser(theCPlan);
                theCPlan.traversePlan(theTraverser);
                thePrompts = theTraverser.getPrompts();
            }
            catch (CommandException ex) {
                String planName = plan != null ? plan.getFullName() : inPlanID.toString();
                ROXMessage msg = new ROXMessage("pe.UNABLE_LOAD_PLAN", new String[]{planName});
                if (Logger.isErrorEnabled(this)) {
                    Logger.error(msg.toString(), ex, this);
                }
                throw new PlanExecutionException("pe.UNABLE_LOAD_PLAN", (Throwable)ex, planName);
            }
            userToRunAs = null;
            try {
                userToRunAs = this.getConfigUserToRunAs();
            }
            catch (ConfigurationException ce) {
                if (!Logger.isWarnEnabled(this)) break block7;
                Logger.warn("pe.DEFAULT_USER_MISSING", ce, this);
            }
        }
        try {
            planTimeout = this.getConfigDefaultPlanTimeout();
            nativeTimeout = this.getConfigNonPlanExecNativeTimeout();
            planThrottle = this.getConfigDefaultPlanThrottle();
        }
        catch (ConfigurationException ex) {
            throw new PlanExecutionException(ex);
        }
        TaskDescriptor theDescriptor = new TaskDescriptor(theCPlan, RunLevel.ACTUAL, thePrompts, null, userToRunAs, planTimeout, nativeTimeout, planThrottle, this.getDefaultDetailedPreflight());
        return theDescriptor;
    }

    public TaskDescriptor refreshTaskDescriptor(TaskDescriptor inTaskDescriptor) throws PlanExecutionException {
        SubplanPrompt[] allPrompts = inTaskDescriptor.getSubplanPrompts();
        int nPrompts = allPrompts.length;
        Vector<ComponentSelector> selectorVector = new Vector<ComponentSelector>(3 * nPrompts);
        ComponentSelectorManager compSelMgr = new ComponentSelectorManager();
        for (int i = 0; i < nPrompts; ++i) {
            SubplanPrompt curPrompt = allPrompts[i];
            int nSelectors = curPrompt.getNumComponentSelectors();
            for (int j = 0; j < nSelectors; ++j) {
                ComponentSelector curSelector = curPrompt.getComponentSelector(j);
                selectorVector.add(curSelector);
            }
        }
        ComponentSelector[] allSelectors = (ComponentSelector[])CollectionUtil.mapClass(selectorVector, ComponentSelector.class);
        try {
            compSelMgr.refreshVariableSettingsSelectors(allSelectors);
        }
        catch (PersistenceManagerException ex) {
            throw new PlanExecutionException(ex);
        }
        catch (RPCException ex) {
            throw new PlanExecutionException(ex);
        }
        return inTaskDescriptor;
    }

    public StepInfo getStepInfoForStepID(StepID inStepID) throws NoSuchTaskException {
        StepInfo result = new StepInfo();
        try {
            result.setObjectID(inStepID);
            result.retrieve();
        }
        catch (Exception ex) {
            throw new NoSuchTaskException(ex, (Object)inStepID);
        }
        return result;
    }

    public TaskInfo getTaskInfoForTaskID(TaskID inTaskID, boolean inRunningOnly) throws NoSuchTaskException {
        TaskInfo result = TaskInfo.getTaskFromCache(inTaskID);
        if (inRunningOnly && null != result && null == result.getTaskComplete()) {
            result = null;
        }
        if (null == result) {
            boolean error = false;
            if (inRunningOnly) {
                error = true;
            } else {
                result = new TaskInfo();
                try {
                    result.setObjectID(inTaskID);
                    result.retrieve();
                    ExecutionPlan plan = result.getPlanID().getByIDQuery().select();
                    PlanCompiler theCompiler = new PlanCompiler();
                    CompiledPlan theCPlan = theCompiler.compilePlan(plan);
                    result.setCompiledPlan(theCPlan);
                }
                catch (Exception ex) {
                    if (Logger.isErrorEnabled(this)) {
                        Logger.error(ROXMessageManager.messageAsString("pe.UNABLE_RETR_TASK", new Object[]{inTaskID}), ex, this);
                    }
                    error = true;
                }
            }
            if (error) {
                throw new NoSuchTaskException(inTaskID);
            }
        }
        return result;
    }

    public synchronized ResourceID getHostLockMapping(Host inHost) {
        ResourceID hostLockID = (ResourceID)this.mHostToQueueLockMap.get(inHost.getID());
        if (hostLockID == null) {
            FIFOQueue hostQ = new FIFOQueue(this.mLockDetector, inHost.getName());
            hostLockID = this.getGlobalContext().register(hostQ);
            if (Logger.isDebugEnabled(this)) {
                Logger.debug("registeringLocks: host " + inHost.getName() + " with ID " + hostLockID, this);
            }
            this.mHostToQueueLockMap.put(inHost.getID(), hostLockID);
        }
        return hostLockID;
    }

    public TaskInfo getTaskInfoForTaskID(TaskID inTaskID) throws NoSuchTaskException {
        return this.getTaskInfoForTaskID(inTaskID, false);
    }

    public boolean requestHalt(TaskID inTaskID) {
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("Halting " + inTaskID, this);
        }
        this.mNotMgr.notify(ROXTaskEvent.abortRequested(inTaskID));
        return this.stopSubsystemTask(inTaskID.toString());
    }

    public boolean suspend(TaskID inTaskID) {
        CompiledPlanExecutor executor = (CompiledPlanExecutor)this.getRunningTask(inTaskID.toString());
        if (executor == null) {
            if (Logger.isDebugEnabled(this)) {
                Logger.debug("Unable to Suspend " + inTaskID + " since it's no longer running", this);
            }
            return false;
        }
        executor.suspend();
        return true;
    }

    public void registerRPCInterfaces(RPCManager inRPCManager) throws RPCException {
        inRPCManager.registerService(PlanInterface.class, this);
    }

    protected DefaultConfiguration[] getDefaultConfiguration() {
        return sDefaultConfiguration;
    }

    public String getConfigUserToRunAs() throws ConfigurationException {
        return this.getConfigurationAsString(CONFIG_VARNAME_DEFAULT_USER_TO_RUN_AS);
    }

    public String getConfigInstallUser() throws ConfigurationException {
        return this.getConfigurationAsString(CONFIG_VARNAME_DEFAULT_INSTALL_USER);
    }

    public String getConfigInstallGroup() throws ConfigurationException {
        return this.getConfigurationAsString(CONFIG_VARNAME_DEFAULT_INSTALL_GROUP);
    }

    public int getConfigMaxOutputSnapshotBytes() throws ConfigurationException {
        return this.getConfigurationAsInt(CONFIG_VARNAME_MAX_OUTPUT_SNAPSHOT_BYTES);
    }

    public int getConfigDefaultPlanTimeout() throws ConfigurationException {
        return this.getConfigurationAsInt(CONFIG_VARNAME_DEFAULT_PLAN_TIMEOUT);
    }

    public int getConfigNonPlanExecNativeTimeout() throws ConfigurationException {
        return this.getConfigurationAsInt(CONFIG_VARNAME_NON_PLAN_EXEC_NATIVE_TIMEOUT);
    }

    public int getConfigDefaultPlanThrottle() throws PlanExecutionException {
        try {
            return this.getConfigurationAsInt(CONFIG_VARNAME_DEFAULT_PLAN_THROTTLE);
        }
        catch (ConfigurationException ex) {
            throw new PlanExecutionException(ex);
        }
    }

    public boolean getConfigSkipLockingOfPhysicalHosts() throws PlanExecutionException {
        try {
            return !this.getConfigurationAsBoolean(CONFIG_VARNAME_LOCK_PHYSICAL_HOST);
        }
        catch (ConfigurationException ex) {
            throw new PlanExecutionException(ex);
        }
    }

    public int getConfigRebootInterval() throws PlanExecutionException {
        try {
            return this.getConfigurationAsInt(CONFIG_VARNAME_REBOOT_INTERVAL);
        }
        catch (ConfigurationException ex) {
            throw new PlanExecutionException(ex);
        }
    }

    public String[] getConfigArchiveSuffixes() throws ConfigurationException {
        if (sConfigArchiveSuffixes == null) {
            sConfigArchiveSuffixes = Util.splitString(this.getConfigurationAsString(CONFIG_VARNAME_ARCHIVE_SUFFIXES), ",");
        }
        return sConfigArchiveSuffixes;
    }

    public boolean getPauseDuringPreflight() {
        return this.mPauseDuringPreflight;
    }

    public void setPauseDuringPreflight(boolean inPause) {
        this.mPauseDuringPreflight = inPause;
    }

    protected String getConfigurationPropertyPrefix() {
        return CONFIG_PREFIX;
    }

    void removePEFromList(TaskID inTaskID) throws RaplixException {
        this.subsystemTaskComplete(inTaskID.toString());
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("Removed " + inTaskID + " from list of active PEs", this);
        }
    }

    private TaskInfo storeTaskInfo(TaskInfo inTaskInfo) throws PlanExecutionException {
        try {
            inTaskInfo.save();
            if (Logger.isDebugEnabled(this)) {
                Logger.debug("Stored TaskInfo " + inTaskInfo.getTaskID(), this);
            }
            return inTaskInfo;
        }
        catch (Exception ex) {
            if (Logger.isErrorEnabled(this)) {
                Logger.error("Unable to save taskInfo " + inTaskInfo, ex, this);
            }
            throw new PlanExecutionException("pe.UNABLE_SAVE_INFO", (Throwable)ex);
        }
    }

    public String getSubsystemName() {
        return "PlanSubsystem";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void enforceRunningPlanConsistency() throws RPCException, PersistenceManagerException, UnsupportedSubsystemException, CannotEnforceException, NotificationManagerException {
        NotificationManager nManager = this.mApplication.getNotificationManager();
        MultiTaskInfoQuery taskQuery = MultiTaskInfoQuery.all();
        taskQuery.addFilter(new ObjectFilter(){

            public void addFilterCondition(QueryContext ctx) {
                TaskInfoTable t = (TaskInfoTable)ctx.getFirstTable();
                ctx.addAndWhereCondition(TaskInfoTable.isNull(t.TaskComplete));
            }
        });
        TaskInfo[] incompleteTasks = taskQuery.select();
        if (incompleteTasks.length > 0) {
            PersistenceManager pm = this.mApplication.getPMSubsystem();
            InconsistencyFixException ife = new InconsistencyFixException();
            Vector incompleteSteps = null;
            for (int i = 0; i < incompleteTasks.length; ++i) {
                TaskInfo theTask = incompleteTasks[i];
                EventHandlerTaskListener listener = new EventHandlerTaskListener(theTask, pm);
                nManager.addListener(listener);
                try {
                    incompleteSteps = nManager.queryIncompleteStepEvents(theTask.getID());
                    if (!incompleteSteps.isEmpty()) {
                        Enumeration steps = incompleteSteps.elements();
                        while (steps.hasMoreElements()) {
                            ROXStepStartEvent stepEvent = (ROXStepStartEvent)steps.nextElement();
                            if (Logger.isInfoEnabled(this)) {
                                Logger.info("Posting step failed and complete events for taskID:" + theTask.getID() + ":stepID:" + stepEvent.getStepID() + ":hostID:" + stepEvent.getHostID() + ":isPreflight:" + stepEvent.getIsPreflight(), this);
                            }
                            StepInfo step = new StepInfo(stepEvent.getStepID());
                            PlanSubsystem.notifyForConsistency(nManager, ROXStepEvent.failed(4, step, ife, stepEvent.getSubPlanIndex()));
                            PlanSubsystem.notifyForConsistency(nManager, ROXStepEvent.complete(step, stepEvent.getSubPlanIndex()));
                        }
                    }
                    MultiEventQuery eventQuery = MultiEventQuery.byTaskID(theTask.getID());
                    eventQuery.setTypeFilter(class$com$raplix$rolloutexpress$event$ROXPreflightCompleteEvent == null ? PlanSubsystem.class$("com.raplix.rolloutexpress.event.ROXPreflightCompleteEvent") : class$com$raplix$rolloutexpress$event$ROXPreflightCompleteEvent);
                    if (!eventQuery.selectExists()) {
                        if (Logger.isInfoEnabled(this)) {
                            Logger.info("Posting preflight complete event for taskID:" + theTask.getID(), this);
                        }
                        PlanSubsystem.notifyForConsistency(nManager, ROXTaskEvent.preflightComplete(4, theTask.getID(), theTask.getPlanID()));
                    }
                    if (Logger.isInfoEnabled(this)) {
                        Logger.info("Posting failed and complete events for taskID:" + theTask.getID(), this);
                    }
                    PlanSubsystem.notifyForConsistency(nManager, ROXTaskEvent.failed(4, theTask.getID(), theTask.getPlanID(), theTask.getRunLevel().equals(RunLevel.PREFLIGHT), ife));
                    PlanSubsystem.notifyForConsistency(nManager, ROXTaskEvent.complete(theTask.getID(), theTask.getPlanID(), theTask.getRunLevel().equals(RunLevel.PREFLIGHT)));
                }
                finally {
                    nManager.removeListener(listener);
                }
                theTask.save();
            }
        }
    }

    private void enforceTargetStatusConsistency() throws RPCException, PersistenceManagerException {
        MultiTargetStatusQuery query = MultiTargetStatusQuery.all();
        query.addFilter(new ObjectFilter(){

            public void addFilterCondition(QueryContext ctx) {
                TargetStatusTable t = (TargetStatusTable)ctx.getFirstTable();
                ctx.addAndWhereCondition(TargetStatusTable.or(TargetStatusTable.equals(t.Status, 3), TargetStatusTable.equals(t.Status, 0)));
            }
        });
        TargetStatus[] statusObjs = query.select();
        for (int i = 0; i < statusObjs.length; ++i) {
            statusObjs[i].setStatus(2);
            statusObjs[i].save();
        }
    }

    public void enforceConsistency() throws CannotEnforceException {
        try {
            this.enforceRunningPlanConsistency();
            this.enforceTargetStatusConsistency();
        }
        catch (Exception e) {
            throw new CannotEnforceException(new ROXMessage("pe.ERR_ENFORCE_CONSISTENCY"), (Throwable)e);
        }
    }

    private static void notifyForConsistency(NotificationManager nManager, ROXEvent event) throws CannotEnforceException {
        if (!nManager.notifyAndWait(event, true)) {
            throw new CannotEnforceException(new ROXMessage("pe.ERR_SYNC_NOTIFY"));
        }
    }

    public ExecNativeOutput getExecOutput(StepID inStepID) throws PlanExecutionException, RPCException {
        if (inStepID == null) {
            throw new MalformedStepDescriptionException(new ROXMessage("pe.ENATIVE_ERR_GET_OUTPUT"));
        }
        ExecNativeOutput[] output = this.getExecOutput(new StepDescriptionContainer[]{new StepDescriptionContainer(inStepID)}, true);
        if (output.length > 0) {
            return output[0];
        }
        throw new NoOutputForExecStepException(new ROXMessage("pe.ENATIVE_ERR_WAIT_OUTPUT"));
    }

    public ExecNativeOutput[] getExecOutput(StepDescriptionContainer[] inLabels) throws PlanExecutionException, RPCException {
        return this.getExecOutput(inLabels, false);
    }

    protected ExecNativeOutput[] getExecOutput(StepDescriptionContainer[] inLabels, boolean inThrowOnError) throws RPCException, PlanExecutionException {
        if (inLabels == null) {
            return new ExecNativeOutput[0];
        }
        LinkedList<ExecNativeOutput> output = new LinkedList<ExecNativeOutput>();
        LinkedList<StepInfo> steps = new LinkedList<StepInfo>();
        for (int i = 0; i < inLabels.length; ++i) {
            if (inLabels[i] == null) {
                if (inThrowOnError) {
                    throw new MalformedStepDescriptionException(new ROXMessage("pe.ENATIVE_ERR_GET_OUTPUT"));
                }
                if (!Logger.isWarnEnabled(this)) continue;
                Logger.warn(new ROXMessage("pe.ENATIVE_ERR_GET_OUTPUT").getMessageString(), this);
                continue;
            }
            try {
                steps.addAll(Arrays.asList(inLabels[i].resolve()));
                continue;
            }
            catch (PersistenceManagerException e) {
                if (inThrowOnError) {
                    throw new PlanExecutionException(new ROXMessage("pe.ENATIVE_ERR_GET_OUTPUT"), (Throwable)e);
                }
                if (!Logger.isWarnEnabled(this)) continue;
                Logger.warn(new ROXMessage("pe.ENATIVE_ERR_GET_OUTPUT").getMessageString(), e, this);
            }
        }
        Iterator stepIt = steps.iterator();
        while (stepIt.hasNext()) {
            StepInfo step = (StepInfo)stepIt.next();
            if (!ExecNativeOutput.isOutputStep(step)) {
                if (inThrowOnError) {
                    throw new InvalidExecStepTypeException(new ROXMessage("pe.ENATIVE_INCORRECT_STEP_TYPE"));
                }
                if (!Logger.isWarnEnabled(this)) continue;
                Logger.warn(new ROXMessage("pe.ENATIVE_INCORRECT_STEP_TYPE").getMessageString(), this);
                continue;
            }
            ExecNativeOutput eno = this.fetchExecOutput(step);
            if (eno == null) {
                if (inThrowOnError) {
                    throw new NoOutputForExecStepException(new ROXMessage("pe.ENATIVE_ERR_WAIT_OUTPUT"));
                }
                if (!Logger.isWarnEnabled(this)) continue;
                Logger.warn(new ROXMessage("pe.ENATIVE_ERR_WAIT_OUTPUT").getMessageString(), this);
                continue;
            }
            output.add(eno);
        }
        return output.toArray(new ExecNativeOutput[0]);
    }

    private ExecNativeOutput fetchExecOutput(StepInfo inStep) throws PlanExecutionException {
        ExecNativeOutput eno = null;
        try {
            eno = inStep.getStepStatus().running() ? this.fetchLiveExecNativeOutput(inStep) : this.fetchDBExecNativeOutput(inStep.getID());
        }
        catch (CommandException e) {
            throw new PlanExecutionException(new ROXMessage("pe.ENATIVE_ERR_GET_OUTPUT"), (Throwable)e);
        }
        catch (InterruptedException e) {
            throw new PlanExecutionException(new ROXMessage("pe.ENATIVE_ERR_GET_OUTPUT"), (Throwable)e);
        }
        return eno;
    }

    private ExecNativeOutput fetchDBExecNativeOutput(StepID inStepID) throws PersistenceManagerException, RPCException {
        try {
            return SingleExecNativeOutputQuery.byStepID(inStepID).select();
        }
        catch (NoResultsFoundException e) {
            return null;
        }
    }

    private ExecNativeOutput fetchLiveExecNativeOutput(StepInfo inStep) throws RPCException, PersistenceManagerException, CommandExecutionErrorException, InterruptedException {
        Host theHost = inStep.getTargetID().getByIDQuery().select().getPhysicalHost();
        NativePlatformIntegrationInterface npii = (NativePlatformIntegrationInterface)this.mApplication.getRPCInterface(theHost.getRARoxAddress(), NativePlatformIntegrationInterface.class);
        ExecNativeOutput output = null;
        for (int i = 0; output == null && i < 300; ++i) {
            output = npii.getExecOutput(inStep.getTaskID(), inStep.getID());
            if (output == null) {
                output = this.fetchDBExecNativeOutput(inStep.getID());
            }
            if (output != null) continue;
            Thread.sleep(1000L);
        }
        return output;
    }

    public TaskID prepHosts(final HostIDSet inHosts, final UserID inUserID) throws PlanExecutionException, RPCException {
        LockContext lockContext = new LockContext(){

            public Object execute() throws PlanExecutionException, RPCException, PersistenceManagerException {
                HostResolver resolver = new HostResolver();
                Vector<String> nonPhysicalHosts = new Vector<String>();
                HostID[] hostIDs = inHosts.toIDArray(new HostID[inHosts.size()]);
                for (int i = 0; i < hostIDs.length; ++i) {
                    try {
                        Host theHost = resolver.getHost(hostIDs[i]);
                        if (!theHost.isVirtual()) continue;
                        if (Logger.isDebugEnabled(this)) {
                            Logger.debug("adding virtual host " + theHost.getName() + " to bad list", this);
                        }
                        nonPhysicalHosts.add(theHost.getName());
                        continue;
                    }
                    catch (CommandException ex) {
                        throw new PlanExecutionException(ex);
                    }
                }
                if (nonPhysicalHosts.size() > 0) {
                    throw new PlanExecutionException("pe.HOSTS_TO_PREP_NOT_PHYSICAL", Util.getStringFromArray(nonPhysicalHosts.toArray(new String[nonPhysicalHosts.size()]), ","));
                }
                TaskDescriptor desc = PlanSubsystem.this.generateTaskDescriptorForPlan(SystemPluginConstants.getInstance().PREP_HOSTS_PLAN_ID);
                SubplanPrompt[] allPrompts = desc.getSubplanPrompts();
                allPrompts[0].setInitialTargets(inHosts.toIDArray(new HostID[inHosts.size()]));
                desc.setSubplanPrompts(allPrompts);
                desc.setRoxUser(inUserID);
                if (Logger.isDebugEnabled(this)) {
                    Logger.debug("About to run prepHostsPlan", this);
                }
                try {
                    return PlanSubsystem.this.runPlan(desc, false, resolver);
                }
                catch (NoRAOnHostException ex) {
                    Host pHost = ex.getPhysicalHost();
                    if (pHost.getAppLD() != null) {
                        throw new PlanExecutionException("pe.NO_PREP_ON_LD", pHost.getName());
                    }
                    if (pHost.getAppMS() != null) {
                        throw new PlanExecutionException("pe.NO_PREP_ON_MS", pHost.getName());
                    }
                    throw ex;
                }
            }
        };
        try {
            return (TaskID)this.mPM.getSystemLockObject().readLock(ROXMessageManager.messageAsString("pe.PREP_HOSTS_LOCK_MESSAGE", new Object[]{new Integer(inHosts.size())}), lockContext);
        }
        catch (PlanExecutionException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PlanExecutionException(e);
        }
    }

    public void execNonPlanSteps(final ExecStep[] inSteps, final HostID inHostID, final Context inParent, final String inWorkingDirOverride, final FolderID inFolderID) throws PlanExecutionException, InterruptedException {
        LockContext lockContext = new LockContext(){

            public Object execute() throws PlanExecutionException, InterruptedException {
                try {
                    HostData hostData = new HostData(inHostID.getByIDQuery().select());
                    HostResolver resolver = new HostResolver();
                    Target target = PlanPreprocessor.resolveTargets(new HostID[]{inHostID}, resolver, null)[0];
                    ExecutionState execState = PlanSubsystem.this.getNonPlanExecState(resolver, inSteps, hostData);
                    execState.setWorkingDirOverride(inWorkingDirOverride);
                    VACreationData vaData = new VACreationData(target, null, null, null, null);
                    PlanExecutionRunner thePER = new PlanExecutionRunner(inParent, execState, vaData, 0);
                    PlanSubsystem.this.runNonPlanSteps(execState, thePER, inFolderID, target.getCurrentHostID(), target.getCurrentHostID().getByIDQuery().selectSummaryView().getName(), inHostID, hostData.getHostName());
                }
                catch (PlanExecutionException pex) {
                    throw pex;
                }
                catch (RaplixException vace) {
                    ROXMessage msg = new ROXMessage("pe.ERR_EXEC_NON_PLAN_STEPS");
                    if (Logger.isErrorEnabled(this)) {
                        Logger.error(msg.getMessageString(), vace, this);
                    }
                    throw new PlanExecutionException(new ROXMessage("pe.ERR_EXEC_NON_PLAN_STEPS"));
                }
                return null;
            }
        };
        try {
            SummaryHost h = inHostID.getByIDQuery().selectSummaryView();
            this.mPM.getSystemLockObject().readLock(ROXMessageManager.messageAsString("pe.NON_PLAN_LOCK_MESSAGE", new Object[]{new Integer(inSteps.length), h.getName()}), lockContext);
        }
        catch (PlanExecutionException e) {
            throw e;
        }
        catch (InterruptedException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PlanExecutionException(e);
        }
    }

    public void executeSnapshotSteps(final Snapshot inSnapshot, final boolean fPrepare, final Context inParent, final FolderID inFolderID) throws PlanExecutionException, InterruptedException {
        try {
            final InstalledComponent iComp = inSnapshot.getInstalledComponentID().getByIDQuery().select();
            final Component comp = iComp.getComponentID().getByIDQuery().select();
            final Host theHost = inSnapshot.getInstalledComponentID().getByIDQuery().select().getTargetID().getByIDQuery().select().getCurrentHost();
            final Target theTarget = iComp.getTargetID().getByIDQuery().select();
            LockContext lockContext = new LockContext(){

                public Object execute() throws PlanExecutionException, InterruptedException {
                    try {
                        StepGatherer gatherer = fPrepare ? new PrepareStepGatherer() : new CleanupStepGatherer();
                        HostResolver resolver = new HostResolver();
                        HostData theData = new HostData(theHost);
                        ExecutionState state = PlanSubsystem.this.getNonPlanExecState(resolver, new ExecStep[0], theData);
                        String extendsType = inSnapshot.getCreatorExtendsTypeName();
                        Component creatingComp = comp.getAncestorByExtendsTypeName(extendsType);
                        Caller caller = new Caller(iComp, comp, creatingComp);
                        state.pushInstalledCompAndCaller(iComp, caller);
                        RealAgent agent = new RealAgent(PlanSubsystem.this.mApp, theData, theTarget, null);
                        state.setPlanTargetedCtx(new PlanTargetedConfigContext(agent, state));
                        PauseTaskExecutor inTE = new PauseTaskExecutor(PlanSubsystem.this.mApp, new PauseStep(1));
                        SnapshotUtil.doSnapshotTraversal(state, comp, agent, (TaskExecutor)inTE, inSnapshot.getName(), (SnapshotItemGatherer)gatherer);
                        VACreationData vaData = new VACreationData(theTarget, null, null, null, null);
                        SnapshotStepsContext rootContext = gatherer.getRootContext();
                        NonPlanExecutionRunner thePER = new NonPlanExecutionRunner(inParent, state, vaData, rootContext, inTE, agent);
                        PlanSubsystem.this.runNonPlanSteps(state, thePER, inFolderID, theTarget.getCurrentHostID(), theHost.getName(), theTarget.getPhysicalHostID(), theTarget.getPhysicalHostID().getByIDQuery().selectSummaryView().getName());
                    }
                    catch (PlanExecutionException e) {
                        throw e;
                    }
                    catch (RaplixException ex) {
                        throw new PlanExecutionException(ex);
                    }
                    return null;
                }
            };
            this.mPM.getSystemLockObject().readLock(ROXMessageManager.messageAsString("pe.EXEC_SNAPSHOT_LOCK_MESSAGE", new Object[]{inSnapshot.getName(), theHost.getName()}), lockContext);
        }
        catch (PlanExecutionException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PlanExecutionException(e);
        }
    }

    protected ExecutionState getNonPlanExecState(HostResolver inResolver, ExecStep[] inSteps, HostData inHostData) throws PlanExecutionException {
        ExecutionPlan theExecPlan = new ExecutionPlan();
        theExecPlan.setExecSteps(inSteps);
        TaskInfo taskInfo = TaskInfo.createNonPlanTaskInfo(this, inResolver);
        try {
            SessionManager localSessionManager = this.mUserDB.getLocalSessionManager();
            ConfigGenerator sessionCG = this.mCfgMgr.getConfigGenerator().newSessionScope(localSessionManager, false);
            ConfigGenerator sessionPassSafeCG = this.mCfgMgr.getConfigGenerator().newSessionScope(localSessionManager, true);
            CompiledSimpleSubplan theCSPlan = new CompiledSimpleSubplan(new SubplanInvoker(theExecPlan, null, null), new Stack(), 0);
            ExecutionState execState = new ExecutionState(this.mApp, theCSPlan, taskInfo, RunLevel.ACTUAL, sessionCG, sessionPassSafeCG);
            execState.setPlanRecorder(new NoTracePlanRecorder());
            execState.setCurrConfigGenerator(sessionCG);
            execState.setCurrPasswdSafeConfigGenerator(sessionPassSafeCG);
            return execState;
        }
        catch (RaplixException ex) {
            throw new PlanExecutionException(ex);
        }
    }

    protected void runNonPlanSteps(ExecutionState inState, PlanExecutionRunner inPER, FolderID inFolderID, HostID inCurrentHostID, String inCurrentHostName, HostID inPhysicalHostID, String inPhysicalHostName) throws PlanExecutionException, InterruptedException {
        if (inFolderID != null) {
            try {
                AccessController.checkPermission(FolderPermission.createExecutePermission(inFolderID, inCurrentHostID));
            }
            catch (AccessControlException e) {
                throw new PlanPermissionException(inCurrentHostID, inCurrentHostName);
            }
            if (inPhysicalHostID != null && !inPhysicalHostID.equals(inCurrentHostID)) {
                try {
                    AccessController.checkPermission(FolderPermission.createExecutePermission(inFolderID, inPhysicalHostID));
                }
                catch (AccessControlException e) {
                    throw new PlanPermissionException(inPhysicalHostID, inPhysicalHostName);
                }
            }
        }
        inState.setPER(inPER);
        ContextThread thread = this.mUserDB.getSessionTable().createThreadForCurrentSession(inPER);
        thread.start();
        thread.join();
        if (inPER.getTerminationException() != null) {
            throw new PlanExecutionException(new ROXMessage("pe.ERR_EXEC_NON_PLAN_STEPS"), inPER.getTerminationException());
        }
    }

    public TaskStatusBean taskStatusQuery(TaskID inTaskID) throws PersistenceManagerException {
        return TaskStatusBean.taskStatusQuery(inTaskID);
    }

    public void getTaskErrorsAndWarnings(TaskStatusBean inTaskStatusBean, RunLevel inRunLevel, Vector outWarnings, Vector outErrors) throws PersistenceManagerException {
        inTaskStatusBean.getErrorsAndWarnings(inRunLevel, outWarnings, outErrors);
    }

    public StepStatusBean stepStatusQuery(StepID inStepID) throws EmptyQueryException, PersistenceManagerException, RPCException {
        MultiStepStatusQuery query = MultiStepStatusQuery.allSteps(inStepID);
        StepStatusBean[] results = query.select();
        if (null == results || results.length == 0) {
            throw new EmptyQueryException("pe.STEP_NOT_FOUND");
        }
        return results[0];
    }

    public ExecutionPlanID installComponent(ComponentID inComponentID, String inProcedureName) throws PlanExecutionException, RPCException {
        PlanAutoGenerator generator = new PlanAutoGenerator();
        return generator.installComponent(inComponentID, inProcedureName);
    }

    public ExecutionPlanID uninstallComponent(ComponentID inComponentID, String inProcedureName, String[] inProcedureTargets) throws PlanExecutionException, RPCException {
        PlanAutoGenerator generator = new PlanAutoGenerator();
        return generator.uninstallComponent(inComponentID, inProcedureName, inProcedureTargets);
    }

    public ExecutionPlanID callComponent(ComponentID inComponentID, String inProcedureName, String[] inProcedureTargets) throws PlanExecutionException, RPCException {
        PlanAutoGenerator generator = new PlanAutoGenerator();
        return generator.callComponent(inComponentID, inProcedureName, inProcedureTargets);
    }

    public String generatePlanText(ComponentID inComponentID, String[] inProcedureNames, int[] inProcedureTypes) throws PlanExecutionException, RPCException {
        PlanAutoGenerator generator = new PlanAutoGenerator();
        if (null == inProcedureTypes) {
            throw new NullPointerException();
        }
        NamedBlockType[] modifiedTypes = new NamedBlockType[inProcedureTypes.length];
        block5: for (int i = 0; i < inProcedureTypes.length; ++i) {
            switch (inProcedureTypes[i]) {
                case 105: {
                    modifiedTypes[i] = NamedBlockType.INSTALL;
                    continue block5;
                }
                case 109: {
                    modifiedTypes[i] = NamedBlockType.UNINSTALL;
                    continue block5;
                }
                case 102: {
                    modifiedTypes[i] = NamedBlockType.CONTROL;
                    continue block5;
                }
                default: {
                    throw new IllegalArgumentException(ROXMessageManager.messageAsString("pe.AUTOGENERATION_BADSTEP"));
                }
            }
        }
        return generator.generatePlanText(inComponentID, inProcedureNames, modifiedTypes);
    }

    public String generatePlanText(ComponentID inComponentID, String[] inProcedureNames, NamedBlockType[] inProcedureTypes) throws PlanExecutionException, RPCException {
        PlanAutoGenerator generator = new PlanAutoGenerator();
        return generator.generatePlanText(inComponentID, inProcedureNames, inProcedureTypes);
    }

    public Vector queryAutoComponentPlansAllVersions(ComponentID inComponentID, String inProcedureName, int inProcedureType) throws PlanExecutionException, RPCException {
        NamedBlockType modifiedType = null;
        switch (inProcedureType) {
            case 105: {
                modifiedType = NamedBlockType.INSTALL;
                break;
            }
            case 109: {
                modifiedType = NamedBlockType.UNINSTALL;
                break;
            }
            case 102: {
                modifiedType = NamedBlockType.CONTROL;
                break;
            }
            default: {
                throw new IllegalArgumentException(ROXMessageManager.messageAsString("pe.AUTOGENERATION_BADSTEP"));
            }
        }
        try {
            MultiAutoGenPlanQuery magpq = MultiAutoGenPlanQuery.autoGenPlansForComponent(inComponentID, inProcedureName, modifiedType);
            return new Vector<RunningPlanBean>(Arrays.asList(magpq.select()));
        }
        catch (PersistenceManagerException pme) {
            throw new PlanExecutionException(pme);
        }
    }

    public Vector queryAutoComponentPlansAllVersions(ComponentID inComponentID, String inProcedureName, NamedBlockType inProcedureType) throws PlanExecutionException, RPCException {
        try {
            MultiAutoGenPlanQuery magpq = MultiAutoGenPlanQuery.autoGenPlansForComponent(inComponentID, inProcedureName, inProcedureType);
            return new Vector<RunningPlanBean>(Arrays.asList(magpq.select()));
        }
        catch (PersistenceManagerException pme) {
            throw new PlanExecutionException(pme);
        }
    }

    protected boolean getShouldVerifySystemServices() {
        return true;
    }

    public boolean getDefaultDetailedPreflight() {
        return false;
    }

    public AutogenPlanRunHistoryBean[] queryAutogenRunHistory(ComponentID inComponentID) throws PlanExecutionException, RPCException {
        try {
            return AutogenPlanRunHistoryBean.queryAutogenRunHistory(inComponentID);
        }
        catch (Exception e) {
            throw new PlanExecutionException(e);
        }
    }

    public TaskHostStatusBean[] taskStatusByHostQuery(TaskID inTaskID) throws PlanExecutionException, RPCException {
        try {
            return TaskHostStatusBean.taskStatusByHostQuery(inTaskID);
        }
        catch (PersistenceManagerException pme) {
            throw new PlanExecutionException(pme);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SnapshotPurgeData createSnapshotPurgeDataForHost(HostID inHostID) throws PersistenceManagerException, RPCException {
        SnapshotPurgeData data;
        MultiSnapshotQuery query = MultiSnapshotQuery.byHostID(inHostID);
        Snapshot[] snapshots = query.select();
        SnapshotID[] snapIDs = new SnapshotID[snapshots.length];
        HashSet<InstalledComponentID> installedCompIDs = new HashSet<InstalledComponentID>();
        for (int i = 0; i < snapshots.length; ++i) {
            snapIDs[i] = snapshots[i].getID();
            installedCompIDs.add(snapshots[i].getInstalledComponentID());
        }
        Object object = this.SNAP_REQUEST_LOCK;
        synchronized (object) {
            ++this.mSnapshotRequestID;
            data = new SnapshotPurgeData(this.mSnapshotRequestID, this.mSnapshotRequestServerBootID, installedCompIDs.toArray(new InstalledComponentID[installedCompIDs.size()]), snapIDs);
        }
        return data;
    }

    private Context getGlobalContext() {
        return this.mGlobalContext;
    }
}

