/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.executor;

import [Lcom.raplix.rolloutexpress.executor.SubplanInfo;;
import com.raplix.rolloutexpress.Application;
import com.raplix.rolloutexpress.RaplixException;
import com.raplix.rolloutexpress.UnsupportedSubsystemException;
import com.raplix.rolloutexpress.config.ConfigGenSubsystem;
import com.raplix.rolloutexpress.config.GeneratedVariableSettingsID;
import com.raplix.rolloutexpress.executor.CompiledPlan;
import com.raplix.rolloutexpress.executor.CompiledSimpleSubplan;
import com.raplix.rolloutexpress.executor.ComponentInstallData;
import com.raplix.rolloutexpress.executor.ComponentsInstallDataList;
import com.raplix.rolloutexpress.executor.InstallStepGathererTraverser;
import com.raplix.rolloutexpress.executor.PlanExecutionException;
import com.raplix.rolloutexpress.executor.SubplanInfo;
import com.raplix.rolloutexpress.executor.SubplanPrompt;
import com.raplix.rolloutexpress.executor.TaskInfo;
import com.raplix.rolloutexpress.executor.target.HostResolver;
import com.raplix.rolloutexpress.executor.target.Target;
import com.raplix.rolloutexpress.message.ROXMessage;
import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.persist.query.NoResultsFoundException;
import com.raplix.rolloutexpress.systemmodel.componentdb.Component;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentID;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentSelector;
import com.raplix.rolloutexpress.systemmodel.componentdb.ComponentVariableSettings;
import com.raplix.rolloutexpress.systemmodel.componentdb.VariableSettingsSelector;
import com.raplix.rolloutexpress.systemmodel.hostdbx.Host;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostID;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostIDSet;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostSetID;
import com.raplix.rolloutexpress.systemmodel.hostdbx.SingleHostSetQuery;
import com.raplix.rolloutexpress.systemmodel.hostdbx.SummaryHost;
import com.raplix.rolloutexpress.systemmodel.plandb.InstallStep;
import com.raplix.util.Util;
import com.raplix.util.collections.CollectionUtil;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Vector;

public class PlanPreprocessor
extends InstallStepGathererTraverser {
    private SubplanPrompt[] mSubplanPrompts;
    private ConfigGenSubsystem mConfigGenSystem;
    private HostResolver mHostResolver;
    private SubplanPrompt mCurrSubplanPrompt;
    private Vector mCurrComponentSelectors;
    private Vector mSubplanInfos;
    private HashMap mPhysicalHosts;
    private TaskInfo mTaskInfo;

    public PlanPreprocessor(HostResolver inResolver, SubplanPrompt[] inPrompts, Application inApplication, TaskInfo inTaskInfo) throws PlanExecutionException {
        this.mSubplanPrompts = inPrompts;
        this.mSubplanInfos = new Vector();
        this.mHostResolver = inResolver;
        this.mTaskInfo = inTaskInfo;
        this.mPhysicalHosts = new HashMap();
        try {
            this.mConfigGenSystem = inApplication.getConfigGenSubsystem();
        }
        catch (UnsupportedSubsystemException e) {
            throw new PlanExecutionException(e);
        }
    }

    public Object getResults() {
        return this.getSubplanInfos();
    }

    public Host[] getPhysicalHosts() {
        return this.mPhysicalHosts.values().toArray(new Host[this.mPhysicalHosts.size()]);
    }

    public SubplanInfo[] getSubplanInfos() {
        return (SubplanInfo[])CollectionUtil.mapClass(this.mSubplanInfos, SubplanInfo;.class);
    }

    public void subplanEntered(CompiledSimpleSubplan inSubplan, CompiledPlan inPlan) {
        this.mCurrSubplanPrompt = this.mSubplanPrompts[inSubplan.getSubplanIndex()];
        this.mCurrComponentSelectors = new Vector();
    }

    public void subplanExited(CompiledSimpleSubplan inSubplan, CompiledPlan inPlan) throws PlanExecutionException {
        try {
            int numComps = this.mCurrComponentSelectors.size();
            ComponentsInstallDataList theInstallData = new ComponentsInstallDataList();
            GeneratedVariableSettingsID[] userSpecifiedVars = new GeneratedVariableSettingsID[numComps];
            ComponentID[] theCompIDs = new ComponentID[numComps];
            for (int i = 0; i < numComps; ++i) {
                ComponentSelector currCompSelector = (ComponentSelector)this.mCurrComponentSelectors.get(i);
                ComponentID currComponentID = currCompSelector.getCurrent().getComponent().getID();
                Component currComponent = currComponentID.getByIDQuery().select();
                theCompIDs[i] = currComponentID;
                VariableSettingsSelector theVarSelector = currCompSelector.getCurrent();
                if (theVarSelector == null || theVarSelector.getComponent() == null) {
                    throw new PlanExecutionException(new ROXMessage("pe.NO_COMPONENT_BUILDS", new Object[]{new Integer(i), inSubplan.getName()}));
                }
                ComponentVariableSettings currVarSettings = theVarSelector.getCurrent();
                userSpecifiedVars[i] = currVarSettings != null ? this.mConfigGenSystem.generateVariableSettings(currVarSettings) : null;
                currComponent.enableHierarchyWrites();
                ComponentInstallData theCid = new ComponentInstallData(currComponent, userSpecifiedVars[i]);
                theInstallData.addComponentInstallData(theCid);
            }
            Target[] subplanTargets = PlanPreprocessor.resolveTargets(this.mCurrSubplanPrompt.getTargets(), this.mHostResolver, this.mCurrSubplanPrompt.getLimitToHostSet());
            for (int i = 0; i < subplanTargets.length; ++i) {
                this.mPhysicalHosts.put(subplanTargets[i].getPhysicalHostID(), subplanTargets[i].getPhysicalHost());
            }
            SubplanInfo theInfo = new SubplanInfo(this.mCurrSubplanPrompt, userSpecifiedVars, theCompIDs, subplanTargets, this.mTaskInfo, inSubplan.getSubplanIndex());
            theInfo.save();
            this.mSubplanInfos.add(theInfo);
            this.mTaskInfo.putInstallData(theInfo, theInstallData);
        }
        catch (PlanExecutionException ex) {
            throw ex;
        }
        catch (RaplixException e) {
            throw new PlanExecutionException(e);
        }
    }

    public static Target[] resolveTargets(HostID[] inHostIDs, HostResolver inResolver, String inLimitToHostSet) throws PlanExecutionException {
        HashSet dupesSet = new HashSet(inHostIDs.length);
        Vector targets = new Vector(inHostIDs.length);
        try {
            HostIDSet hostsInSet = null;
            Vector<String> hostsNotInSet = new Vector<String>();
            if (inLimitToHostSet != null) {
                HostSetID setID = SingleHostSetQuery.byName(inLimitToHostSet).selectSummaryView().getID();
                SummaryHost[] allHosts = setID.getAllHostsQuery().selectSummaryView();
                hostsInSet = new HostIDSet();
                for (int i = 0; i < allHosts.length; ++i) {
                    hostsInSet.add(allHosts[i].getID());
                }
            }
            for (int i = 0; i < inHostIDs.length; ++i) {
                if (hostsInSet != null) {
                    if (hostsInSet.contains(inHostIDs[i])) {
                        PlanPreprocessor.resolveTargetAndAddNonDupes(inHostIDs[i], inResolver, targets, dupesSet);
                        continue;
                    }
                    SummaryHost nonSetHost = inHostIDs[i].getByIDQuery().selectSummaryView();
                    hostsNotInSet.add(nonSetHost.getName());
                    continue;
                }
                PlanPreprocessor.resolveTargetAndAddNonDupes(inHostIDs[i], inResolver, targets, dupesSet);
            }
            if (hostsNotInSet.size() > 0) {
                Object[] allNames = hostsNotInSet.toArray(new String[hostsNotInSet.size()]);
                throw new PlanExecutionException(new ROXMessage("pe.TARGET_NOT_IN_SET", Util.getStringFromArray(allNames, ","), inLimitToHostSet));
            }
        }
        catch (NoResultsFoundException ex) {
            throw new PlanExecutionException(new ROXMessage("pe.HOST_SET_DNE_FOR_LIMIT", inLimitToHostSet));
        }
        catch (PersistenceManagerException ex) {
            throw new PlanExecutionException(ex);
        }
        catch (RPCException ex) {
            throw new PlanExecutionException(ex);
        }
        return targets.toArray(new Target[targets.size()]);
    }

    private static void resolveTargetAndAddNonDupes(HostID inHostID, HostResolver inResolver, Vector inTargets, HashSet inDupesSet) throws PersistenceManagerException, RPCException, PlanExecutionException {
        Target theTarget = Target.create(inHostID, inHostID, inResolver);
        if (inDupesSet.add(theTarget.getID())) {
            inTargets.add(theTarget);
        }
    }

    protected void handleInstallStep(InstallStep inInstallStep, int inStepNum, CompiledSimpleSubplan inSubplan, CompiledPlan inPlan) throws PlanExecutionException {
        ComponentSelector theCompSelector = this.mCurrSubplanPrompt.getComponentSelector(this.mCurrComponentSelectors.size());
        VariableSettingsSelector theSelector = theCompSelector.getCurrent();
        if (theSelector == null) {
            throw new PlanExecutionException(new ROXMessage("pe.NO_COMPONENT_BUILDS", new String[]{theCompSelector.getComponentRef().getComponentName(), inSubplan.getName()}));
        }
        this.mCurrComponentSelectors.add(theCompSelector);
    }
}

