/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.executor;

import com.raplix.rolloutexpress.event.ROXStepFailedEvent;
import com.raplix.rolloutexpress.event.ROXStepStartEvent;
import com.raplix.rolloutexpress.executor.CompiledPlanExecutor;
import com.raplix.rolloutexpress.executor.ExecutionState;
import com.raplix.rolloutexpress.executor.MultiStepExecutor;
import com.raplix.rolloutexpress.executor.PlanDeadlockException;
import com.raplix.rolloutexpress.executor.PlanExecutionException;
import com.raplix.rolloutexpress.executor.PlanExecutorMessages;
import com.raplix.rolloutexpress.executor.PlanPermissionException;
import com.raplix.rolloutexpress.executor.PlanRecorder;
import com.raplix.rolloutexpress.executor.PlanTargetedConfigContext;
import com.raplix.rolloutexpress.executor.StepInfo;
import com.raplix.rolloutexpress.executor.target.TargetID;
import com.raplix.rolloutexpress.executor.task.RegularFactory;
import com.raplix.rolloutexpress.executor.virtual.VACreationData;
import com.raplix.rolloutexpress.executor.virtual.VirtualAgent;
import com.raplix.rolloutexpress.executor.virtual.VirtualAgentManager;
import com.raplix.rolloutexpress.message.ROXMessageManager;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.systemmodel.hostdbx.Host;
import com.raplix.rolloutexpress.systemmodel.plandb.ExecStep;
import com.raplix.util.logger.Logger;
import com.raplix.util.threads.Context;
import com.raplix.util.threads.RunnableContext;
import com.raplix.util.threads.ThreadAbortedException;

public class PlanExecutionRunner
extends RunnableContext
implements PlanExecutorMessages {
    protected ExecutionState mExecState;
    protected VirtualAgent mVirtualAgent;
    private int mAcquireHostMap;
    private VACreationData mVAData;
    private Throwable mTerminationException;
    public static final String NAME_PREFIX = "PER-";

    protected PlanExecutionRunner(Context inParent, ExecutionState inExecState, VACreationData inVAData, int inAcquireHostMap) {
        super(NAME_PREFIX + inVAData.getTarget().getInitialHost().getName(), inParent);
        this.mExecState = inExecState;
        this.mTerminationException = null;
        this.mAcquireHostMap = inAcquireHostMap;
        this.mVAData = inVAData;
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("Created PlanExecutionRunner: plan " + inExecState.getCompiledSubplan().getPlanData().getName() + ":" + inExecState.getRunLevel(), this);
        }
    }

    public String getName() {
        return super.getName().substring(NAME_PREFIX.length());
    }

    protected void safeRun() throws Exception {
        this.performTestflow();
        this.mVirtualAgent = this.getRetargetedVA(this.mExecState, this.mVAData, null, true, false);
        if (this.mExecState.getCurrPlanTargetedCtx() == null) {
            this.mExecState.setPlanTargetedCtx(new PlanTargetedConfigContext(this.mVirtualAgent, this.mExecState));
        }
        this.executeSteps(this.mVirtualAgent);
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("PERunner finished for plan " + this.mExecState.getCompiledSubplan().getPlanData().getName() + " and " + this.mExecState.getRunLevel() + " runlevel", this);
        }
    }

    public VirtualAgent getRetargetedVA(ExecutionState inState, VACreationData inVAData, StepInfo inParentStep, boolean inSetupCGs, boolean inSuppressAccessChecks) throws PersistenceManagerException, PlanExecutionException {
        PlanRecorder thePR = inState.getPlanRecorder();
        StepInfo currentStep = null;
        if (inParentStep == null) {
            currentStep = thePR.findStep(this.mAcquireHostMap, inVAData.getTarget().getID(), inState.getRunLevel());
        } else {
            boolean dynamicFlag = inParentStep.getChildrenMappable();
            inParentStep.setChildrenMappable(false);
            currentStep = thePR.createStep(135, inParentStep.getStepMap(), inParentStep);
            inParentStep.setChildrenMappable(dynamicFlag);
        }
        int curSubplanIndex = inState.getCompiledSubplan().getSubplanIndex();
        String planName = inState.getCompiledSubplan().getName();
        ROXStepStartEvent sse = thePR.createSSE(currentStep, curSubplanIndex);
        thePR.setEventMessage(sse, ROXMessageManager.messageAsString("pe.step.ACQUIRE_HOST"));
        thePR.sendEvent(sse);
        VirtualAgentManager vaMgr = this.getVirtualAgentManager();
        VirtualAgent theVA = null;
        try {
            theVA = vaMgr.checkout(inState.getRunLevel(), inVAData, planName, inState, this, inSuppressAccessChecks);
            this.updateHeartbeatPinger(true, inVAData.getTarget().getPhysicalHost());
            if (inSetupCGs) {
                this.setupConfigGenerators(inVAData, inState, theVA);
            }
        }
        catch (PlanDeadlockException deadex) {
            ROXStepFailedEvent sfe = thePR.createSFE(currentStep, curSubplanIndex, 4, deadex);
            thePR.setEventMessage(sfe, "pe.hostconnect.HOST_ACQUIRE_LOCK_ERROR");
            thePR.sendEvent(sfe);
            if (Logger.isDebugEnabled(this)) {
                Logger.debug("Locking host results ina deadlock", deadex, this);
            }
            throw deadex;
        }
        catch (PlanPermissionException permex) {
            ROXStepFailedEvent sfe = thePR.createSFE(currentStep, curSubplanIndex, 4, permex);
            thePR.setEventMessage(sfe, "pe.hostconnect.HOST_ACQUIRE_PERM_ERROR");
            thePR.sendEvent(sfe);
            throw permex;
        }
        catch (CGSetupException cgex) {
            ROXStepFailedEvent sfe = thePR.createSFE(currentStep, curSubplanIndex, 4, cgex);
            thePR.setEventMessage(sfe, "pe.hostconnect.HOST_ACQUIRE_CG_ERROR");
            thePR.sendEvent(sfe);
            throw cgex;
        }
        catch (PlanExecutionException conex) {
            ROXStepFailedEvent sfe = thePR.createSFE(currentStep, curSubplanIndex, 4, conex);
            thePR.setEventMessage(sfe, "pe.hostconnect.HOST_ACQUIRE_CONNECT_ERROR");
            thePR.sendEvent(sfe);
            throw conex;
        }
        finally {
            thePR.sendEvent(thePR.createSCE(currentStep, curSubplanIndex));
        }
        return theVA;
    }

    public Throwable getTerminationException() {
        return this.mTerminationException;
    }

    public TargetID getTargetID() {
        return this.mVAData.getTarget().getID();
    }

    public void performTestflow() throws InterruptedException {
        this.testFlow();
    }

    private void setTargetStatus(int inStatus) throws PlanExecutionException {
        this.mExecState.getPlanRecorder().setTargetStatus(this.mVAData.getTarget().getID(), inStatus, this.mVAData.getTarget().getInitialHost().getName());
    }

    protected void setupConfigGenerators(VACreationData inVAData, ExecutionState inState, VirtualAgent inAgent) throws CGSetupException {
        try {
            if (inVAData.getCGMgr() != null) {
                inState.setCurrConfigGenerator(inState.getCompiledSubplan().createCGForSubplan(inVAData.getTopLevelCG(), inAgent, inState, inVAData.getCGMgr(), false));
                inState.setCurrPasswdSafeConfigGenerator(inState.getCompiledSubplan().createCGForSubplan(inVAData.getTopLevelPasswdSafeCG(), inAgent, inState, inVAData.getCGMgr(), true));
            }
        }
        catch (PlanExecutionException ex) {
            throw new CGSetupException(ex);
        }
    }

    protected void updateHeartbeatPinger(boolean fAdd, Host inPhysicalHost) {
        if (this.getParent() instanceof CompiledPlanExecutor) {
            CompiledPlanExecutor cpe = (CompiledPlanExecutor)this.getParent();
            if (fAdd) {
                cpe.addHeartbeatHost(inPhysicalHost);
            } else {
                if (Logger.isDebugEnabled(this)) {
                    Logger.debug("Finishing the PER - removing", this);
                }
                cpe.removeHeartbeatHost(inPhysicalHost);
            }
        }
    }

    protected void executeSteps(VirtualAgent inVirtualAgent) throws PlanExecutionException, InterruptedException {
        ExecStep[] executionSteps = this.mExecState.getCompiledSubplan().getExecSteps();
        MultiStepExecutor.execMultiSteps(null, executionSteps, this.mExecState, 0, inVirtualAgent, new RegularFactory());
    }

    protected VirtualAgentManager getVirtualAgentManager() {
        return this.mExecState.getTaskInfo().getVirtualAgentManager();
    }

    protected void failed(Throwable t) {
        block3: {
            super.failed(t);
            this.updateHeartbeatPinger(false, this.mVAData.getTarget().getPhysicalHost());
            this.mTerminationException = t;
            try {
                this.setTargetStatus(2);
            }
            catch (PlanExecutionException pee) {
                if (!Logger.isErrorEnabled(this)) break block3;
                Logger.error("pe.ERR_CANT_SET_TARGET_STATUS", pee, this);
            }
        }
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("PER failed", t, this);
        }
    }

    protected void ended() {
        block2: {
            super.ended();
            try {
                this.setTargetStatus(1);
            }
            catch (PlanExecutionException pee) {
                if (!Logger.isErrorEnabled(this)) break block2;
                Logger.error("pe.ERR_CANT_SET_TARGET_STATUS", pee, this);
            }
        }
    }

    protected void aborted(ThreadAbortedException ex) {
        block4: {
            super.aborted(ex);
            this.updateHeartbeatPinger(false, this.mVAData.getTarget().getPhysicalHost());
            if (this.mExecState.getTaskInfo().getTaskWasAborted()) {
                this.mExecState.getPlanRecorder().sendEvent(this.mExecState.getPlanRecorder().createTAE(this.getTargetID()), true);
            }
            if (Logger.isDebugEnabled(this)) {
                Logger.debug("PER Aborted: " + ex, ex, this);
            }
            this.mTerminationException = ex;
            try {
                this.setTargetStatus(2);
            }
            catch (PlanExecutionException pee) {
                if (!Logger.isErrorEnabled(this)) break block4;
                Logger.error("pe.ERR_CANT_SET_TARGET_STATUS", pee, this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void release() throws Exception {
        block3: {
            try {
                super.release();
                Object var2_1 = null;
                if (this.mVirtualAgent == null) break block3;
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                if (this.mVirtualAgent != null) {
                    this.getVirtualAgentManager().release(this.mVirtualAgent, this, this.mExecState.getTaskInfo());
                }
                this.mExecState.setPlanTargetedCtx(null);
                throw throwable;
            }
            this.getVirtualAgentManager().release(this.mVirtualAgent, this, this.mExecState.getTaskInfo());
        }
        this.mExecState.setPlanTargetedCtx(null);
    }

    protected VirtualAgent getVirtualAgent() {
        return this.mVirtualAgent;
    }

    protected class CGSetupException
    extends PlanExecutionException {
        private CGSetupException(PlanExecutionException ex) {
            super(ex);
        }
    }
}

