/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.executor;

import com.raplix.rolloutexpress.executor.CompiledPlan;
import com.raplix.rolloutexpress.executor.PlanExecutionException;
import com.raplix.rolloutexpress.executor.SubplanInvoker;
import com.raplix.rolloutexpress.message.ROXMessage;
import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.systemmodel.folderdb.FolderID;
import com.raplix.rolloutexpress.systemmodel.plandb.ExecStep;
import com.raplix.rolloutexpress.systemmodel.plandb.ExecSubplanStep;
import com.raplix.rolloutexpress.systemmodel.plandb.ExecutionPlan;
import com.raplix.rolloutexpress.systemmodel.plandb.ExecutionPlanData;
import com.raplix.rolloutexpress.systemmodel.plandb.InlineSubplanStep;
import com.raplix.rolloutexpress.systemmodel.plandb.SingleExecutionPlanQuery;
import com.raplix.util.logger.Logger;
import java.util.Stack;

public class PlanCompiler {
    public CompiledPlan compilePlan(ExecutionPlan inPlan) throws PlanExecutionException {
        CompiledPlan theCPlan = new CompiledPlan(inPlan);
        this.processPlan(new SubplanInvoker(inPlan, inPlan.getID(), null), theCPlan, new Stack());
        return theCPlan;
    }

    private void processPlan(SubplanInvoker inCaller, CompiledPlan ioCompiledPlan, Stack ioCallingChain) throws PlanExecutionException {
        if (inCaller.getPlanData().isSimplePlan()) {
            if (Logger.isDebugEnabled(this)) {
                Logger.debug("Processing SimplePlan: " + inCaller.getPlanData().getName(), this);
            }
            ioCompiledPlan.addSimpleSubplan(inCaller, ioCallingChain);
        } else {
            if (Logger.isDebugEnabled(this)) {
                Logger.debug("Processing ComplexPlan: " + inCaller.getPlanData().getName(), this);
            }
            ExecStep[] theSteps = inCaller.getPlanData().getExecSteps();
            ioCallingChain.push(inCaller);
            block4: for (int i = 0; i < theSteps.length; ++i) {
                ExecStep currStep = theSteps[i];
                SubplanInvoker caller = null;
                switch (currStep.getStepType()) {
                    case 104: {
                        ExecSubplanStep theExecSubplanStep = (ExecSubplanStep)currStep;
                        ExecutionPlan callingPlan = PlanCompiler.getNonInlineCallingPlan(ioCallingChain);
                        ExecutionPlan subplan = this.lookupSubplan(callingPlan, theExecSubplanStep);
                        this.verifyPlanNotRecursive(subplan, ioCallingChain);
                        caller = new SubplanInvoker(subplan, subplan.getID(), theExecSubplanStep);
                        this.processPlan(caller, ioCompiledPlan, ioCallingChain);
                        continue block4;
                    }
                    case 117: {
                        InlineSubplanStep theInlineStep = (InlineSubplanStep)currStep;
                        caller = new SubplanInvoker(theInlineStep, inCaller.getSubplanPlanID(), null);
                        this.processPlan(caller, ioCompiledPlan, ioCallingChain);
                        continue block4;
                    }
                }
            }
            ioCallingChain.pop();
        }
    }

    private void verifyPlanNotRecursive(ExecutionPlan inPlan, Stack inCallingChain) throws PlanExecutionException {
        SubplanInvoker[] allInvokers = inCallingChain.toArray(new SubplanInvoker[inCallingChain.size()]);
        for (int i = 0; i < allInvokers.length; ++i) {
            if (!inPlan.getID().equals(allInvokers[i].getSubplanPlanID())) continue;
            throw new PlanExecutionException(new ROXMessage("pe.RECURSIVE_PLAN", inPlan.getFullName()));
        }
    }

    static ExecutionPlan getNonInlineCallingPlan(Stack inCallingChain) {
        for (int i = inCallingChain.size() - 1; i >= 0; --i) {
            SubplanInvoker caller = (SubplanInvoker)inCallingChain.get(i);
            ExecutionPlanData planData = caller.getPlanData();
            if (!(planData instanceof ExecutionPlan)) continue;
            return (ExecutionPlan)planData;
        }
        return null;
    }

    private ExecutionPlan lookupSubplan(ExecutionPlan callingPlan, ExecSubplanStep inStep) throws PlanExecutionException {
        FolderID path;
        String planPath = inStep.getPlanPath();
        String planName = inStep.getPlanName();
        String planVersion = inStep.getPlanVersion();
        ExecutionPlan thePlan = null;
        try {
            path = callingPlan.getPath().getByResolvedPathQuery(planPath).selectSummaryView().getID();
        }
        catch (PersistenceManagerException e) {
            throw new PlanExecutionException("pe.ERR_INVALID_EXEC_SUBPLAN_PATH", (Throwable)e, planPath);
        }
        catch (RPCException e) {
            throw new PlanExecutionException("pe.ERR_INVALID_EXEC_SUBPLAN_PATH", (Throwable)e, planPath);
        }
        try {
            thePlan = SingleExecutionPlanQuery.byName(path, planName, planVersion).select();
        }
        catch (Exception e) {
            String fullName = path.getFullPathString() + planName;
            if (planVersion == null) {
                planVersion = "1.0";
            }
            throw new PlanExecutionException("pe.ERR_PLAN_NOT_FOUND_DB", new Object[]{fullName, planVersion});
        }
        return thePlan;
    }
}

